﻿using NLog;
using Prism.Navigation;
using System.ComponentModel;
using System.Reactive.Disposables;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;

namespace TestNarou3.Adaptor.Gateway.ViewModel
{
    internal class BookmarkViewModel : IBookmarkViewModel, IDestructible, IDisposable
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

#pragma warning disable CS0067
        public event PropertyChangedEventHandler PropertyChanged;
#pragma warning restore CS0067

        private readonly CompositeDisposable disposables = new();
        private bool disposedValue;

        #region IDestructible

        public void Destroy()
        {
            this.Dispose();
        }

        #endregion

        #region IDisposable

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    this.disposables.Dispose();

                    logger.Trace("BookmarkViewModel disposed.");
                }

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            Dispose(disposing: true);
            GC.SuppressFinalize(this);
        }

        #endregion

    }
}
