﻿using Microsoft.UI.Xaml.Media.Imaging;
using NLog;
using Reactive.Bindings;
using System.Reactive.Disposables;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel.Child;
using TestNarou3.Domain.Model.Entity.Child;
using TestNarou3.Infra.Core.Resource;

namespace TestNarou3.Adaptor.Gateway.ViewModel.Child
{
    internal partial record class BookmarkCategoryRowViewModel(
        int Index,
        BitmapImage ItemImage,
        ReadOnlyReactiveProperty<string> Name,
        ReadOnlyReactiveProperty<int> Count,
        IBookmarkCategoryViewModel Parent,
        BookmarkCategoryRow Source
    ) : IBookmarkCategoryRowViewModel, IDisposable
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        private readonly CompositeDisposable disposables = new();
        private bool disposedValue;

        public BookmarkCategoryRowViewModel(
                BookmarkCategoryRow row, IBookmarkCategoryViewModel parent) : this(
            Index:      -1,
            ItemImage:  ImageHelper.FolderImage,
            Name:       null,
            Count:      null,
            Parent:     parent,
            Source:     row
        )
        {
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    this.disposables.Dispose();
                    logger.Trace("BookmarkCategoryRowViewModel[{0}] disposed.", this.Index);
                }

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            Dispose(disposing: true);
            GC.SuppressFinalize(this);
        }
    }
}
