﻿using NLog;
using Reactive.Bindings;
using System.Reactive.Disposables;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel.Child;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Adaptor.Gateway.ViewModel.Child
{
    internal partial record class BookmarkDetailListRowViewModel
            : IBookmarkDetailListRowViewModel, IDisposable
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        public string NCode { get; private set; }
        public ReadOnlyReactiveProperty<string> Summary { get; private set; }
        public ReadOnlyReactiveProperty<string> Title { get; private set; }
        public ReadOnlyReactiveProperty<string> Writer { get; private set; }
        public ReadOnlyReactiveProperty<string> End { get; private set; }
        public ReadOnlyReactiveProperty<int> GeneralAllNo { get; private set; }
        public ReadOnlyReactiveProperty<int> Time { get; private set; }
        public ReadOnlyReactiveProperty<string> IsStop { get; private set; }
        public ReadOnlyReactiveProperty<int> GlobalPoint { get; private set; }
        public ReadOnlyReactiveProperty<int> MinPerAllNo { get; private set; }
        public ReadOnlyReactiveProperty<int> PointPerMin { get; private set; }
        public ReadOnlyReactiveProperty<int> DailyPoint { get; private set; }
        public ReadOnlyReactiveProperty<int> WeeklyPoint { get; private set; }
        public ReadOnlyReactiveProperty<int> MonthlyPoint { get; private set; }
        public ReadOnlyReactiveProperty<int> QuarterPoint { get; private set; }
        public ReadOnlyReactiveProperty<int> YearlyPoint { get; private set; }
        public ReadOnlyReactiveProperty<int> FavNovelCnt { get; private set; }
        public ReadOnlyReactiveProperty<int> ImpressionCnt { get; private set; }
        public ReadOnlyReactiveProperty<int> ReviewCnt { get; private set; }
        public ReadOnlyReactiveProperty<int> AllPoint { get; private set; }
        public ReadOnlyReactiveProperty<int> AllHyokaCnt { get; private set; }
        public ReadOnlyReactiveProperty<string> GeneralFirstUp { get; private set; }
        public ReadOnlyReactiveProperty<string> GeneralLastUp { get; private set; }
        public ReadOnlyReactiveProperty<string> NovelUpdatedAt { get; private set; }

        public IBookmarkDetailListViewModel Parent { get; private set; }
        public BookmarkDetailListRow Source { get; private set; }

        private readonly CompositeDisposable disposables = new();
        private bool disposedValue;

        public BookmarkDetailListRowViewModel(
                BookmarkDetailListRow source, IBookmarkDetailListViewModel parent)
        {
            this.Source = source;
            this.Parent = parent;
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    this.disposables.Dispose();
                    logger.Trace("BookmarkDetailListRowViewModel[{0}] disposed.", this.NCode);
                }

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            Dispose(disposing: true);
            GC.SuppressFinalize(this);
        }
    }
}
