﻿using NLog;
using Prism.Navigation;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;
using System.ComponentModel;
using System.Reactive.Disposables;
using TestNarou3.Adaptor.Boundary.Controller;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.Domain.Model.Config;
using TestNarou3.UseCase.Request;

namespace TestNarou3.Adaptor.Gateway.ViewModel
{
    internal class LoginFormViewModel : ILoginFormViewModel, IDestructible, IDisposable
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

#pragma warning disable CS0067
        public event PropertyChangedEventHandler PropertyChanged;
#pragma warning restore CS0067

        public ReactiveProperty<string> NarouID { get; }
        public ReactiveProperty<string> Password { get; }
        public ReactiveCommand CommandLogin { get; }

        private readonly IAppWindowController wc;

        private readonly CompositeDisposable disposables = new();
        private bool disposedValue;

        public LoginFormViewModel(IAppWindowController wc)
        {
            this.wc = wc;

            this.NarouID = new ReactiveProperty<string>().AddTo(disposables);
            this.Password = new ReactiveProperty<string>().AddTo(disposables);

            this.CommandLogin = new ReactiveCommand().WithSubscribe(OnLogin).AddTo(disposables);
        }

        #region IDestructible, IDisposable

        public void Destroy()
        {
            this.Dispose();
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    this.disposables.Dispose();

                    logger.Trace("LoginFormViewModel disposed.");
                }

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            // このコードを変更しないでください。クリーンアップ コードを 'Dispose(bool disposing)' メソッドに記述します
            Dispose(disposing: true);
            GC.SuppressFinalize(this);
        }

        #endregion

        #region event handler

        private void OnLogin()
        {
            logger.Info("OnLogin");

            NarouLoginRequest req1 = new(this.NarouID.Value, this.Password.Value);

            var res1 = this.wc.Execute(req1);

            if (res1.IsAborted)
            {
                return;
            }

            this.wc.NavigateBookmarkView();
        }

        #endregion

        #region VM operation

        public void SetSettings(NarouLoginSettings settings)
        {
            this.NarouID.Value = settings.NarouID;
            this.Password.Value = settings.Password;
        }

        #endregion

    }
}
