﻿using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.UseCase.Boundary.Presenter;
using TestNarou3.UseCase.Request;
using TestNarou3.UseCase.Response;

namespace TestNarou3.Adaptor.Presenter
{
    internal class AppConfigLoadPresenter : IAppConfigLoadPresenter
    {
        private readonly ILoginFormViewModel vm;

        public AppConfigLoadPresenter(ILoginFormViewModel vm)
        {
            this.vm = vm;
        }

        public AppConfigLoadResponse Present(
                AppConfigLoadRequest req, AppConfigLoadResponse res)
        {
            var settings = res.AppConfig.NarouLoginSettings;

            this.vm.SetSettings(settings);

            return res;
        }
    }
}
