﻿using AutoMapper;
using Reactive.Bindings;
using System.Reactive.Linq;
using TestNarou3.Adaptor.Gateway.ViewModel.Child;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Adaptor.Translator.Converter
{
    internal class BookmarkCategoryTextResolver
            : IValueResolver<BookmarkCategoryRow, BookmarkCategoryRowViewModel, ReadOnlyReactiveProperty<string>>
    {
        private const string FORMAT = "{0} ({1:#,##0})";

        public ReadOnlyReactiveProperty<string> Resolve(
                BookmarkCategoryRow source, BookmarkCategoryRowViewModel destination,
                ReadOnlyReactiveProperty<string> destMember, ResolutionContext context)
        {
            return source.Name.CombineLatest(source.Count, (name, count) => Convert(name, count)).ToReadOnlyReactiveProperty();
        }

        private static string Convert(string name, int count)
        {
            return string.Format(FORMAT, name, count);
        }
    }
}
