﻿using AutoMapper;
using Reactive.Bindings;
using System;
using System.Linq;
using System.Reactive.Linq;

namespace TestNarou3.Adaptor.Translator.Converter
{
    internal class SubstringConverter
            : IValueConverter<IObservable<string>, ReadOnlyReactiveProperty<string>>
    {
        private readonly int length;

        public SubstringConverter(int length)
        {
            this.length = length;
        }

        public ReadOnlyReactiveProperty<string> Convert(
                IObservable<string> sourceMember, ResolutionContext context)
        {
            return sourceMember
                    .Select(v => v.Substring(0, this.length))
                    .ToReadOnlyReactiveProperty();
        }
    }
}
