﻿using AutoMapper;
using Reactive.Bindings;
using System.Collections.Generic;
using System.Reactive.Linq;
using System.Text;
using TestNarou3.Adaptor.Gateway.ViewModel.Child;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Adaptor.Translator.Converter
{
    internal class SummaryResolver
            : IValueResolver<BookmarkDetailListRow, BookmarkDetailListRowViewModel, ReadOnlyReactiveProperty<string>>
    {
        public ReadOnlyReactiveProperty<string> Resolve(
                BookmarkDetailListRow source, BookmarkDetailListRowViewModel destination,
                ReadOnlyReactiveProperty<string> destMember, ResolutionContext context)
        {
            return source.Title.CombineLatest(
                source.Writer,
                source.Story,
                source.BigGenre,
                source.Genre,
                source.Keyword,
                source.NovelType,
                source.IsR15,
                source.IsBL,
                source.IsGL,
                source.IsZankoku,
                source.IsTensei,
                source.IsTenni,
                (
                    title,
                    writer,
                    story,
                    bigGenre,
                    genre,
                    keyword,
                    novelType,
                    isR15,
                    isBL,
                    isGL,
                    isZankoku,
                    isTensei,
                    isTenni
                ) => Convert(
                    title,
                    writer,
                    story,
                    bigGenre,
                    genre,
                    keyword,
                    novelType,
                    isR15,
                    isBL,
                    isGL,
                    isZankoku,
                    isTensei,
                    isTenni
                )
            ).ToReadOnlyReactiveProperty();
        }

        private static IDictionary<int, string> BigGenreMap => new Dictionary<int, string>()
        {
            { 1, "恋愛" },
            { 2, "ファンタジー" },
            { 3, "文芸" },
            { 4, "SF" },
            { 99, "その他" },
            { 98, "ノンジャンル" },
        };

        private static IDictionary<int, string> GenreMap => new Dictionary<int, string>()
        {
            { 101, "異世界" },
            { 102, "現実世界" },
            { 201, "ハイファンタジー" },
            { 202, "ローファンタジー" },
            { 301, "純文学" },
            { 302, "ヒューマンドラマ" },
            { 303, "歴史" },
            { 304, "推理" },
            { 305, "ホラー" },
            { 306, "アクション" },
            { 307, "コメディー" },
            { 401, "VRゲーム" },
            { 402, "宇宙" },
            { 403, "空想科学" },
            { 404, "パニック" },
            { 9901, "童話" },
            { 9902, "詩" },
            { 9903, "エッセイ" },
            { 9904, "リプレイ" },
            { 9999, "その他" },
            { 9801, "ノンジャンル" },
        };

        private static string Convert(
            string title,
            string writer,
            string story,
            int bigGenre,
            int genre,
            string keyword,
            int novelType,
            int isR15,
            int isBL,
            int isGL,
            int isZankoku,
            int isTensei,
            int isTenni
        )
        {
            StringBuilder buf = new();

            buf.Append(title);
            buf.Append('（');
            buf.Append(novelType switch { 1 => "連載", 2 => "短編", _ => "不明" });
            buf.Append('：');
            buf.Append(BigGenreMap[bigGenre]);
            buf.Append('／');
            buf.Append(GenreMap[genre]);
            buf.Append('）');
            buf.AppendLine();
            buf.Append('／');
            buf.AppendLine(writer);
            buf.AppendLine();
            buf.Append("必須キーワード：");
            if (isR15 == 1) buf.Append("R15 ");
            if (isBL == 1) buf.Append("BL ");
            if (isGL == 1) buf.Append("GL ");
            if (isZankoku == 1) buf.Append("残酷 ");
            if (isTensei == 1) buf.Append("異世界転生 ");
            if (isTenni == 1) buf.Append("異世界転移 ");
            buf.AppendLine();
            buf.Append("キーワード：");
            buf.Append(keyword);
            buf.AppendLine();
            buf.AppendLine();
            buf.Append(story);

            return buf.ToString();
        }
    }
}
