﻿using AutoMapper;
using AutoMapper.Internal;
using TestNarou3.Domain.Model.API;
using TestNarou3.Domain.Model.Entity.Child;
using TestNarou3.Domain.Translator;

namespace TestNarou3.Domain
{
    public class DomainMappingProfile : Profile
    {
        public DomainMappingProfile()
        {
            ShouldMapField = x => false;
            ShouldMapMethod = x => false;
            ShouldMapProperty = x => true;
            ShouldUseConstructor = x => false;

            IProfileExpressionInternal profileOptions = this.Internal();

            BookmarkCategoryRowTranslator
                    .ConfigureMapper(CreateMap<NarouCategoryInfo, BookmarkCategoryRow>());

            BookmarkDetailListRowTranslator
                    .ConfigureMapper(CreateMap<NarouNovelDetailInfo, BookmarkDetailListRow>());
        }
    }
}
