﻿using NLog;
using Prism.Ioc;
using Prism.Modularity;
using TestNarou3.Domain.Boundary.Service;
using TestNarou3.Domain.Service;
using TestNarou3.Domain.Translator;

namespace TestNarou3.Domain
{
    public class DomainModule : IModule
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        public void RegisterTypes(IContainerRegistry containerRegistry)
        {
            ///
            /// Services
            ///

            containerRegistry.RegisterSingleton<IAppConfigService, AppConfigService>();
            containerRegistry.RegisterSingleton<INarouService, NarouService>();

            //
            // Translators
            //
            containerRegistry.RegisterSingleton<IBookmarkCategoryRowTranslator, BookmarkCategoryRowTranslator>();
            containerRegistry.RegisterSingleton<IBookmarkDetailListRowTranslator, BookmarkDetailListRowTranslator>();

            logger.Trace("RegisterTypes end");
        }

        public void OnInitialized(IContainerProvider containerProvider)
        {
        }
    }
}
