﻿using AutoMapper;
using TestNarou3.Domain.Model.API;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Domain.Translator
{
    internal class BookmarkCategoryRowTranslator : IBookmarkCategoryRowTranslator
    {
        private readonly IMapper mapper;

        public BookmarkCategoryRowTranslator(IMapper mapper)
        {
            this.mapper = mapper;
        }

        public BookmarkCategoryRow Translate(NarouCategoryInfo info, int index)
        {
            BookmarkCategoryRow row = info != null
                    ? mapper.Map(info, new BookmarkCategoryRow(index))
                    : null;

            return row;
        }

        internal static void ConfigureMapper(
                IMappingExpression<NarouCategoryInfo, BookmarkCategoryRow> mappingExpression)
        {
            mappingExpression
                    .ForMember(d => d.Index,        opts => opts.Ignore())
                    .ForMember(d => d.Name,         opts => opts.MapFrom(s => s.Name))
                    .ForMember(d => d.Count,        opts => opts.MapFrom(s => s.Count))
                    .DisableCtorValidation();
        }
    }
}
