﻿using CleanAuLait.Domain.Service;
using CleanAuLait.UseCase.Interactor;
using CleanAuLait.UseCase.Response;
using TestNarou3.Domain.Boundary.Service;
using TestNarou3.UseCase.Boundary.Interactor;
using TestNarou3.UseCase.Request;
using TestNarou3.UseCase.Response;

namespace TestNarou3.UseCase.Interactor
{
    internal class AppConfigSaveInteractor
            : AbstractUseCaseInteractor<AppConfigSaveRequest, AppConfigSaveResponse>
            , IAppConfigSaveInteractor
    {
        private readonly IAppConfigService service;

        public AppConfigSaveInteractor(
                IAppConfigService service
        )
        {
            this.service = service;
        }

        public override AppConfigSaveResponse Interact(AppConfigSaveRequest req)
        {
            try
            {
                this.service.Save();

                return new();
            }
            catch (ServiceException e)
            {
                return UseCaseResponse.Abort<AppConfigSaveResponse>(e.Message);
            }
        }

    }
}
