/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.plugin.moenizer;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JLayeredPane;

/**
 *
 * @author Yu-Tang
 */
public class MoeLayeredPane extends JLayeredPane {
    
    private BufferedImage image;
    private TexturePaint paint;
    private float alpha;
    
    public MoeLayeredPane() {
        super();
        this.image = null;
        this.paint = null;
        this.alpha = MoeConfig.getOpacity();
    }
    
    public MoeLayeredPane(BufferedImage image) {
        super();
        setPicture(image);
        this.alpha = MoeConfig.getOpacity();
    }
    
    public void setBackground(BufferedImage image) {
        setPicture(image);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (image != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setComposite(makeComposite(alpha));

            if (getWidth() > image.getWidth() || getHeight() > image.getHeight()) {
                g2.setPaint(paint);
                g2.fillRect(0, 0, getWidth(), getHeight());
            } else {
                g2.drawImage(image, 0, 0, this);
            }
            
            g2.dispose();
        }
        super.paintComponent(g);
    }

    private AlphaComposite makeComposite(float alpha) {
        int type = AlphaComposite.SRC_OVER;
        return(AlphaComposite.getInstance(type, alpha));
    }
    
    private void setPicture(BufferedImage image) {
        this.image = image;
        
        if (image == null) {
            this.paint = null;
        } else {
            Rectangle rect = new Rectangle(image.getWidth(), image.getHeight());
            this.paint = new TexturePaint(image, rect);
        }
    }
}
