/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.plugin.moenizer.imageloader;

import java.lang.reflect.Method;
import java.net.URL;
import static org.omegat.plugin.moenizer.MoeConfig.*;
import org.omegat.util.Log;

/**
 *
 * @author Yu-Tang
 */
public class ImageLoader {
    
    public static IImageLoader getInstance() {
        Object[] sources = getSources();

        if (sources.length == 0) {
            return null; // no source, no need loader
        }
        
        // default
        return new DefaultImageLoader();
    }
    
    private static Object getAcceptableSource(Class<?> c, Object[] sources) {
        for (Object source: sources) {
            try {
                Method method = c.getDeclaredMethod("isAcceptable", new Class[]{ Object.class });
                boolean isAcceptable = (Boolean) method.invoke(null, source);
                if (isAcceptable) {
                    return source;
                }
            } catch (Exception ex) {
                Log.log(ex);
            }
        }
        return null;
    }
    
}
