/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2013-2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.foldermenu;

import java.io.File;
import java.io.IOException;
import javax.swing.JMenuItem;

/**
 *
 * @author Yu Tang
 */
public class ShellLinkMenuItem extends JMenuItem {

    public ShellLinkMenuItem() {
        super();
    }

    public ShellLinkMenuItem(File file) throws IOException {
        super(file.getName(), MenuHelper.getIcon(file));
        setActionCommand(file.getCanonicalPath());
        addActionListener(MenuHelper.getActionListener());
    }

    public ShellLinkMenuItem(String label) {
        super(label);
        setEnabled(false);
    }

    public JMenuItem getMenuItem() {
        return (JMenuItem) this;
    }

    public void link(File file, String toolTipText) throws IOException {
        setToolTipText(toolTipText);
        setActionCommand(file.getCanonicalPath());
        setIcon(MenuHelper.getIcon(file));
        setEnabled(true);
        
        if (getActionListeners().length == 0) {
            addActionListener(MenuHelper.getActionListener());
        }
    }

    public void unlink() {
        setToolTipText(null);
        setEnabled(false);
        setActionCommand("");
        setIcon(null);
    }

}
