/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTextPaneUI;

/**
 *
 * @author Yu-Tang
 */
public class MoeTextPaneUI extends BasicTextPaneUI implements IMoePaneUI {

    private MoeUIDelegator uiDelegator = null;

    public MoeTextPaneUI() {
        super();
        uiDelegator = new MoeUIDelegator();
        
        // MoeTextPaneUI は個別ペイン用の UI なので、仕様上の制約により不透明度
        // を設定できません（1.0f 固定 = 不透明）。そのため、ここで固定値を設定
        // して、setter を空実装にしておきます。
        uiDelegator.setOpacity(MoeUI.OPACITY_OPAQUE);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);

        uiDelegator.setComponent(c);
    }

    @Override
    public BufferedImage getBackgroundImage() {
        return uiDelegator.getBackgroundImage();
    }

    @Override
    public void setBackgroundImage(BufferedImage image) {
        uiDelegator.setBackgroundImage(image);
    }

    @Override
    public Color getBackgroundColor() {
        return uiDelegator.getBackgroundColor();
    }

    @Override
    public void setBackgroundColor(Color color) {
        uiDelegator.setBackgroundColor(color);
    }

    @Override
    public void setMarginTop(int marginTop) {
        uiDelegator.setMarginTop(marginTop);
    }

    @Override
    protected void paintBackground(Graphics g) {
        uiDelegator.paintBackground(g);
    }

    public MoeTextPaneUI clone() {
        MoeTextPaneUI ui = new MoeTextPaneUI();
        ui.setBackgroundImage(uiDelegator.getBackgroundImage());
        ui.setBackgroundColor(uiDelegator.getBackgroundColor());
        return ui;
    }
}
