;;; -*- Mode: Lisp; Package: EDITOR -*-
;;;
;;; This file is not part of xyzzy.
;;;
; $Id: ruby-fdvr.l,v 040710 2004/07/10 00:00:00 Yukimi_Sake $
;
; FormDesigner-minor-mode for xyzzy
;
; Copyright 2004 Yukio Sakaue <yukimi_sake@mbi.nifty.com>
;
;
; .xyzzy ܂ site-init.l ɈȉǉĂ
;
; (load-librayy "ruby-fdvr.l")
;

(provide "fdvr")

(in-package "editor")

(require "ruby-mode")

(export '(ruby-fdvr-mode ruby-show-fdvr *ruby-frvr-mode-buffer*))

;;; Ruby FormDesigner-vruby Mode ;;;

(defvar-local *ruby-fdvr-mode* nil)

(cond
 ((find "Gates" *modules* :test #'string=)
	(define-key *ruby-mode-map* '(#\S-F11) 'ruby-fdvr-mode))
 (t
	(define-key *ruby-mode-map* '(#\C-c #\f) 'ruby-fdvr-mode)
	))

(defvar *ruby-frvr-mode-buffer* nil)

(defvar *ruby-fdvr-mode-map* nil)
(unless *ruby-fdvr-mode-map*
	(setq *ruby-fdvr-mode-map* (make-sparse-keymap))
	(cond
	 ((find "Gates" *modules* :test #'string=)
		(define-key *ruby-fdvr-mode-map* '(#\F11) 'ruby-show-fdvr))
	 (t
		(define-key *ruby-fdvr-mode-map* '(#\C-c #\C-f) 'ruby-show-fdvr)
		)))

(defun ruby-fdvr-mode (&optional (arg nil sv))
  (interactive "p")
	(when (not (get-buffer-file-name))
		(msgbox "܂ۑĂI")
		(return-from ruby-fdvr-mode))
	(when (eq buffer-mode 'ruby-mode)
		(when (and *ruby-frvr-mode-buffer*
							 (not (eq (selected-buffer) *ruby-frvr-mode-buffer*)))
			(msgbox "̃obt@FormDesignerNĂāI")
			(return-from ruby-fdvr-mode))
		(toggle-mode '*ruby-fdvr-mode* arg sv)
		(if *ruby-fdvr-mode*
				(progn
					(setq mode-name "FormDesigner")
					(delete-hook '*activate-hook* 'verify-buffers-file-modtime)
					(add-hook '*activate-hook* 'ruby-communicate-fdvr)
					(add-hook '*before-delete-buffer-hook* 'ruby-terminate-fdvr)
					(ruby-start-fdvr)
					(set-minor-mode-map *ruby-fdvr-mode-map*)
					(setq *ruby-frvr-mode-buffer* (selected-buffer))
					)
			(progn(setq mode-name "Ruby")
;				(delete-hook *before-delete-buffer-hook* 'ruby-terminate-fdvr)
				(delete-hook '*activate-hook* 'ruby-communicate-fdvr)
				(add-hook '*activate-hook* 'verify-buffers-file-modtime)
				(ruby-shutdown-fdvr)
				(unset-minor-mode-map *ruby-fdvr-mode-map*)
				(setq *ruby-frvr-mode-buffer* nil)))
		(update-mode-line)))

(defun ruby-start-fdvr ()
	;(interactive)
	(setq chan-fdvr nil)
	(save-buffer)
	(shell-execute "rubyw.exe" t (concat "-S FormDesigner.rb " "\""
																			 (get-buffer-file-name) "\""))
	(let((ti (get-internal-real-time)))
		(while 
			(not(progn
						(sleep-for 0.5)
						(if ( > (-(get-internal-real-time)ti) 5000)(progn(message "time over")(return)))
						(ignore-errors
						 (setq chan-fdvr (dde-initiate "FormDesigner" "Edit")))
						chan-fdvr))
			)
		(if chan-fdvr
				(dde-execute chan-fdvr
										 (concat	"initiate," (format nil "~A" (get-window-handle))
															))
		nil)))

(defun ruby-terminate-fdvr (buff)
	(when (eq buff *ruby-frvr-mode-buffer*)
		(ruby-shutdown-fdvr)
		(setq *ruby-frvr-mode-buffer* nil))
	t
	)

(defun ruby-show-fdvr ()
	(interactive)
	(if chan-fdvr (dde-execute chan-fdvr "show") nil)
	)

(defun ruby-shutdown-fdvr ()
	(if chan-fdvr
			(progn
				(dde-terminate chan-fdvr)
				(setq chan-fdvr nil)
				)
		nil
		))

(defun ruby-communicate-fdvr ()
	(when *ruby-fdvr-mode*
		(if chan-fdvr
				(let ((str "")(str1 "")(str2 ""))
					(widen)
					(dde-poke chan-fdvr (format nil "~A" (current-line-number))
										(buffer-substring (point-min)(point-max)))
					(setq str (dde-request chan-fdvr "update"))
					(if (equal "" str) (return-from ruby-communicate-fdvr) nil)
					(string-match "\n" str)
					(setq str1 (substring str 0 (- (match-end 0) 1)))
					(setq str2 (substring str (match-end 0)))
					(delete-region (point-min)(point-max))
					(insert str2)
					(goto-line (parse-integer str1))
					) nil)
		
		)
	)
	
