package hayashi.yuu.tools.properties;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;


@SuppressWarnings("serial")
public class PropertyCheckItem extends hayashi.yuu.tools.properties.PropertyItem {

	public PropertyCheckItem(hayashi.yuu.tools.properties.Properties prop, String name, String title, boolean value, boolean editable) {
		super(prop, name, title, editable);
		field = new JCheckBox(title, Boolean.parseBoolean(prop.getProperty(name, "false")));
		((JCheckBox)field).addActionListener(this);
		createItem(name, title, prop.getProperty(name), editable);
	}

	@Override
	void setupField(String name, String value, boolean editable) {
		this.value = value;
		((JCheckBox)field).setSelected(Boolean.valueOf(value));
		if (!editable) {
			field.setEnabled(editable);
		}
		add(field);
	}
	
	public boolean isSelected() {
		return ((JCheckBox)field).isSelected();
	}
	
	@Override
	JLabel setupLabel(String name, String value) {
		label = new JLabel(name, JLabel.RIGHT);
		//add(label);
		return label;
	}

	@Override
	void createItem(String name, String title, String value, boolean editable) {
		setupLabel(title, value);
		setupField(title, value, editable);
		
		//label.setBounds(0, 0, ITEM_WIDTH_1 - 6, LINE_HEIGHT);
		field.setBounds(ITEM_WIDTH_1, 0, ITEM_WIDTH_2, LINE_HEIGHT);
		setPreferredSize(new Dimension(ITEM_WIDTH_1, LINE_HEIGHT));
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		this.value = Boolean.toString(((JCheckBox)field).isSelected());
		logger.info("[反映] "+ propertyName +" = "+ this.value);
		this.prop.setProperty(propertyName, this.value);
	}
}
