package hayashi.yuu.tools.properties;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

@SuppressWarnings("serial")
public class PropertyFieldItem extends PropertyItem implements FocusListener
{
	public PropertyFieldItem(hayashi.yuu.tools.properties.Properties prop, String name, String title, boolean editable) {
		super(prop, name, title, editable);
		field = new JTextField(value, 20);
		((JTextField)field).addFocusListener(this);
		createItem(name, title, prop.getProperty(name), editable);
	}

	@Override
	void setupField(String name, String value, boolean editable) {
		this.value = value;
		((JTextField)field).setText(value);
		if (!editable) {
			field.setEnabled(editable);
		}
		add(field);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		this.value = ((JTextField)this.field).getText();
		logger.info("[反映] "+ propertyName +" = "+ this.value);
		prop.setProperty(propertyName, this.value);
	}

	/**
	 * このフィールドにカーソルが移ったときの処理
	 */
	public void focusGained(FocusEvent arg0) {
		// 何もしない
	}

	/**
	 * このフィールドから他のフィールドへカーソルが移った時の処理。
	 */
	public void focusLost(FocusEvent arg0) {
		actionPerformed(null);
	}
}
