package jp.co.areaweb.tools.command;
import org.w3c.dom.*;
import javax.xml.transform.TransformerFactory;  // xml-apis.jar
import javax.xml.transform.Transformer;         // xml-apis.jar
import javax.xml.transform.stream.StreamSource; // xml-apis.jar
import javax.xml.transform.stream.StreamResult; // xml-apis.jar
import java.io.*;

/**
 * Jobファイルに記述されたXSLT処理を順次実行する。
 *  このコマンドを利用することによって、MS-DOSとUNIXで別々のシェルファイルを記述する必要がなくなります。
 *
 * @author  Hayashi,Yuu
 * @since	2002/09/19, 11:21
 */
public class Xalan extends XmlJob
{
    /** 
     * Jobファイルに記述されたXSLT処理を順次実行する。
     */
    protected static void execJobElement(NodeList jobgroupNodes) throws Exception {
        execJobElement(jobgroupNodes, null);
    }
    protected static void execJobElement(NodeList jobgroupNodes, File workDir) throws Exception {
        if (debug) {
            System.out.println("Xalan.execJobElement()");
        }
        
        for (int i=0; i < jobgroupNodes.getLength(); i++) {
            Node node = jobgroupNodes.item(i);
            if (node.getNodeType() == Node.ELEMENT_NODE) {
                String tagName = node.getNodeName();
                if (tagName.equals("xslt")) {
                    String xmlStr = "";
                    String xslStr = "";
                    String outputStr = "";
                    NodeList xsltNodes = node.getChildNodes();
                    for (int j=0; j < xsltNodes.getLength(); j++) {
                        Node xsltNode = xsltNodes.item(j);
                        if (xsltNode.getNodeType() == Node.ELEMENT_NODE) {
                            String tagName2 = xsltNode.getNodeName();
                            if (tagName2.equals("xml")) {
                                xmlStr = xsltNode.getFirstChild().getNodeValue();
                            }
                            else if (tagName2.equals("xsl")) {
                                xslStr = xsltNode.getFirstChild().getNodeValue();
                            }
                            else if (tagName2.equals("output")) {
                                outputStr = xsltNode.getFirstChild().getNodeValue();
                            }
                        }
                    }
                    // コマンドの実行
                    if (workDir == null) {
                        execXslt(xmlStr, xslStr, outputStr);
                    }
                    else {
                        execXslt(xmlStr, xslStr, outputStr, workDir);
                    }
                }
            }
        }
    }

    /**
     * xmlファイルをxslファイルで処理した結果をoutputファイルに出力する。
     */
    protected static void execXslt(String xmlStr, String xslStr, String outputStr) throws Exception {
        System.out.println("XALAN("+ xmlStr +" * "+ xslStr +") -> "+ outputStr);
        
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(xslStr));
        transformer.transform(new StreamSource(xmlStr), new StreamResult(new FileOutputStream(outputStr)));
    }
    protected static void execXslt(String xmlStr, String xslStr, String outputStr, File workDir) throws Exception {
        System.out.println("XALAN("+ xmlStr +" * "+ xslStr +") -> "+ outputStr);
        
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(new File(workDir, xslStr)));
        transformer.transform(new StreamSource(new File(workDir, xmlStr)), new StreamResult(new FileOutputStream(new File(workDir, outputStr))));
    }
    
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("exp: java jp.co.areaweb.tools.command.Xalan [jobFileName]");
            return;
        }

        XmlJob.execJob(new File(args[0]));
    }
}
