package hayashi.yuu.tools.mail;

import hayashi.yuu.tools.properties.Properties;
import java.io.FileInputStream;

/**
 * メールアカウント設定情報を保持するインスタンス
 * @author hayashi
 * @version	2010/02/05	項目'MAIL_SMTP_PORT'を追加
 */
public class SiteData {
    public String MAIL_SMTP = "192.168.0.10";
    public String MAIL_SMTP_PORT = "25";
    public String MAIL_FROM = "webserver@xxx.co.jp";
    public String MAIL_TO = "";
    public String MAIL_CC = "";
    public String MAIL_BCC = "";
    
    /**
     * 'POP before SMTP'認証を行うかどうか
     */
    public boolean POP_before_SMTP = false;
    
    /**
     * 'USER_AUTH'認証を行うかどうか
     */
    public boolean USER_AUTH = false;
    
    /**
     * 'STARTTLS'認証を行うかどうか
     */
    public boolean STARTTLS = false;
    
    /**
     * POPサーバー名（'POP before SMTP'認証時のみ）
     */
    public String MAIL_POP = "";
    
    /**
     * POPアカウント（'POP before SMTP'認証時のみ）
     */
    public String USER_ID = "";
    
    /**
     * POPアカウントのパスワード（'POP before SMTP'認証時のみ）
     */
    public String PASSWORD = "";

    /**
     * 指定されたプロパティファイルに定義された値でインスタンスを生成する。
     * @param propertyFile	設定値を定義したプロパティファイルのパス名
     */
    public SiteData(String propertyFile) {
        try {
            Properties properties = new Properties();
            properties.setPasswordItem("MAIL_PASSWORD");
            properties.load(new FileInputStream(propertyFile));

            String str = "";
            if ((str = properties.getProperty("mail.smtp.host")) != null) {
            	MAIL_SMTP = str;
            }
            if ((str = properties.getProperty("mail.smtp.port")) != null) {
            	MAIL_SMTP_PORT = str;
            }
            if ((str = properties.getProperty("mail.smtp.from")) != null) {
            	MAIL_FROM = str;
            }
            if ((str = properties.getProperty("MAIL_TO")) != null) {
            	MAIL_TO = str;
            }
            if ((str = properties.getProperty("MAIL_CC")) != null) {
            	MAIL_CC = str;
            }
            if ((str = properties.getProperty("MAIL_BCC")) != null) {
            	MAIL_BCC = str;
            }
            
            str = properties.getProperty("MAIL_POP_before_SMTP");
            if ((str != null) && str.equals("true")) {
            	POP_before_SMTP = true;
            }
            
            str = properties.getProperty("mail.smtp.auth");
            if ((str != null) && str.equals("true")) {
            	USER_AUTH = true;
            }

            str = properties.getProperty("mail.smtp.starttls.enable");
            if ((str != null) && str.equals("true")) {
            	STARTTLS = true;
            }
            
            if ((str = properties.getProperty("MAIL_POP")) != null) {
            	MAIL_POP = str;
            }
            if ((str = properties.getProperty("mail.smtp.user")) != null) {
            	USER_ID = str;
            }
            if ((str = properties.getProperty("MAIL_PASSWORD")) != null) {
            	PASSWORD = str;
            }
        }
        catch(Exception e) {
            System.out.println(e);
        }
    }
}
