package hayashi.kiban;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import java.io.*;

public class AllShow {
	/** 読み込むXMLファイル名 */
	final static String uri = "FG-JPS-07561-CommPt-20110318-0001.xml";

	/** 主メソッド */
	public void runner() {
		DocumentBuilderFactory factory;
		DocumentBuilder        builder;
		Node root;

		System.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
		System.out.println("<gpx xmlns=\"http://www.topografix.com/GPX/1/1\" version=\"1.1\" creator=\"osmtracker-android\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd \">");
		try {
			factory = DocumentBuilderFactory.newInstance();
			builder = factory.newDocumentBuilder();
			factory.setIgnoringElementContentWhitespace(true);
			factory.setIgnoringComments(true);
			factory.setValidating(true);
			root    = builder.parse(uri);

			showNodes(root, "");
		} catch (ParserConfigurationException e0) {
			System.out.println(e0.getMessage());
		} catch (SAXException e1){
			System.out.println(e1.getMessage());
		} catch (IOException e2) {
			System.out.println(e2.getMessage());
		}

		System.out.println("</gpx>");
	}

	/** nodeの子ノードを全て表示します。子ノードがない場合はなにも出力しません。
	    spaceはノードを表示する前の行頭のスペースです。
	    （再帰処理をしているので注意） */
	public void showNodes(Node node, String space) {
		NodeList nodes = node.getChildNodes();
		for (int i=0; i<nodes.getLength(); i++) {
			Node node2 = nodes.item(i);
			if (node2.getNodeName().equals("CommPt")) {
				showCommPt(node2);
			}
			else {
				showNodes(node2, space + "    ");
			}
		}
	}

	public void showCommPt(Node node) {
		String positionStr = "";
		String typeStr = "";
		String nameStr = "";
		String latStr = "";
		String lonStr = "";
		String dateStr = "";

		NodeList nodes = node.getChildNodes();
		for (int i=0; i < nodes.getLength(); i++) {
			Node node2 = nodes.item(i);
			if (node2.getNodeName().equals("pos")) {
				NodeList nodes3 = node2.getChildNodes();
				for (int j=0; j < nodes3.getLength(); j++) {
					Node node3 = nodes3.item(j);
					if (node3.getNodeName().equals("jps:position")) {
						NodeList nodes4 = node3.getChildNodes();
						for (int k=0; k < nodes4.getLength(); k++) {
							Node node4 = nodes4.item(k);
							if (node4.getNodeName().equals("jps:coordinate")) {
								positionStr = node4.getTextContent();
								String[] str4Ary = positionStr.split(" ");
								latStr = str4Ary[0];
								lonStr = str4Ary[1];
							}
						}
					}
				}
			}
			else if (node2.getNodeName().equals("devDate")) {
				NodeList nodes3 = node2.getChildNodes();
				for (int j=0; j < nodes3.getLength(); j++) {
					Node node3 = nodes3.item(j);
					if (node3.getNodeName().equals("jps:position")) {
						NodeList nodes4 = node3.getChildNodes();
						for (int k=0; k < nodes4.getLength(); k++) {
							Node node4 = nodes4.item(k);
							if (node4.getNodeName().equals("jps:date8601")) {
								dateStr = node4.getTextContent();
							}
						}
					}
				}
			}
			else if (node2.getNodeName().equals("type")) {
				typeStr = node2.getTextContent();
			}
			else if (node2.getNodeName().equals("name")) {
				nameStr = node2.getTextContent();
			}
		}

		//System.out.println(admCodeStr +","+ typeStr +","+ nameStr +","+ latStr +","+ lonStr +","+ dateStr);
		System.out.println("<wpt lat=\""+ latStr +"\" lon=\""+ lonStr +"\">");
		System.out.println(" <time>"+ dateStr +"T00:57:59Z</time>");
		System.out.println(" <name><![CDATA["+ nameStr +" : "+ typeStr +"]]></name>");
		System.out.println("</wpt>");

	}

	/** ノードの種類を示します */
	public String getTypeMes(Node node) {
		String s = null;
		switch (node.getNodeType()) {
			case Node.ATTRIBUTE_NODE:              s = "Attr";
			case Node.CDATA_SECTION_NODE:          s = "CDATASection";
			case Node.COMMENT_NODE:                s = "Comment";
			case Node.DOCUMENT_FRAGMENT_NODE:      s = "DocumentFragment";
			case Node.DOCUMENT_NODE:               s = "Document";
			case Node.DOCUMENT_TYPE_NODE:          s = "DocumentType";
			case Node.ELEMENT_NODE:                s = "Element";
			case Node.ENTITY_NODE:                 s = "Entity";
			case Node.ENTITY_REFERENCE_NODE:       s = "EntityReference";
			case Node.NOTATION_NODE:               s = "Notation";
			case Node.PROCESSING_INSTRUCTION_NODE: s = "ProcessingInstruction";
			case Node.TEXT_NODE:                   s = "Text";
		}
		return s;
	}


	/** メイン */
	public static void main(String[] argv)
	{
		AllShow t = new AllShow();
		t.runner();
	}
}