/******************************************************************************
*                           ӥեޥåȥС                           
*        (ȥӥեޥåȤ̤ΣӥեޥåȤѴġ)        
* ---------------------------------------------------------------------------- 
*                    Copyright (C)2003ǯ ݽ(ʣգǭ)                    
* ---------------------------------------------------------------------------- 
*                                                                              
*  ܥץϥե꡼եȥǤʤϡFree Software Foundation  
*  ɽGNU ̸ͭѵΡ֥С󣲡װϤʹߤγƥС  
*  椫餤줫򤷡ΥС˽äܥץ  
*  ۤޤѹ뤳ȤǤޤ                                      
*                                                                              
*  ܥץͭѤȤϻפޤۤˤäƤϡԾڤŪŬ  
*  ˤĤƤΰۤݾڤޤơʤݾڤԤʤޤ󡣾ܺ٤ˤĤƤ  
*  GNU ̸ͭѵɤߤ                                    
*                                                                              
*  ʤϡܥץȰGNU ̸ͭѵμ̤äƤ    
*  ϤǤǤʤϡFree Software Foundation, Inc., 675 Mass Ave,   
*  Cambridge, MA 02139, USA ؼ񤤤Ƥ                           
*                                                                              
******************************************************************************/
#undef	DOS16
#undef	DOS32
#define	LINUX

#include	<stdio.h>
#ifndef	LINUX
#include	<conio.h>
#endif
#include	<string.h>

/* 顼ٹ𥳡 */
#define		ERR_CMPSW	( -1 )
#define		ERR_STYPE	( -2 )
#define		ERR_SWITCH	( -3 )
#define		ERR_NOSRC	( -4 )
#define		ERR_SRCTMPERR	( -5 )
#define		ERR_OPENSRC	( -6 )
#define		ERR_OPENDEST	( -7 )

#define		CAU_STYPE	( -1 )
#define		CAU_ADRLEN	( -2 )
#define		CAU_NOERR	0
#ifndef	LINUX
#define		CAU_ESC		255

/* ¾ */
#define		ESC	0x1b
#endif
#if defined( DOS16 )
const char	bitid[] = "16bit";
#endif
#if defined( DOS32 )
const char	bitid[] = "32bit";
#endif
#if defined( LINUX )
const char	bitid[] = "linux";
#endif

const char	dateid[] = __DATE__;
const char	vers[] = "version 1.00";

FILE	*in, *out;		/* ϡϥեݥ */
char	format;			/* Ѵեޥå */
char	inputcom;		/* ϥե */
char	complement;		/*  */
int	inrecsts, outrecsts;	/* 쥳ɥơ S0-S9 */
char	headstr[80];		/* إå */
char	infname[128];		/* ϥե̾(ޥɥ饤) */
char	outfname[128];		/* ϥե̾(ޥɥ饤) */
int	sameflg;		/* ϥեȽϥե뤬Ʊ̾ */

/**
*	ХȤΣʸͤˤ
*	 in:	Ѵʸ(Х)
*	out:	Ѵ줿(unsigned char)
*/
unsigned char	axtod( char *buf )
{
	char	i, tmp;
	unsigned char	ret;

	tmp = *( buf + 0 );
	if(( tmp >= '0' ) && ( tmp <='9' )){		/* ̥ХѴ */
		i = tmp - '0';
	}
	else if(( tmp >= 'A' ) && ( tmp <='F' )){
		i = ( tmp - 'A' ) + 10;
	}
	else{
		i = 0;
	}
	ret = i << 4;
	tmp = *( buf + 1 );
	if(( tmp >= '0' ) && ( tmp <='9' )){		/* ̥ХѴ */
		i = tmp - '0';
	}
	else if(( tmp >= 'A' ) && ( tmp <='F' )){
		i = ( tmp - 'A' ) + 10;
	}
	else{
		i = 0;
	}
	ret |= i;

	return	ret;
}


/**
*	ʸͤˤ
*	 in:	Ѵʸ(ǡϣʸޤ,NULLʸޤǤ뤳)
*	out:	Ѵ줿(unsigned long)
*/
unsigned long	axtol( char *buf )
{
	unsigned long	ret;
	int	i, j;
	char	tmp;

	if( strlen( buf ) > (size_t)8 ){		/* ʸĹ */
		return	0;
	}
	ret = 0;
	for( i = 0; *( buf + i ) != '\0'; i++ ){
		ret <<= 4;
		tmp = *( buf + i );
		if(( tmp >= '0' ) && ( tmp <='9' )){	/* ХʬѴ */
			j = tmp - '0';
		}
		else if(( tmp >= 'A' ) && ( tmp <='F' )){
			j = ( tmp - 'A' ) + 10;
		}
		else{
			j = 0;
		}
		ret |= j;
	}

	return	ret;
}


/**
*	إɽ
*	 in:	ʤ
*	out:	ʤ
*/
void	disphelp( void )
{
	printf( "\n   ====== motorola S-record CONVerter(%s-version)  %s ======\n", bitid, vers );
	printf( "         UPDATED %s  Copyright (c)Junichi Tomaru 2003-2004\n\n", dateid );
	printf( "  USAGE: SCONV [FORMAT(S1,S2,S3) [SWITCH(-C1,-C2)] INPUTFILE [OUTPUTFILE]]\n" );
	printf( "----------------------------------------------------------------------------\n" );
	printf( " PARAMETERS:\n" );
	printf( "        FORMAT: OUTPUT FORMAT TYPE\n" );
	printf( "                 S1: S1 and S9 Record Format(16bit-Address)\n" );
	printf( "                 S2: S2 and S8 Record Format(24bit-Address)\n" );
	printf( "                 S3: S3 and S7 Record Format(32bit-Address)\n" );
	printf( "        SWITCH: OPTION SWITCH\n" );
	printf( "                 -C1: One's Complement  -C2: Two's Complement\n" );
	printf( "     INPUTFILE: SOURCE FILE NAME\n" );
	printf( "    OUTPUTFILE: DESTINATION FILE NAME\n" );
	printf( "\n" );
	printf( "                   HOMEPAGE: http://sconv.sourceforge.jp/\n" );
	printf( "----------------------------------------------------------------------------\n" );
	printf( "                  SCONV comes with ABSOLUTELY NO WARRANTY\n" );
	printf( " This is free software, and you are welcome to redistribute it under certain\n" );
	printf( " conditions, See the GNU General Public License for details.\n" );
}


/**
*	Ѵɥ쥹Ѵ襢ɥ쥹Ĺ뤫Ĵ٤
*	 in:	srcaddr:Ѵɥ쥹
*		type:Ѵ쥳ɥ
*	out:	:ɥ쥹ϰ⡡ʳ:ϰϳä쥳ɥ
*/
char	checkaddrrange( long srcaddr, char type )
{
	char	ret;

	ret = 0;
	if(( type == 1 ) || ( type == 9 )){	/* S1,S9(0000-FFFF) */
		if( srcaddr > 0xffff ){
			ret = type;
		}
	}
	else if(( type == 2 ) || ( type == 8 )){/* S2,S8(000000-FFFFFF) */
		if( srcaddr > 0xffffff ){
			ret = type;
		}
	}
	else if(( type == 3 ) || ( type == 7 )){/* S3,S7(00000000-FFFFFFFF) */
		if( srcaddr > 0xffffffff ){
			ret = type;
		}
	}

	return	ret;
}


/**
*	إåȴФ
*	 in:	ӣ쥳ɤäХåեƬݥ
*	out:	ʤ
*/
void	getheadstr( char *buffer )
{
	char	len, i, j, buf[4], *p, c;

	buf[0] = *( buffer + 2 );		/* ѴХȥȤ */
	buf[1] = *( buffer + 3 );
	buf[2] = '\0';
	len = axtod( buf ) - 3;			/* åܥɥ쥹Х */
	if( len > 79 ){				/* ͣأʸ */
		len = 79;
	}
	p = buffer + 8;				/* ǡƬ */
	for( i = j = 0; i < len; i++ ){		/* ʥڥ -> ʸɤ */
		buf[0] = *p;
		p++;
		buf[1] = *p;
		p++;
		buf[2] = '\0';
		c = axtod( buf );
		if(( c >= 0x20 ) && ( c <= 0x7e )){/* Ѹ⡼ɤǤɽǤʸΤ */
			headstr[j] = c;
			j++;
		}
	}
	headstr[j] = '\0';
}


/**
*	쥳ɥԡ(å׻ʤƽϤΤ)
*	 in:	쥳ɤäХåեƬݥ
*	out:	ʤ
*/
void	recordcopy( char *str )
{
	char	len, buf[4], i, *p;
	unsigned char	sum;

	buf[0] = *( str + 2 );			/* ѴХȥȤ */
	buf[1] = *( str + 3 );
	buf[2] = '\0';
	len = axtod( buf );
	p = str + 2;				/* ХȥȰ */
	fputc( *( str + 0 ), out );		/*  */
	fputc( *( str + 1 ), out );
	sum = 0;
	for( i = 0; i < len; i++ ){		/* ǡ˥ԡʤû */
		buf[0] = *p;
		fputc( *p, out );
		p++;
		buf[1] = *p;
		fputc( *p, out );
		p++;
		buf[2] = '\0';
		sum += axtod( buf );
	}
	sum = ~sum;				/* ȿž() */
	if( complement == 2 ){			/* ˤ */
		sum++;
	}
	fprintf( out, "%02X\n", sum );		/*  */
}


/**
*	ʬѴ롼
*	 in:Ѵӥ쥳(ʬ)
*	out:ơ(顼ʤ)
*/
int	lineconvert( char *buffer )
{
	int	i, j;
	char	buf[16], *p;
	unsigned char	c;
	int	type;				/* Ѵӥ */
	int	srcadrlen, destadrlen;		/* ɥ쥹Ĺ */
	long	srcaddr;			/* ѴΥɥ쥹 */
	char	*srcpnt;			/* ѴǡΥݥ */
	char	fmt;				/* ѴΥ쥳ɼ */
	unsigned char	oinsum;			/* Ѵå */
	unsigned char	srclen, destlen;	/* Хȥ */
	unsigned char	datalen;		/* ǡʬĹ */
	unsigned char	insum;			/* ϥեå */
	unsigned char	sum;			/* å */

	p = buffer;
	while( *p == ' ' ){
		p++;
	}
	if( *p != 'S' ){			/* ӥեޥåȤǤϤʤ */
		return	CAU_NOERR;
	}
	type = *( p + 1 ) - 0x30;		/* Ѵӥ */
	switch( type ){				/* Ѵɥ쥹Ĺ */
		case 1:	/*  */
		case 9:	srcadrlen = 4;	/* S1,S9  Хȥɥ쥹(ʸʬ) */
			break;
		case 2:	/*  */
		case 8:	srcadrlen = 6;	/* S2,S8  Хȥɥ쥹(ʸʬ) */
			break;
		case 3:	/*  */
		case 7:	srcadrlen = 8;	/* S3,S7  Хȥɥ쥹(ʸʬ) */
			break;
		case 0:	getheadstr( p );	/* إåƲ */
		case 5:	recordcopy( p );	/* ʤΤǤΤޤޥԡ */
			break;
		default:	return CAU_STYPE;
	}
	inrecsts |= ( 1 << type );		/* ¦쥳ɥ׳Ф */
	if(( type == 0 ) || ( type == 5 )){
		outrecsts |= ( 1 << type );	/* ¦쥳ɥפˤФ */
		return	CAU_NOERR;
	}
	buf[0] = *( p + 2 );			/* ѴХȥȤ */
	buf[1] = *( p + 3 );
	buf[2] = '\0';
	srclen = axtod( buf );
	c = ( srclen * 2 ) + 2;			/* Ѵå */
	buf[0] = *( p + c );			/* Ѵå */
	buf[1] = *( p + c + 1 );
	buf[2] = '\0';
	oinsum = axtod( buf );
	datalen = srclen - ( srcadrlen / 2 ) - 1;/* ǡĹ */
	for( i = 0; i < srcadrlen; ){		/* Ѵɥ쥹 */
		buf[i] = *( p + 4 + i );
		i++;
		buf[i] = *( p + 4 + i );
		i++;
	}
	buf[i] = '\0';
	srcaddr = axtol( buf );
	srcpnt = p + 4 + srcadrlen;		/* ǡƬ */
	fmt = format;
	if( fmt == 1 ){				/* Ѵեޥå */
		destadrlen = 4;
		if(( type >= 7 ) && ( type <= 9 )){/* ӣӣѴƱɥ쥹Ĺ */
			fmt = 9;
		}
	}
	else if( fmt == 2 ){
		destadrlen = 6;
		if(( type >= 7 ) && ( type <= 9 )){/* ӣӣѴƱɥ쥹Ĺ */
			fmt = 8;
		}
	}
	else if( fmt == 3 ){
		destadrlen = 8;
		if(( type >= 7 ) && ( type <= 9 )){/* ӣӣѴƱɥ쥹Ĺ */
			fmt = 7;
		}
	}
	if( checkaddrrange( srcaddr, fmt ) != 0 ){/* ѴǤ륢ɥ쥹ϰϤ */
		return CAU_ADRLEN;
	}
	outrecsts |= ( 1 << fmt );		/* ¦쥳ɥ׳Ф */
	destlen = ( destadrlen / 2 ) + datalen + 1;	/* ǼʸĹ */
	fprintf( out, "S%d%02X%0*lX", fmt, destlen, destadrlen, srcaddr );	/* ӡࡤʸĹ,ɥ쥹 */
	insum = srclen;				/* ¦ */
	sum = destlen;				/* Ĺ򥵥 */
	c = ( unsigned char )(( srcaddr >> 24 ) & 0xff );	/* ɥ쥹û */
	c += ( unsigned char )(( srcaddr >> 16 ) & 0xff );
	c += ( unsigned char )(( srcaddr >> 8 ) & 0xff );
	c += ( unsigned char )( srcaddr & 0xff );
	insum += c;
	sum += c;
	for( j = 0; j < datalen; j++ ){	/* ǡ˥ԡʤû */
		buf[0] = *srcpnt;
		fputc( buf[0], out );
		srcpnt++;
		buf[1] = *srcpnt;
		fputc( buf[1], out );
		srcpnt++;
		buf[2] = '\0';
		c = axtod( buf );
		insum += c;
		sum += c;
	}
	sum = ~sum;				/* ȿž() */
	if( complement == 2 ){			/*  */
		sum++;
	}
	fprintf( out, "%02X\n", sum );		/*  */
	insum = ~insum;				/* ȿž() */
	if( oinsum == insum ){			/* ӤƤߤ */
		inputcom = 1;
	}
	else{
		insum++;
		if( oinsum == insum ){		/* ӤƤߤ */
			inputcom = 2;
		}
		else{
			inputcom = 0;		/* 㤦 */
		}
	}

	return	CAU_NOERR;
}


/**
*	åȽꡦ
*	 in:	ޥɥ饤󤫤Υץ(argv)
*	out:	-1: ꥨ顼
*		-2: ӥեޥåȻꥨ顼
*		-3: å顼
*		1,2,3Ѵեޥåȥ
*/
int	setswitch( char **point )
{
	int	ret;
	char	*p, p1, p2;

	complement = 1;				/* ǥեȤϣ */
	p1 = 2;					/* ϥե */
	p2 = 3;					/* ϥե */
	p = *( point + 1 );			/* argv[1] */
	if(( *p == 'S' ) || ( *p == 's' )){	/* ӥեޥåȻ꤫ */
		p++;
		if(( *p == '1' ) && ( *( p + 1 ) == '\0' )){		/* S1 */
			ret = 1;
		}
		else if(( *p == '2' ) && ( *( p + 1 ) == '\0' )){	/* S2 */
			ret = 2;
		}
		else if(( *p == '3' ) && ( *( p + 1 ) == '\0' )){	/* S3 */
			ret = 3;
		}
		else{
			return	ERR_STYPE;
		}
	}
	else{
		return	ERR_SWITCH;
	}
	p = *( point + 2 );			/* argv[2] */
	if( p == NULL ){
		return	ERR_NOSRC;		/* å̵äȹͤ */
	}
	if(( *p == '-' )){			/* å */
		p++;
		if(( *p == 'C' ) || ( *p == 'c' )){	/* ꥹå */
			p++;
			if(( *p == '1' ) && ( *( p + 1 ) == '\0' )){	/*  */
				complement = 1;
			}
			else if(( *p == '2' ) && ( *( p + 1 ) == '\0' )){/*  */
				complement = 2;
			}
			else{
				return	ERR_CMPSW;
			}
			p1++;
			p2++;
		}
		else{
			return	ERR_SWITCH;
		}
	}
	if( *( point + p1 ) != NULL ){
		strcpy( infname, *( point + p1 ));	/* ϥե */
	}
	if( *( point + p2 ) != NULL ){
		strcpy( outfname, *( point + p2 ));	/* ϥե */
	}

	return	ret;
}


/**
*	ӥ쥳ɥɽ
*	 in:	쥳ɾ
*	out:	ʤ
*/
void	disprecord( int sts )
{
	char	i;
	int	j;

	printf( " RECORD:" );
	for( i = 0, j = 1; i < 10; i++ ){
		if(( sts & j ) == j ){			/* ޤޤƤ쥳 */
			putchar( '0' + i );
		}
		else{
			putchar( '-' );			/* ¾ */
		}
		j = ( j << 1 );
	}
	printf( "\n" );
}


/**
*	ٹåɽ
*	 in:	err:顼
*		line:ȯֹ
*	out:	ʤ
*/
void	cautionmessage( int err, unsigned long line )
{
	switch( err ){
		case CAU_STYPE:	fprintf( stderr, "\nCAUTION:SOURCE RECORD TYPE NOT SUPPORT(LINE:%lu). STOP.\n", line );
				break;
		case CAU_ADRLEN:fprintf( stderr, "\nCAUTION:ADDRESS LENGTH RANGE OVER(LINE:%lu). STOP.\n", line );
				break;
		default:	fprintf( stderr, "\nCAUTION:OTHER ERROR(LINE:%lu). STOP.\n", line );
				break;
	}
}


/**
*	顼å
*	 in:	err:顼
*		str:ɲɽʸ
*	out:	ʤ
*/
void	errormessage( int err, char *str )
{
	switch( err ){
		case ERR_CMPSW:		fprintf( stderr, "ERROR:COMPLEMENT SWITCH ERROR.\n" );
					break;
		case ERR_STYPE:		fprintf( stderr, "ERROR:S FORMAT TYPE ERROR.\n" );
					break;
		case ERR_SWITCH:	fprintf( stderr, "ERROR:INVALID SWITCH.\n" );
					break;
		case ERR_NOSRC:		fprintf( stderr, "ERROR:NO INPUT FILE NAME.\n" );
					break;
		case ERR_SRCTMPERR:	fprintf( stderr, "ERROR:TEMPORARY FILE ERROR.(CANNOT OPEN).\n" );
					break;
		case ERR_OPENSRC:	fprintf( stderr, "ERROR:CANNOT OPEN SOURCE FILE(%s).\n", str );
					break;
		case ERR_OPENDEST:	fprintf( stderr, "ERROR:CANNOT OPEN DESTINATION FILE(%s).\n", str );
					break;
		default:		break;
	}
}


/**
*	λå
*	 in:	ʤ
*	out:	ʤ
*/
void	endmessage( void )
{
	fprintf( stderr, "\nFILE CONVERT COMPLETE.\n" );/* ｪλ */
	printf( "\n--- INPUT FILE REPORT ---\n" );
	if( headstr[0] != '\0' ){		/* ӣξ󤢤ä */
		printf( " HEADER:%s\n", headstr );
	}
	if( inrecsts != 0 ){			/* 쥳ɤεä */
		disprecord( inrecsts );
	}
	if( inputcom == 0 ){			/* ¦å */
		printf( " COMPLEMENT:NOT MATCH\n" );
	}
	else{
		printf( " COMPLEMENT:%d\n", inputcom );
	}
	printf( "\n--- OUTPUTUT FILE REPORT ---\n" );
	if( outrecsts != 0 ){			/* 쥳ɤεä */
		disprecord( outrecsts );
	}
	printf( " COMPLEMENT:%d\n", complement );/* ¦å */
}


/**
*	ᥤ
*	 in:	argc:ޥɥ饤󤫤ΰο(ץ̾ޤ)
*		argv:ޥɥ饤󤫤ΰ(ʸ)Υݥ
*	out:	顼
*/
int	main( int argc, char *argv[] )
{
	char	buf[128];			/* ʬХåե */
	unsigned long	line;			/* Ѵ줿饤 */
	int	b, err;

	sameflg = 0;
	infname[0] = outfname[0] = '\0';
	if( argc == 1 ){		/* ե롿å̵꤬Ȥ */
		b = 0;
	}
	else{
		b = setswitch( argv );		/* åĴ٤ */
	}
	if( b < 0 ){				/* å顼 */
		errormessage( b, NULL );
		return	b;
	}
	else if( b == 0 ){			/* SCONVΤȤϥإɽ */
		disphelp( );
	}
	else{
		format = (char)b;		/* եޥå */
		if( infname[0] == '\0' ){	/* ϥե̾ʤ */
			errormessage( ERR_NOSRC, NULL );
			return	( -4 );
		}
		if(( strcmp( infname, outfname ) == 0 ) || ( outfname[0] == '\0' )){
					/* Ʊե̾ϥե̾ʤ */
			sameflg = 1;
		}
		in = fopen( infname, "rt" );	/* Ѵե륪ץ */
		if( in == NULL ){
			errormessage( ERR_OPENSRC, infname );
			return	( -5 );
		}
		if( sameflg == 1 ){
			out = fopen( "sconv.tmp", "wt" );/* ե륪ץ */
		}
		else{
			out = fopen( outfname, "wt" );	/* Ѵե륪ץ */
		}
		if( out == NULL ){
			fclose( in );
			if( sameflg == 1 ){
				errormessage( ERR_SRCTMPERR, NULL );
				return	( -6 );
			}
			else{
				errormessage( ERR_OPENDEST, outfname );
				return	( -7 );
			}
		}
		inrecsts = outrecsts = 0;	/* ơꥢ */
		headstr[0] = '\0';
		for( line = 1; !feof( in ); ){	/* եޥåѴ */
#ifndef	LINUX
			if( kbhit( ) != 0 ){	/* Ϥ */
				if( getch( ) == ESC ){	/* ţӣää */
					err = CAU_ESC;
					break;
				}
			}
#endif
			if( fgets( buf, 127, in ) != NULL ){	/* ɤ߽Ф */
				err = lineconvert( buf );
				if( err != 0 ){	/* 顼ȯȴ */
					break;
				}
			}
			fprintf( stderr, "\rConverted Lines %lu", line );
			line++;
		}
		fclose( in );			/* λΤᡢĤ */
		fclose( out );
		if( err == CAU_NOERR ){		/* ｪλ */
			endmessage( );
			if( sameflg == 1 ){
				remove( infname );
				rename( "sconv.tmp", infname );
			}
		}
		else{
			if( sameflg == 1 ){
				remove( "sconv.tmp" );
			}
			else{
				remove( outfname );
			}
			if( err < 0 ){
				cautionmessage( err, line );	/* 顼ɽ */
			}
		}
	}
	return	0;
}

/* end of sconv.c */
