// 
// Buffer.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _Buffer_INCLUDED_
#define _Buffer_INCLUDED_
#include "utility.h"
#include "Exceptions.h"
#include <malloc.h>

namespace scpl{

	/*
		̃NX̓ev[gŎw肵TCY
		PʂƂĊmہAJs܂B

		mہAJɂmallocn֐gp܂B

		T    - 擾AݒȂǂɗp^B
		Size - T̃TCYBȗsizeofgpB
		       T\̂NX̏ꍇAsizeofŐmȃTCY
			   擾邱ƂłȂ߁iDebugjÂƂ
			   mȃTCYɎw肷B́At@CȂǂ
			   oۂɃS~oȂ悤ɂ邽߂łA
			   ȊO̎gpł͎gpȂĂȂB

	*/

	template<class T,ulong Size=sizeof(T)>
	class Buffer{
		friend class AString;
		friend class WString;

		typedef Buffer<T,Size> self;

	public:

		/*
			̈mۂ܂B
			size      - mۂ鐔B 0 ̏ꍇ͊mۂȂB
			zeroClear - mۂf[^[NA邩ǂ
		*/
		Buffer(ulong count=0,bool zeroClear=false)throw(OutOfMemExc):_Buffer(NULL),_Count(count){
			if(count){
				_Buffer = checkNull(static_cast<T*>(malloc(Size*count)),count);
				if(zeroClear) memset(_Buffer,0,Size*count);
			}
		}
		/* w肵f[^̕܂B */
		Buffer(T* p,ulong count)throw(OutOfMemExc):_Buffer(NULL),_Count(NULL){copy(p,count);}
		template<ulong count>
		Buffer(T(&p)[count])throw(OutOfMemExc):_Buffer(NULL),_Count(NULL){copy(p,count);}

		/* f[^𕡐܂B */
		explicit Buffer(const self& s)throw(OutOfMemExc):_Buffer(NULL),_Count(0){
			if(s){
				_Buffer = checkNull(static_cast<T*>(malloc(Size*s._Count)),s._Count);
				memcpy(_Buffer,s._Buffer,s._Count*Size);
				_Count = s._Count;
			}
		}

		/* Rs[RXgN^Bnꂽf[^܂BiJj */
		explicit Buffer(self* s)throw(OutOfMemExc):_Buffer(s->_Buffer),_Count(s->_Count){}

		virtual ~Buffer(){
			if(_Buffer) free(_Buffer);
		}

		/* f[^Ԃ܂B */
		operator const T*()const{return _Buffer;}
		/* f[^݂ȂԂ܂B */
		bool operator!()const{return _Count==0;}

		/* f[^v邩ǂԂ܂B */
		bool operator==(const self& s)const{return equals(s);}
		/* f[^svǂԂ܂B */
		bool operator!=(const self& s)const{return !equals(s);}

		/* f[^Rs[܂B */
		self& operator=(const self& t)throw(OutOfMemExc){
			copy(t);
			return *this;
		}

		/*
			f[^𑊑ΐŃTCY܂B
			size - TCY鑊ΐB
			zeroClear - mۂf[^[NA邩ǂB
		*/
		void rResize(long count,bool zeroClear=false)throw(InvalidParamExc,OutOfMemExc){
			if(count != 0){
				count += _Count;
				if(0 <= count) return aResize(count,zeroClear);
				throw InvalidParamExc(1);
			}
		}
		/*
			f[^ΐŃTCY܂B
			size - TCYΐB
			zeroClear - mۂf[^[NA邩ǂB
		*/
		void aResize(ulong count,bool zeroClear=false)throw(OutOfMemExc){
			if(count == _Count) return;
			if(_Buffer){
				if(count!=0){
					T* t = checkNull(static_cast<T*>(realloc(_Buffer,Size*count)),count);
					_Buffer = t;
					if(zeroClear&&(count>_Count)) memset(t+_Count,0,Size*(count-_Count));
					_Count = count;
				}
				else{
					free(_Buffer);
					_Buffer = NULL;
					_Count = 0;
				}
			}
			else{
				_Buffer = checkNull(static_cast<T*>(malloc(Size*count)),count);
				_Count = count;
				if(zeroClear) memset(_Buffer,0,Size*count);
			}
		}
		/* f[^J܂B */
		void clear(){
			if(_Buffer){
				free(_Buffer);
				_Buffer = NULL;
				_Count = 0;
			}
		}

		/*
			w肵f[^畡܂Bnꍇ̓NA܂B
			data  - zB
			count - z
		*/
		void copy(T* data,ulong count)throw(OutOfMemExc){
			if(!data||!count){
				clear();
				return;
			}
			aResize(count);
			memcpy(_Buffer,data,Size*count);
			_Count = count;
		}

		/* w肵f[^畡܂Bnꍇ̓NA܂B */
		void copy(const self& s)throw(OutOfMemExc){
			if(s){
				aResize(s._Count);
				memcpy(_Buffer,s._Buffer,Size*_Count);
			}
			else clear();
		}

		/* f[^|C^Ԃ܂B */
		T* get()const{return _Buffer;}

		/* f[^Ԃ܂B */
		ulong count()const{return _Count;}

		/* f[^TCYԂ܂B */
		ulong size()const{return Size*_Count;}

		/*
			p̍ŏ̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		T* begin()const{return _Buffer;}
		/*
			p̍Ō̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		T* end()const{return _Buffer?(_Buffer+_Count):NULL;}
		/*
			tp̍ŏ̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		T* rbegin()const{return _Buffer?(_Buffer+_Count-1):NULL;}
		/*
			tp̍Ō̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		T* rend()const{return _Buffer?(_Buffer-1):NULL;}

		/* f[^(NULL)Ԃ܂B */
		bool empty()const{return !_Buffer;}

		/* f[^ւ܂B */
		void swap(self& s){
			scpl::swap(_Buffer,s._Buffer);
			scpl::swap(_Count,s._Count);
		}

		/* f[^v邩ǂԂ܂B */
		bool equals(const self& s)const{
			if(_Count!=s._Count) return false;
			if((this == &s)||(_Count==0)) return true;
			const T *a = _Buffer,*b = s._Buffer,*n = _Buffer+_Count;
			for(;a<n;++a,++b){
				if(*a != *b) return false;
			}
			return true;
		}

		/* obt@̃|C^CfbNXlԂ܂B */
		ulong toPos(const T* ptr)const throw(InvalidParamExc){
			if((_Buffer > ptr)||(_Buffer+_Count <= ptr)){
				throw InvalidParamExc(1);
			}
			return static_cast<ulong>(ptr - _Buffer);
		}

	private:
		T* _Buffer;
		ulong _Count;

	};

} // namespace scpl
#endif