// 
// File.h
// 
// Copyright(C) 2007 Ó
#ifndef _File_INCLUDED_
#define _File_INCLUDED_
#include <share.h>
#include "Exceptions.h"

namespace scpl{

	/*
		stdio.hFILẼJvZNXłB
		ꂼ̗prɉāA
		FileReader,FileWriter,FileBothNXpӂ܂B
	*/

	/*
		t@C̊NXłB
		̃NX̃CX^X͐ł܂B
	*/
	class File{
		friend class FileBoth;
	public:
		/* seek֐ŎgpV[NtOłB */
		enum FILESEEK{
			FS_SET = SEEK_SET,
			FS_CUR = SEEK_CUR,
			FS_END = SEEK_END,
		};
		/* LŃI[vƂɎgptOłB */
		enum SHAREFRAG{
#ifdef __BORLANDC__
			SF_B = SH_DENYNO, // ǂݏ\
			SF_R = SH_DENYRD, // ǂݍ݉\Aݕs
			SF_W = SH_DENYWR, // ݉\Aǂݍݕs
			SF_N = SH_DENYRW, // ǂݏs
#else
			SF_B = _SH_DENYNO,
			SF_R = _SH_DENYRD,
			SF_W = _SH_DENYWR,
			SF_N = _SH_DENYRW,
#endif
		};

	protected:
		File():_Fp(NULL),_Share(SF_N){}

		void gen_fmode(ulong mode,char(&rmode)[4]);
		void gen_fmode(ulong mode,wchar_t(&rmode)[4]);

	public:
		virtual ~File(){if(_Fp) fclose(_Fp);}

		/* t@CJĂ邩ǂԂ܂B */
		operator bool()const{return _Fp!=NULL;}

		/* t@C܂B */
		void close(){if(_Fp){fclose(_Fp);_Fp = NULL;}}

		/* t@C̋L[hԂ܂B */
		SHAREFRAG getShare()const{return _Share;}

		/* ݂̃t@C|C^Ԃ܂B */
		fpos_t getpos()throw(IOExc){
			fpos_t pos;
			if(fgetpos(_Fp,&pos)) throw IOExc(IOExc::NOT_OPEN);
			return pos;
		}
		/* ݂̃t@C|C^w肵܂B */
		void setpos(fpos_t pos)throw(IOExc){
			if(fsetpos(_Fp,&pos)) throw IOExc(IOExc::NOT_OPEN);
		}

		/*
			t@C|C^̈ʒuړ܂B
			offset - ړ
			origin - ړ̊_
		*/
		void seek(long offset,FILESEEK origin)throw(IOExc){
			if(fseek(_Fp,offset,origin)){
				throw IOExc(_Fp? IOExc::SEEK : IOExc::NOT_OPEN);
			}
		}
		//! BCCł64BitV[N͂łȂ !//
#ifndef __BORLANDC__
		void seek64(__int64 offset,FILESEEK origin)throw(IOExc){
			if(_fseeki64(_Fp,offset,origin)){
				throw IOExc(_Fp? IOExc::SEEK : IOExc::NOT_OPEN);
			}
		}
#endif

		/* tbV܂B */
		void flush()throw(IOExc);

		/* JĂ邩ǂԂ܂B */
		bool opened()const{return _Fp!=NULL;}
		/* G[Ă邩ǂԂ܂B */
		bool error()const{return (_Fp!=NULL)?(ferror(_Fp)!=0):false;}
		/* t@C̏I[ǂԂ܂B */
		bool eof()const{return (_Fp!=NULL)?(feof(_Fp)!=0):false;}

		/* {̂Ԃ܂B */
		FILE* getStream()const{return _Fp;}
		/* {̂̃t@CLqqԂ܂B */
		int getHandle()const{return _fileno(_Fp);}

	protected:
		FILE* _Fp;
		SHAREFRAG _Share;

	};

	/* ۃNXB */
	class AFileReader:virtual public File{
	protected:
		AFileReader():_IsBinary(false){}

	public:
		/*
			t@Cf[^ǂݍ݂܂B
			buf   - ǂݍݐ̃obt@
			size  - ǂݍރubNTCY
			count - ǂݍރubNBsize*countǂݍ܂TCYƂȂB
			߂l - ǂݍ񂾃ubN
		*/
		size_t read(void* buf,size_t size,size_t count=1)throw(InvalidParamExc,IOExc);
		template<class T,ulong Size,size_t count>
		size_t read(T* data)throw(InvalidParamExc,IOExc){return read(data,Size,count);}

		/* ꕶǂݎ܂BEOFoꍇ͗O𔭐܂B */
		char getChar()throw(IOExc);
		wchar_t getWChar()throw(IOExc);

		/*
			ǂݎ܂BEOFoꍇ͗O𔭐܂B
			buf  - ǂݍݐ̃obt@
			size - ǂݍލő啶
		*/
		void getStr(str buf,size_t size)throw(IOExc);
		void getWStr(wstr buf,size_t size)throw(IOExc);
		template<size_t size>
		void getStr(str buf)throw(IOExc){getStr(buf,size);}
		template<size_t size>
		void getWStr(wstr buf)throw(IOExc){getWStr(buf,size);}

		/*
			ǂݎ܂B
			buf  - ǂݍݐ̃obt@
			size - ǂݍލő啶
		*/
		void getnStr(str buf,size_t size)throw(IOExc);
		void getnWStr(wstr buf,size_t size)throw(IOExc);
		template<size_t size>
		void getnStr(str buf)throw(IOExc){getnStr(buf,size);}
		template<size_t size>
		void getnWStr(wstr buf)throw(IOExc){getnWStr(buf,size);}

		/* oCi[hǂԂ܂B */
		bool isBinary()const{return _IsBinary;}

	protected:
		bool _IsBinary;

	};

	/* ۃNXB */
	class AFileWriter:virtual public File{
	protected:
		AFileWriter():_IsBinary(false),_IsAdd(false){}

	public:
		/*
			f[^݂܂B
			buf   - ރobt@
			size  - ރubNTCY
			count - ރubNsize*count܂TCYƂȂB
			߂l - 񂾃ubN
		*/
		size_t write(const void* buf,size_t size,size_t count=1)throw(InvalidParamExc,IOExc);
		template<class T,ulong Size,size_t count>
		size_t write(const T* data)throw(InvalidParamExc,IOExc){return write(write,Size,count);}

		/* ꕶ݂܂B */
		void putChar(char c)throw(IOExc);
		void putWChar(wchar_t c)throw(IOExc);

		/* ݂܂B */
		void putStr(cstr buf)throw(IOExc);
		void putWStr(cwstr buf)throw(IOExc);
		template<size_t size>
		void putStr(str buf)throw(IOExc){putStr(buf,size);}
		template<size_t size>
		void putWStr(wstr buf)throw(IOExc){putWStr(buf,size);}

		/* oCi[hǂԂ܂B */
		bool isBinary()const{return _IsBinary;}
		/* ǉ[hǂԂ܂B */
		bool isAdd()const{return _IsBinary;}

	protected:
		bool _IsBinary;
		bool _IsAdd;

	};

	/* t@Cǂݍ݃NX */
	class FileReader:public AFileReader{
	public:
		/* t@CJĂȂԂ̃CX^X쐬܂B */
		FileReader(){}
		/*
			t@Cw肵IvVŃI[v܂B
			ڍׂopen֐QƂĂB
		*/
		FileReader(cstr fname,bool binary = false,SHAREFRAG shfrag = SF_N)throw(InvalidParamExc,IOExc){open(fname,binary,shfrag);}
		FileReader(cwstr fname,bool binary = false,SHAREFRAG shfrag = SF_N)throw(InvalidParamExc,IOExc){open(fname,binary,shfrag);}

		/*
			t@Cw肵IvVŃI[v܂B
			fname     - I[vt@CB
			binary    - oCi[hŊJǂBȗfalseB
			shfrag    - L[hBȗ͋LȂ(SF_N)B
		*/
		void open(cstr fname,bool binary = false,SHAREFRAG shfrag = SF_N)throw(InvalidParamExc,IOExc);
		void open(cwstr fname,bool binary = false,SHAREFRAG shfrag = SF_N)throw(InvalidParamExc,IOExc);

	};

	/* t@C݃NX */
	class FileWriter:public AFileWriter{
	public:
		/* t@CJĂȂԂ̃CX^X쐬܂B */
		FileWriter(){}
		/*
			t@Cw肵IvVŃI[v܂B
			ڍׂopen֐QƂĂB
		*/
		FileWriter(cstr fname,bool binary = false,bool add = false,SHAREFRAG shfrag = SF_N)throw(InvalidParamExc,IOExc){open(fname,binary,add,shfrag);}
		FileWriter(cwstr fname,bool binary = false,bool add = false,SHAREFRAG shfrag = SF_N)throw(InvalidParamExc,IOExc){open(fname,binary,add,shfrag);}

		/*
			t@Cw肵IvVŃI[v܂B
			fname     - I[vt@CB
			binary    - oCi[hŊJǂBȗfalseB
			add       - ǉ[hŊJǂBȗfalseB
			shfrag    - L[hBȗ͋LȂ(SF_N)B
		*/
		void open(cstr fname,bool binary = false,bool add = false,SHAREFRAG shfrag = SF_N)throw(InvalidParamExc,IOExc);
		void open(cwstr fname,bool binary = false,bool add = false,SHAREFRAG shfrag = SF_N)throw(InvalidParamExc,IOExc);

	};

	/*
		ǂݏ̃[hŃt@CI[vt@CNXłB
		ǂݏ֐̐ɂĂ͂ꂼAFileReader,AFileWriter
		QƂĂB
	*/
	class FileBoth:virtual public AFileReader,virtual public AFileWriter{
	public:
		/* t@CJĂȂԂ̃CX^X쐬܂B */
		FileBoth(){}
		/*
			t@Cw肵IvVŃI[v܂B
			ڍׂopen֐QƂĂB
		*/
		FileBoth(cstr fname,bool exist = false,bool binary = false,bool add = false,SHAREFRAG shfrag = SF_N)throw(InvalidParamExc,IOExc){open(fname,exist,binary,add,shfrag);}
		FileBoth(cwstr fname,bool exist = false,bool binary = false,bool add = false,SHAREFRAG shfrag = SF_N)throw(InvalidParamExc,IOExc){open(fname,exist,binary,add,shfrag);}

		/*
			t@Cw肵IvVŃI[v܂B
			fname  - I[vt@CB
			exist  - t@C݂ĂȂ΂ȂȂǂB
			         addtruȅꍇ́ÃtO͖܂B
			binary - oCi[hŊJǂBȗfalseB
			add    - ǉ[hŊJǂBȗfalseB
			shfrag - L[hBȗ͋LȂ(SF_N)B
		*/
		void open(cstr fname,bool exist = false,bool binary = false,bool add = false,SHAREFRAG shfrag = SF_N)throw(InvalidParamExc,IOExc);
		void open(cwstr fname,bool exist = false,bool binary = false,bool add = false,SHAREFRAG shfrag = SF_N)throw(InvalidParamExc,IOExc);

	};

} // namespace scpl
#endif
