// 
// auto_ptr.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _auto_ptr_INCLUDED_
#define _auto_ptr_INCLUDED_

namespace scpl{

	/*
		̃t@Cɂauto_ptrƁAauto_aryNX`Ă܂B

		̃NX́ARXgN^Ƀ|C^i[A
		fXgN^Ƀ|C^NXłB
		setDeletable֐gpăfXgN^
		Ȃ悤邱Ƃł܂B
		܂A邱ƂɂA|C^u邱Ƃł܂B
		̂Ƃ̒u|C^setDeletable֐Ŏw肵
		s܂BA|C^̉ɉe^邽߁A
		|C^NX̑͂ł܂B

		̃NXgpꍇAR[hƂ킩܂Af[^ɃANZX
		Zqgpꍇ̓`FbNs܂ixׁ̌̈jB
		`FbNĂقꍇ̓o֐gpĂB

		W̉łdeleteydelete[]g܂A
		L̃}N֐gp΁Ǎ^̉sƂł܂B
		zۗLAǗꍇauto_aryNXgpĂB
	*/

/*
	[U[`̉s}N֐(auto_ptrNX̂)B
	̊֐Ă΂Ƃ́A\ȂƂ݂̂Ȃ̂ŁA
	|C^̃`FbN͕svłB
	܂A|C^̕ϐ_PtrłB
*/
#define auto_delete(type) template<> void scpl::auto_ptr<type>::delptr()

	TMP class auto_ptr{
		void delptr(){delete _Ptr;}

	public:
		typedef T*          ptr;
		typedef T&          ind;
		typedef const T*    cptr;
		typedef const T&    cind;
		typedef auto_ptr<T> self;

		/* NULL܂B */
		auto_ptr():_Deletable(false),_Ptr(NULL){}
		/* |C^܂B */
		auto_ptr(ptr p):_Deletable(true),_Ptr(p){}
		/* Rs[܂BRs[ɉꍇ̂݉ړ܂B */
		auto_ptr(self& s):_Ptr(s._Ptr),_Deletable(s._Deletable){
			if(_Deletable) s._Deletable = false;
		}

		~auto_ptr(){if(_Deletable&&_Ptr) delptr();}

		/* |C^Ԃ܂B */
		operator ptr()const{return _Ptr;}
		/* |C^NULLԂ܂B */
		bool operator!()const{return _Ptr==NULL;}

		/* |C^̔r܂B */
		bool operator==(cptr p)const{return p == _Ptr;}
		bool operator!=(cptr p)const{return p != _Ptr;}

		/* w肵|C^܂B */
		self& operator=(ptr p){set(p);return *this;}
		void set(ptr p){
			if(_Deletable&&_Ptr) delptr();
			_Ptr = p;
			_Deletable = true;
		}

		/*
			w肵|C^NX܂B
			ɉꍇ̂݉ړ܂B
		*/
		self& operator=(self& s){set(s);return *this;}
		void set(self& s){
			if(_Deletable&&_Ptr) delptr();
			_Ptr = s._Ptr;
			_Deletable = s._Deletable;
			if(s._Deletable) s._Deletable = false;
		}

		/* ̂QƂ܂B */
		ind operator*()const{return *_Ptr;}
		/* oQƂ܂B */
		ptr operator->()const{return _Ptr;}

		/* ̂Ԃ܂B */
		ind getIndirect()const throw(InvalidCallExc){
			if(_Ptr) return *_Ptr;
			else throw InvalidCallExc();
		}
		/* |C^Ԃ܂B */
		ptr get()const throw(InvalidCallExc){
			if(_Ptr) return _Ptr;
			throw InvalidCallExc();
		}

		/* |C^NULLԂ܂B */
		bool empty()const{return !_Ptr;}

		/* |C^ւ܂B */
		void swap(self& p){scpl::swap(_Ptr,p._Ptr);}

		/* f[^NA܂BNULL ̂ƓłB */
		void clear(){if(_Deletable&&_Ptr) delptr();_Ptr = NULL;}

		/* ̃|C^邩ǂݒ肵܂B */
		void setDeletable(bool deletable){_Deletable = deletable;}

	protected:
		bool _Deletable;
		T* _Ptr;

	};

	template<class T,size_t Count> class auto_ary{
		void delptr(){delete[] _Ptr;}

	public:
		typedef T*                ptr;
		typedef T&                ind;
		typedef const T*          cptr;
		typedef const T&          cind;
		typedef auto_ary<T,Count> self;

		/* NULL܂B */
		auto_ary():_Deletable(false),_Ptr(NULL){}
		/* |C^܂B */
		auto_ary(T(&p)[Count]):_Deletable(true),_Ptr(p){}
		/* Rs[܂BRs[ɉꍇ̂݉ړ܂B */
		auto_ary(self& s):_Ptr(s._Ptr),_Deletable(s._Deletable){
			if(_Deletable) s._Deletable = false;
		}

		~auto_ary(){if(_Deletable&&_Ptr) delptr();}

		/* |C^݂邩Ԃ܂B */
		operator bool()const{return !_Ptr;}
		/* |C^NULLԂ܂B */
		bool operator!()const{return _Ptr==NULL;}

		/* |C^̔r܂B */
		bool operator==(cptr p)const{return p == _Ptr;}
		bool operator!=(cptr p)const{return p != _Ptr;}

		/* w肵|C^܂B */
		self& operator=(T(&p)[Count]){set(p);return *this;}
		void set(T(&p)[Count]){
			if(_Deletable&&_Ptr) delptr();
			_Ptr = p;
		}

		/*
			w肵|C^NX܂B
			ɉꍇ̂݉ړ܂B
		*/
		self& operator=(self& s){set(s);return *this;}
		void set(self& s){
			if(_Deletable&&_Ptr) delptr();
			_Ptr = s._Ptr;
			_Deletable = s._Deletable;
			if(s._Deletable) s._Deletable = false;
		}

		/* ̂QƂ܂B */
		ind operator*()const throw(InvalidCallExc){return getIndirect();}
		/* oQƂ܂B */
		ptr operator->()const{return _Ptr;}
		/* w肵ʒũf[^Ԃ܂B */
		ind operator[](ulong i)const{return _Ptr[i];}

		/* ̂Ԃ܂B */
		ind getIndirect()const throw(InvalidCallExc){
			if(_Ptr) return *_Ptr;
			throw InvalidCallExc();
		}
		/* |C^Ԃ܂B */
		ptr get()const{return _Ptr;}
		/* w肵ʒũf[^Ԃ܂B */
		ind at(ulong i)const throw(InvalidParamExc,InvalidCallExc){
			if(_pm){
				if(i < Count) return _Ptr[i];
				throw InvalidParamExc(1);
			}
			throw InvalidCallExc();
		}

		/* |C^NULLԂ܂B */
		bool empty()const{return !_Ptr;}

		/* |C^ւ܂B */
		void swap(self& p){scpl::swap(_Ptr,p._Ptr);}

		/* f[^NA܂BNULL ̂ƓłB */
		void clear(){if(_Deletable&&_Ptr) delptr();_Ptr = NULL;}

		/* ̃|C^邩ǂݒ肵܂B */
		void setDeletable(bool deletable){_Deletable = deletable;}

	protected:
		bool _Deletable;
		T* _Ptr;

	};

} // namespace scpl
#endif