// 
// Argument.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _Argument_INCLUDED_
#define _Argument_INCLUDED_
#include "String.h"
#include "List.h"

#pragma comment (lib,"shlwapi.lib")

namespace scpl{

/**
	ϊW[łB

	p[^ѕnƁA̕w肵
	pŕAzƂĐ܂B
	nꂽ̓Rs[̂ŁAnɑ΂ˑ֌W͎܂B

	[note]
	̃W[ WinAPI gpA "shlwapi.lib" N܂B
*/
	namespace argument{
		typedef CList<AString> ArgVA;
		typedef CList<WString> ArgVW;

		/**
			createArgumentFromCommandLine ֐ŎgA
			argv[0]Ɋi[镶ɂĎw肵܂B
		**/
		enum ARGTYPE{
			NONE	= 0, // spXꂸAl߂
			CONSOLE	= 1, // R\[ƓAspX
			EXENAME	= 2, // EChEƓAst@C
			EXEPATH	= 3, // spXtpXœ
			DIR		= 4, // sJgfBNg
			EXEDIR	= 5, // st@C̃fBNg
		};

		/**[hybrid:createArgument]
			𕪊Azɕϊ܂B
			؂镶w肷邱Ƃł܂B
			[arg]
			in		: ꂽz󂯎ϐւ̃|C^B
			arg		: ̕B
			divide	: ؂蕶Bȗ͋󔒕(p󔒁E^uEs)B
			isQuote	:  '  " ݂̈͂؂Ƃ邩ǂB
			[return]
			ꍇ true ԂA in Ƀf[^n܂B
			łȂꍇ false ԂA in ͕ύX܂B
			[exc]
			std::bad_alloc			: ϊɕKvȃmۂłȂ
			std::invalid_argument	: in  NULL A邢 divide  '  " ӂ܂Ă
			[note]
			 in ɕԂ f[^͎gpA delete gpĉĂB
		**/
		bool createArgumentA(ArgVA** in,cstr txt,cstr divide = NULL,bool isQuote = true);
		bool createArgumentW(ArgVW** in,cwstr txt,cwstr divide = NULL,bool isQuote = true);

		/**[hybrid:createArgumentFromCommandLine]
			Nɓnꂽzɕϊ܂B
			[arg]
			in		: ꂽz󂯎ϐւ̃|C^B
			type	: z̐擪̏@B
			[return]
			ꍇ true ԂA in Ƀf[^n܂B
			łȂꍇ false ԂA in ͕ύX܂B
			[exc]
			std::bad_alloc			: ϊɕKvȃmۂłȂ
			std::invalid_argument	: in  NULL A邢 divide  '  " ӂ܂Ă
			[note]
			 in ɕԂ f[^͎gpA delete gpĉĂB
		**/
		bool createArgumentFromCommandLineA(ArgVA** in,ARGTYPE type = CONSOLE);
		bool createArgumentFromCommandLineW(ArgVW** in,ARGTYPE type = CONSOLE);

		/**[hybrid:commandLineToArgv]
			NɓnꂽR\[^zɕϊ܂B
			argc	: z̐擾ϐւ̃|C^B
			argv	: z擾ϐւ̃|C^B
            type	: z̐擪̏@B
			[return]
			ꍇ SRS_OK Ԃ܂B
			sꍇ͈ȉ̒l̂ꂩԂ܂B
			[return]
			ꍇ true ԂA
			argc ɔz񐔁A argv ɕ̔zf[^n܂B
			łȂꍇ false ԂA argc  argv ͕ύX܂B
			[exc]
			std::bad_alloc			: ϊɕKvȃmۂłȂ
			std::invalid_argument	: in  NULL A邢 divide  '  " ӂ܂Ă
			[note]
			 argv ɕԂ f[^͎gpA
			releaseArgv ֐gpĉĂB
		**/
		bool commandLineToArgvA(int* argc,str** argv,ARGTYPE type = CONSOLE);
		bool commandLineToArgvW(int* argc,wstr** argv,ARGTYPE type = CONSOLE);

		/**[hybrid:releaseArgv]
			commandLineToArgv ֐ŕԂ argv ܂B
			[arg]
			argc	: commandLineToArgv ֐ŕԂꂽ argc ̒lB
			argv	: commandLineToArgv ֐ŕԂꂽ argv ̒lB
		**/
		void releaseArgvA(int argc,str* argv);
		void releaseArgvW(int argc,wstr* argv);

#if defined(_UNICODE)||defined(UNICODE)
		inline bool createArgument(ArgVW** in,cwstr txt,cwstr divide = NULL,bool isQuote = true){
			return createArgumentW(in,txt,divide,isQuote);
		}
		inline bool createArgumentFromCommandLine(ArgVW** in,ARGTYPE type = CONSOLE){
			return createArgumentFromCommandLineW(in,type);
		}
		inline bool commandLineToArgv(int* argc,wstr** argv,ARGTYPE type = CONSOLE){
			commandLineToArgvW(argc,argv,type);
		}
		inline void releaseArgv(int argc,wstr* argv){releaseArgvW(argc,argv);}
#else
		inline bool createArgument(ArgVA* in,cstr txt,cstr divide = NULL,bool isQuote = true){
			return createArgumentA(in,txt,divide,isQuote);
		}
		inline bool createArgumentFromCommandLine(ArgVA* in,ARGTYPE type = CONSOLE){
			return createArgumentFromCommandLineA(in,type);
		}
		inline bool commandLineToArgv(int* argc,str** argv,ARGTYPE type = CONSOLE){
			commandLineToArgvA(argc,argv,type);
		}
		inline void releaseArgv(int argc,str* argv){releaseArgvA(argc,argv);}
#endif
	}

} // namespace scpl
#endif