// 
// Map.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _Map_INCLUDED_
#define _Map_INCLUDED_
#include "Container.h"
#include "find.h"
#include "Pair.h"

namespace scpl{

#define MAPTMP TMPC2_(Key,Val)
#define MAPFTMP TMPC2N1_(Key,Val,C)

	MAPTMP class CMap;
	MAPTMP class DMap;
	MAPFTMP class CFMap;
	MAPFTMP class DFMap;

	/**
		L[ƒlgăf[^ɃANZXꒊۃNXłB
		̃NX̊{@\ STL Cu map ɑ̂łA
		֐Ȃǂ͓ł͂܂B
		̃NX̓L[𕡐Ƃ͂܂B
	**/
	MAPTMP class IMap : public IContainer_accessable<Pair<Key,Val> >{
	public:
		typedef Pair<Key,Val>			MPair;
		typedef Pair<Key,Val>&			ind_p;
		typedef const Pair<Key,Val>&	cind_p;
		typedef Pair<Key,Val>*			ptr_p;
		typedef const Pair<Key,Val>*	cptr_p;
		typedef Key&		ind_k;
		typedef const Key&	cind_k;
		typedef Key*		ptr_k;
		typedef const Key*	cptr_k;
		typedef Val&		ind_v;
		typedef const Val&	cind_v;
		typedef Val*		ptr_v;
		typedef const Val*	cptr_v;

		IMap():_UseCount(0){}

		virtual ~IMap(){}

		/**
			f[^LĂȂԂ܂B
			[return]
			f[^LĂȂꍇ true AłȂꍇ false Ԃ܂B
		**/
		virtual bool empty()const{return _UseCount == 0;}
		/**
			LĂf[^̐Ԃ܂B
			[return]
			LĂf[^̐B
		**/
		virtual ulong count()const{return _UseCount;}

		/**
			w肵L[ɑΉf[^Ԃ܂B
			w肵L[݂Ȃꍇ͍쐬ĕԂ܂B
			[arg]
			key	: L[B
			[return]
			L[ɑΉf[^B
			[exc]
			std::bad_alloc	: ǉ邽߂ɕKvȗ̈mۂłȂB
		**/
		Val& at(cind_k key){
			long i = find(key);
			if(i < 0) i = set(key);
			return begin()[i].getR();
		}
		/**
			w肵L[ɑΉf[^Ԃ܂B
			[arg]
			key	: L[B
			[return]
			L[ɑΉf[^B
			[exc]
			std::invalid_argument	: L[ȂB
		**/
		const Val& at(cind_k key)const{
			long i = find(key);
			if(i < 0) THROW_NOT_FOUND();
			return begin()[i].getR();
		}

		/**
			w肵L[ƃL[ɑΉf[^Zbg܂B
			łɃL[݂ꍇ̓f[^㏑܂B
			[arg]
			key	: ZbgL[B
			val	: Zbgf[^B
			[return]
			ZbgL[̈ʒuB
			[exc]
			std::bad_alloc	: ǉ邽߂ɕKvȗ̈mۂłȂB
		**/
		virtual long set(cind_k key,cind_v val=Val())=0;

		/**
			w肵L[ƃL[ɑΉf[^폜܂B
			[arg]
			key	: 폜L[B
			[return]
			폜ꍇ true AłȂꍇ false Ԃ܂B
		**/
		virtual bool remove(cind_k key)=0;

		/**
			w肵L[݂邩𒲂ׂ܂B
			[arg]
			key	: ׂL[B
			[return]
			݂ꍇ͂̈ʒuԂA݂Ȃꍇ -1 Ԃ܂B
		**/
		long find(cind_k key)const{
			cptr_p it=begin(),e=end();
			for(long i=0;it<e;++i,++it){
				if(key == it->getL()) return i;
			}
			return -1;
		}

		/**
			w肵yAzƈv邩Ԃ܂B
			[arg]
			p	: rf[^zB
			c	: f[^̐B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		virtual bool equals(cptr_p p,ulong c)const{return _conatiner_equals(p,c,begin(),count());}

	protected:
		ulong	_UseCount;

	};
	/**
		ϒ}bv̒ۃNXłB
	**/
	MAPTMP class IMap_Buffer : public IMap<Key,Val>{
	protected:
		void _swap(IMap_Buffer<Key,Val>* s){_container_swap(_List,_UseCount,s->_List,s->_UseCount);}

	public:
		IMap_Buffer(ulong c=0):_List(c){}

		virtual ~IMap_Buffer(){}

		/**
			i[\̐Ԃ܂B
			[return]
			i[\B
		**/
		virtual ulong capacity()const{return _List.count();}

		/**
			p̍ŏ̈ʒu|C^Ԃ܂B
			[return]
			z̍ŏ̈ʒu|C^B
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		virtual ptr begin(){return empty()?NULL:_List.begin();}
		virtual cptr begin()const{return empty()?NULL:_List.begin();}
		/**
			p̍Ō̈ʒu|C^Ԃ܂B
			[return]
			z̍Ō̈ʒu|C^B
			̈ʒüOLĂI[łB
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		virtual ptr rbegin(){return empty()?NULL:(_List.begin()+count()-1);}
		virtual cptr rbegin()const{return empty()?NULL:(_List.begin()+count()-1);}
		/**
			tp̍ŏ̈ʒu|C^Ԃ܂B
			[return]
			tz̍ŏ̈ʒu|C^B
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		virtual ptr end(){return empty()?NULL:(_List.begin()+count());}
		virtual cptr end()const{return empty()?NULL:(_List.begin()+count());}
		/**
			tp̍Ō̈ʒu|C^Ԃ܂B
			[return]
			tz̍Ō̈ʒu|C^B
			̈ʒüオLĂI[łB
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		virtual ptr rend(){return empty()?NULL:(_List.begin()-1);}
		virtual cptr rend()const{return empty()?NULL:(_List.begin()-1);}

		/**
			cmۉ\̈ݒ肵܂B
			[arg]
			cap	: ݒ肷cmۉ\̈̐B
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		void adjust(ulong cap=0){_List.aResize(count()+cap);}

	protected:
		Buffer<MPair>	_List;

	};
	/**
		Œ蒷}bv̒ۃNXłB

		̃NX̃o֐̐́A IMap_Buffer NX
		QƂĂB
	**/
	MAPFTMP class IMap_Fixed : public IMap<Key,Val>{
	protected:
		void _swap(IMap_Fixed<Key,Val,C>* s){_container_swap_fixed(_List,_UseCount,s->_List,s->_UseCount);}
	public:
		virtual ~IMap_Fixed(){}
		virtual ulong capacity()const{return C;}
		virtual ptr begin(){return empty()?NULL:_List.begin();}
		virtual cptr begin()const{return empty()?NULL:_List.begin();}
		virtual ptr end(){return empty()?NULL:(_List.begin()+count());}
		virtual cptr end()const{return empty()?NULL:(_List.begin()+count());}
		virtual ptr rbegin(){return empty()?NULL:(_List.begin()+count()-1);}
		virtual cptr rbegin()const{return empty()?NULL:(_List.begin()+count()-1);}
		virtual ptr rend(){return empty()?NULL:(_List.begin()-1);}
		virtual cptr rend()const{return empty()?NULL:(_List.begin()-1);}
	protected:
		FBuffer<MPair,C>	_List;
	};

	/**
		NX̃RXgN^EfXgN^ɑΉA
		L[Ef[^̉ϒyAzReiNXłB
		̃NX̊{@\ STL Cu map ɑ̂łA
		֐Ȃǂ͓ł͂܂B
	**/
	MAPTMP class CMap : public IMap_Buffer<Key,Val>{
		typedef CMap<Key,Val> self;

	public:
		/**
			́A邢͎w肵̈mۂč쐬܂B
			[arg]
			c	: mۂ̈B
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		CMap(ulong c=0):IMap_Buffer<Key,Val>(c){}
		/**
			w肵f[^zRs[Xg쐬܂B
			[arg]
			p	: Rs[̃f[^zB
			c	: f[^̐B
			[exc]
			std::bad_alloc	: Rs[ɕKvȗ̈mۂłȂB
		**/
		CMap(cptr_p p,ulong c):IMap_Buffer<Key,Val>(c){copy(p,c);}
		/**
			w肵}bv̕쐬܂B
			[arg]
			s	: }bvB
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		explicit CMap(const self& s):IMap_Buffer<Key,Val>(s.count()){copy(s.begin(),s.count());}

		/**
			fXgN^B
			f[^Sč폜܂B
		**/
		virtual ~CMap(){clear();}

		/**
			w肵yAzRs[܂B
			[arg]
			p	: Rs[̃yAzB
			c	: yA̐B
			[exc]
			std::bad_alloc	: Rs[ɕKvȗ̈mۂłȂB
		**/
		virtual void copy(cptr_p data,ulong c){
			if(capacity() < c) adjust(c - count());
			clear();
			_container_copy(data,c,_List,_UseCount);
		}
		/**
			f[^Sč폜܂B
		**/
		virtual void clear(){_container_clear(_List,_UseCount);}
		/**
			f[^LĂ邩Ԃ܂B
			[return]
			f[^LĂꍇ true AłȂꍇ false Ԃ܂B
		**/
		operator bool()const{return !empty();}
		/**
			f[^LĂȂԂ܂B
			[return]
			f[^LĂȂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!()const{return empty();}

		/**
			w肵L[ɑΉf[^Ԃ܂B
			w肵L[݂Ȃꍇ͍쐬ĕԂ܂B
			[arg]
			key	: L[B
			[return]
			L[ɑΉf[^B
			[exc]
			std::bad_alloc	: ǉ邽߂ɕKvȗ̈mۂłȂB
		**/
		ind_v operator[](cind_k key){return at(key);}
		/**
			w肵L[ɑΉf[^Ԃ܂B
			[arg]
			key	: L[B
			[return]
			L[ɑΉf[^B
			[exc]
			std::invalid_argument	: L[ȂB
		**/
		cind_v operator[](cind_k key)const{return at(key);}

		/**
			w肵}bvƈv邩Ԃ܂B
			[arg]
			s	: r}bvB
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator==(const CMap<Key,Val>& s)const{return equals(s.begin(),s.count());}
		bool operator==(const DMap<Key,Val>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const CFMap<Key,Val,N>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const DFMap<Key,Val,N>& s)const{return equals(s.begin(),s.count());}

		/**
			w肵}bvƕsvԂ܂B
			[arg]
			s	: r}bvB
			[return]
			sv̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!=(const CMap<Key,Val>& s)const{return !equals(s.begin(),s.count());}
		bool operator!=(const DMap<Key,Val>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const CFMap<Key,Val,N>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const DFMap<Key,Val,N>& s)const{return !equals(s.begin(),s.count());}

		/**
			w肵}bv܂B
			[arg]
			s	: }bvB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		self& operator=(const CMap<Key,Val>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const DMap<Key,Val>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const CFMap<Key,Val,N>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const DFMap<Key,Val,N>& s){copy(s.begin(),s.count());return *this;}

		/**
			w肵}bvƓeւ܂B
			[arg]
			s	: ւ}bvB
		**/
		void swap(self& s){_swap(&s);}

		/**
			L̃o֐̐ IMap NXQƂĂB
		**/
		virtual long set(cind_k key,cind_v val=Val()){
			long i = find(key);
			if(i < 0){
				MPair mp(key,val);
				return _container_insert(&mp,1,_UseCount,_List,_UseCount);
			}
			begin()[i].setR(val);
			return i;
		}
		virtual bool remove(cind_k key){
			long i = find(key);
			if(i >= 0) _container_erage(begin()+i,begin()+i+1,_List,_UseCount);
			return (i >= 0);
		}

	};
	/**
		L[Ef[^̉ϒyAzReiNXłB
		̃NX̊{@\ STL Cu map ɑ̂łA
		֐Ȃǂ͓ł͂܂B

		̃NX̓RXgN^EfXgN^𔭐܂B
		̂߁ANXgpf[^Ǘꍇ
		CMap gpĂB

		̃NX̃o֐ CMap Ɠs܂B
		eo֐̐ CMap ̃o֐QƂĂB
	**/
	MAPTMP class DMap : public IMap_Buffer<Key,Val>{
		typedef DMap<Key,Val> self;
	public:
		DMap(ulong c=0):IMap_Buffer<Key,Val>(c){}
		DMap(cptr_p p,ulong c):IMap_Buffer<Key,Val>(c){copy(p,c);}
		explicit DMap(const self& s):IMap_Buffer<Key,Val>(s.count()){copy(s.begin(),s.count());}
		virtual ~DMap(){}
		virtual long set(cind_k key,cind_v val=Val()){
			long i = find(key);
			if(i < 0){
				MPair mp(key,val);
				return _container_insert_n(&mp,1,_UseCount,_List,_UseCount);
			}
			begin()[i].setR(val);
			return i;
		}
		virtual bool remove(cind_k key){
			long i = find(key);
			if(i >= 0) _container_erage_n(begin()+i,begin()+i+1,_List,_UseCount);
			return (i >= 0);
		}
		virtual void copy(cptr_p data,ulong c){
			if(capacity() < c) adjust(c - count());
			clear();
			_container_copy_n(data,c,_List,_UseCount);
		}
		virtual void clear(){_UseCount = 0;}
		operator bool()const{return !empty();}
		bool operator!()const{return empty();}
		ind_v operator[](cind_k key){return at(key);}
		cind_v operator[](cind_k key)const{return at(key);}
		bool operator==(const CMap<Key,Val>& s)const{return equals(s.begin(),s.count());}
		bool operator==(const DMap<Key,Val>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const CFMap<Key,Val,N>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const DFMap<Key,Val,N>& s)const{return equals(s.begin(),s.count());}
		bool operator!=(const CMap<Key,Val>& s)const{return !equals(s.begin(),s.count());}
		bool operator!=(const DMap<Key,Val>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const CFMap<Key,Val,N>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const DFMap<Key,Val,N>& s)const{return !equals(s.begin(),s.count());}
		self& operator=(const CMap<Key,Val>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const DMap<Key,Val>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const CFMap<Key,Val,N>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const DFMap<Key,Val,N>& s){copy(s.begin(),s.count());return *this;}
		void swap(self& s){_swap(&s);}
	};
	/**
		NX̃RXgN^EfXgN^ɑΉA
		L[Ef[^̌Œ蒷yAzReiNXłB
		̃NX̊{@\ STL Cu map ɑ̂łA
		֐Ȃǂ͓ł͂܂B

		̃NX̃o֐ CMap Ɠs܂B
		eo֐̐ CMap ̃o֐QƂĂB
		Œ蒷f[^߁A CMap A DMap ɂ Capacity ̈
		삷鏈i adjust ֐A clear ֐ clearCap j݂͑܂B
		[note]
		̃NX͌Œ蒷f[^߁A
		eʂ𒴂f[^̒ǉs std::runtime_error O
		܂B
	**/
	MAPFTMP class CFMap : public IMap_Fixed<Key,Val,C>{
		typedef CFMap<Key,Val,C> self;
	public:
		CFMap():IMap_Fixed<Key,Val,C>(){}
		CFMap(cptr_p p,ulong c):IMap_Fixed<Key,Val,C>(){copy(p,c);}
		explicit CFMap(const self& s):IMap_Fixed<Key,Val,C>(){copy(s.begin(),s.count());}
		virtual ~CFMap(){clear();}
		virtual long set(cind_k key,cind_v val=Val()){
			long i = find(key);
			if(i < 0){
				MPair mp(key,val);
				return _container_insert_fixed(&mp,1,_UseCount,_List,_UseCount);
			}
			begin()[i].setR(val);
			return i;
		}
		virtual bool remove(cind_k key){
			long i = find(key);
			if(i >= 0) _container_erage_fixed(begin()+i,begin()+i+1,_List,_UseCount);
			return (i >= 0);
		}
		virtual void copy(cptr_p data,ulong c){clear();_container_copy_fixed(data,c,_List,_UseCount);}
		virtual void clear(){_container_clear_fixed(_List,_UseCount);}
		operator bool()const{return !empty();}
		bool operator!()const{return empty();}
		ind_v operator[](cind_k key){return at(key);}
		cind_v operator[](cind_k key)const{return at(key);}
		bool operator==(const CMap<Key,Val>& s)const{return equals(s.begin(),s.count());}
		bool operator==(const DMap<Key,Val>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const CFMap<Key,Val,N>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const DFMap<Key,Val,N>& s)const{return equals(s.begin(),s.count());}
		bool operator!=(const CMap<Key,Val>& s)const{return !equals(s.begin(),s.count());}
		bool operator!=(const DMap<Key,Val>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const CFMap<Key,Val,N>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const DFMap<Key,Val,N>& s)const{return !equals(s.begin(),s.count());}
		self& operator=(const CMap<Key,Val>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const DMap<Key,Val>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const CFMap<Key,Val,C>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const DFMap<Key,Val,C>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const CFMap<Key,Val,N>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const DFMap<Key,Val,N>& s){copy(s.begin(),s.count());return *this;}
		void swap(self& s){_swap(&s);}
	};
	/**
		L[Ef[^̌Œ蒷yAzReiNXłB
		̃NX̊{@\ STL Cu map ɑ̂łA
		֐Ȃǂ͓ł͂܂B

		̃NX̓RXgN^EfXgN^𔭐܂B
		̂߁ANXgpf[^Ǘꍇ
		CFMap gpĂB

		̃NX̃o֐ CMap Ɠs܂B
		eo֐̐ CMap ̃o֐QƂĂB
		Œ蒷f[^߁A CMap A DMap ɂ Capacity ̈
		삷鏈i adjust ֐A clear ֐ clearCap j݂͑܂B
		[note]
		̃NX͌Œ蒷f[^߁A
		eʂ𒴂f[^̒ǉs std::runtime_error O
		܂B
	**/
	MAPFTMP class DFMap : public IMap_Fixed<Key,Val,C>{
		typedef DFMap<Key,Val,C> self;
	public:
		DFMap():IMap_Fixed<Key,Val,C>(){}
		DFMap(cptr_p p,ulong c):IMap_Fixed<Key,Val,C>(){copy(p,c);}
		explicit DFMap(const self& s):IMap_Fixed<Key,Val,C>(){copy(s.begin(),s.count());}
		virtual ~DFMap(){}
		virtual long set(cind_k key,cind_v val=Val()){
			long i = find(key);
			if(i < 0){
				MPair mp(key,val);
				return _container_insert_fixed_n(&mp,1,_UseCount,_List,_UseCount);
			}
			begin()[i].setR(val);
			return i;
		}
		virtual bool remove(cind_k key){
			long i = find(key);
			if(i >= 0) _container_erage_fixed_n(begin()+i,begin()+i+1,_List,_UseCount);
			return (i >= 0);
		}
		virtual void copy(cptr_p data,ulong c){clear();_container_copy_fixed_n(data,c,_List,_UseCount);}
		virtual void clear(){_UseCount=0;}
		operator bool()const{return !empty();}
		bool operator!()const{return empty();}
		ind_v operator[](cind_k key){return at(key);}
		cind_v operator[](cind_k key)const{return at(key);}
		bool operator==(const CMap<Key,Val>& s)const{return equals(s.begin(),s.count());}
		bool operator==(const DMap<Key,Val>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const CFMap<Key,Val,N>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const DFMap<Key,Val,N>& s)const{return equals(s.begin(),s.count());}
		bool operator!=(const CMap<Key,Val>& s)const{return !equals(s.begin(),s.count());}
		bool operator!=(const DMap<Key,Val>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const CFMap<Key,Val,N>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const DFMap<Key,Val,N>& s)const{return !equals(s.begin(),s.count());}
		self& operator=(const CMap<Key,Val>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const DMap<Key,Val>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const CFMap<Key,Val,C>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const DFMap<Key,Val,C>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const CFMap<Key,Val,N>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const DFMap<Key,Val,N>& s){copy(s.begin(),s.count());return *this;}
		void swap(self& s){_swap(&s);}
	};


} // namespace scpl
#endif