// 
// Range.h
// 
// Copyright(C) 2007 Ó
#ifndef _Range_INCLUDED_
#define _Range_INCLUDED_

namespace scpl{

	/**
		w肵͈͂ł̒l̊ǗsNXłB
		̃NXg΁Aől̉̈ʒuɂ邩ȂǁAʒu
		ȒPɎ擾邱Ƃł܂B
		܂Aw肵͈͊Oɒlݒ肷邱ƂłȂ悤ɂĂ邽߁A
		I[o[t[ȂǂCɂɐi󋵂ȂǂǗ邱Ƃł܂B

		ev[gF
			V	: őlEŏlƌݒľ^B
			X	:
			ZɎgp^B V 葽\ł signed ^gp邱ƂɂA
			I[o[t[EA_[t[}邱Ƃł܂B

	**/
	template<class V>
	class Range{
		typedef Range<V> self;

	public:
		/**
			͈̔͂ݒ肵č쐬܂B
		**/
		Range():_Min(0),_Max(100),_Val(0){}
		/**
			͈͂ݒ肵č쐬܂B
			[arg]
			min	: ŏlB
			max	: őlB
			[note]
			쐬̌ݒl͍ŏlɐݒ肳܂B
			͈͂sȏꍇ͍ŏlɊۂ߂܂B
		**/
		Range(V min,V max):_Min(min),_Max(max),_Val(min){
			if(min > max) _Max = min;
		}
		/**
			͈͂ƌݒlݒ肵č쐬܂B
			[arg]
			min	: ŏlB
			max	: őlB
			val	: ݒlB
			[note]
			͈͂sȒl͌ݒlɊۂ߂܂B
		**/
		Range(V min,V max,V val):_Val(val){
			_Min = (min > val)?val:min;
			_Max = (max < val)?val:max;
		}

		/**
			ݒlCNg܂B
			őlȍ~͑܂B
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator++(){inc();return *this;}
		self& operator++(int){inc();return *this;}
		/**
			ݒlCNg܂B
			őlȍ~͑܂B
		**/
		void inc(){_Val += static_cast<byte>(_Val<_Max);}
		/**
			ݒlfNg܂B
			ŏlȍ~͌܂B
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator--(){dec();return *this;}
		self& operator--(int){dec();return *this;}
		/**
			ݒlfNg܂B
			ŏlȍ~͌܂B
		**/
		void dec(){_Val -= static_cast<byte>(_Min<_Val);}

		/**
			ݒl𑝉܂B
			őlȍ~͑܂B
			[arg]
			v	: ʁB
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator+=(V v){plus(v);return *this;}
		/**
			ݒl𑝉܂B
			őlȍ~͑܂B
			[arg]
			v	: ʁB
		**/
		void plus(V v){
			V val = _Val + v;
			_Val = ((val > _Max)||(val < _Val))?_Max:val;
		}
		/**
			ݒl܂B
			ŏlȍ~͌܂B
			[arg]
			v	: ʁB
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator-=(V v){minus(v);return *this;}
		/**
			ݒl܂B
			ŏlȍ~͌܂B
			[arg]
			v	: ʁB
		**/
		void minus(V v){
			V val = _Val - v;
			_Val = ((val < _Min)||(val > _Val))?_Min:val;
		}

		/**
			ݒlԂ܂B
			[return]
			ݒlB
		**/
		operator V()const{return _Val;}

		/**
			lőlɂ邩ǂԂ܂B
			[return]
			őlɂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool isMax()const{return (_Val == _Max);}
		/**
			lŏlɂ邩ǂԂ܂B
			[return]
			ŏlɂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool isMin()const{return (_Val == _Min);}
		/**
			lŒԁiŏlƍőljɂ邩ǂԂ܂B
			[return]
			ŒԂɂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool isFixed()const{return (_Min == _Max);}

		/**
			ݒlԂ܂B
			[return]
			ݒlB
		**/
		V getVal()const{return _Val;}
		/**
			őlԂ܂B
			[return]
			őlB
		**/
		V getMin()const{return _Min;}
		/**
			ŏlԂ܂B
			[return]
			ŏlB
		**/
		V getMax()const{return _Max;}
		/**
			͈̗͂ʂԂ܂B
			[return]
			ŏlől̊Ԃ͈̗̔͂ʁB
		**/
		ulong getRange()const{return static_cast<ulong>(_Max) - static_cast<ulong>(_Min);}
		/**
			͈̗͂ʂ 64bit lŕԂ܂B
			[return]
			ŏlől̊Ԃ͈̗̔͂ʁB
		**/
		ui64 getRange64()const{return static_cast<ui64>(_Max) - static_cast<ui64>(_Min);}

		/**
			ݒlݒ肵܂B
			[arg]
			v	: ݒlݒ肷lB
			[note]
			ݒ肷l͈͊ȌꍇA
			͈͓̋ߎlɊۂ߂Đݒ肳܂B
		**/
		void setVal(V v){
			_Val = (_Max < v)?_Max:((_Min > v)?_Min:v);
		}
		/**
			ŏlݒ肵܂B
			[arg]
			v	: ŏlݒ肷lB
			[note]
			ݒ肷lݒl𒴂ꍇA
			ݒlɊۂ߂Đݒ肳܂B
		**/
		void setMin(V v){
			_Min = (_Val < v)?_Val:v;
		}
		/**
			őlݒ肵܂B
			[arg]
			v	: őlݒ肷lB
			[note]
			ݒ肷lݒl̏ꍇA
			ݒlɊۂ߂Đݒ肳܂B
		**/
		void setMax(V v){
			_Max = (_Val > v)?_Val:v;
		}
		/**
			͈͂ݒ肵č쐬܂B
			[arg]
			min	: ŏlݒ肷lB
			max	: őlݒ肷lB
			[note]
			ݒ肷lȂ͈͂̏ꍇ͂̒lݒlɐݒ肵܂B
		**/
		void set(V min,V max){
			_Min = (_Val < min)?_Val:min;
			_Max = (_Val > max)?_Val:max;
		}
		/**
			[arg]
			min	: ŏlݒ肷lB
			max	: őlݒ肷lB
			val : ݒlݒ肷lB
			[note]
			ݒ肷lȂ͈͂̏ꍇ͂̒l val ɐݒ肵܂B
		**/
		void set(V min,V max,V val){
			_Min = (_Val < min)?val:min;
			_Max = (_Val > max)?val:max;
			_Val = val;
		}

		/**
			ݒli(int)ŕԂ܂B
			[return]
			iiPʁjB
			[note]
			Œԁiŏlƍőlj̏ꍇ 0 Ԃ܂B
		**/
		int getProgressParInt()const{return (_Min==_Max)?0:static_cast<int>(getProgress() / static_cast<double>(getRange()) * 100);}
		/**
			ݒli(double)ŕԂ܂B
			[return]
			iiPʁjB
			[note]
			Œԁiŏlƍőlj̏ꍇ 0.0 Ԃ܂B
		**/
		double getProgressParDouble()const{return (_Min==_Max)?0.0:(getProgress() / static_cast<double>(getRange()));}
		/**
			ݒli(float)ŕԂ܂B
			[return]
			iiPʁjB
			[note]
			Œԁiŏlƍőlj̏ꍇ 0.0 Ԃ܂B
		**/
		float getProgressParFloat()const{return (_Min==_Max)?0.0f:(getProgress() / static_cast<float>(getRange()));}

		/**
			ݒlci(int)ŕԂ܂B
			[return]
			ciiPʁjB
			[note]
			Œԁiŏlƍőlj̏ꍇ 0 Ԃ܂B
		**/
		int getRProgressParInt()const{return (_Min==_Max)?0:static_cast<int>(getRProgress() / static_cast<double>(getRange()) * 100);}
		/**
			ݒlci(double)ŕԂ܂B
			[return]
			ciiPʁjB
			[note]
			Œԁiŏlƍőlj̏ꍇ 0.0 Ԃ܂B
		**/
		double getRProgressParDouble()const{return (_Min==_Max)?0.0:(getRProgress() / static_cast<double>(getRange()));}
		/**
			ݒlci(float)ŕԂ܂B
			[return]
			ciiPʁjB
			[note]
			Œԁiŏlƍőlj̏ꍇ 0.0 Ԃ܂B
		**/
		float getRProgressParFloat()const{return (_Min==_Max)?0.0f:(getRProgress() / static_cast<float>(getRange()));}

		/**
			ݒlilŕԂ܂B
			[return]
			ilB
		**/
		V getProgress()const{return _Val - _Min;}
		/**
			ݒlcilŕԂ܂B
			[return]
			cilB
		**/
		V getRProgress()const{return _Max - _Val;}

	private:
		V _Min,_Max,_Val;

	};

} // namespace scpl
#endif
