// 
// flag.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _flag_INCLUDED_
#define _flag_INCLUDED_
#include "scpl.h"

/**
	tO𑀍삷CC֐QłB
**/

namespace scpl{

	/**
		 2byte lf[^킹 4byte lɂ܂B
		[arg]
		upper	:  16bit Ɏw肷 16bit lB
		under	:  16bit Ɏw肷 16bit lB
		[return]
		ꂽ 32bit lB
	**/
	inline ulong lmake2(ushort upper,ushort under){return (upper << 16) | under;}
	/**
		l 1byte l킹 4byte lɂ܂B
		_24	: 24-31bit Ɏw肷 8bit lB
		_16	: 16-23bit Ɏw肷 8bit lB
		_8	:  8-15bit Ɏw肷 8bit lB
		_0	:  0- 7bit Ɏw肷 8bit lB
		[return]
		ꂽ 32bit lB
	**/
	inline ulong lmake4(byte _24,byte _16,byte _8,byte _0){return (_24 << 24) | (_16 << 16) | (_8 << 8) | _0;}

	/**
		 1byte l킹 2byte lf[^ɂ܂B
		[arg]
		upper	:  8bit Ɏw肷 8bit lB
		under	:  8bit Ɏw肷 8bit lB
		[return]
		ꂽ 16bit lB
	**/
	inline ushort smake2(byte upper,byte under){return static_cast<ushort>((upper << 8) | under);}

	/**
		 4byte l킹 8byte lɂ܂B
		[arg]
		upper	:  32bit Ɏw肷 32bit lB
		under	:  32bit Ɏw肷 32bit lB
		[return]
		ꂽ 64bit lB
	**/
	inline ui64 i64make2(ulong upper,ulong under){return (static_cast<ui64>(upper) << 32) | under;}
	/**
		l 2byte lf[^킹 8byte lɂ܂B
		_48	: 48-63bit Ɏw肷 16bit lB
		_32	: 32-47bit Ɏw肷 16bit lB
		_16	: 16-31bit Ɏw肷 16bit lB
		_0	:  0-15bit Ɏw肷 16bit lB
		[return]
		ꂽ 64bit lB
	**/
	inline ui64 i64make4(ushort _24,ushort _16,ushort _8,ushort _0){return (static_cast<ui64>(_24) << 48) | (static_cast<ui64>(_16) << 32) | (_8 << 16) | _0;}
	/**
		 1byte l킹 8byte lɂ܂B
		_56	: 56-63bit Ɏw肷 8bit lB
		_48	: 48-55bit Ɏw肷 8bit lB
		_40	: 40-47bit Ɏw肷 8bit lB
		_32	: 32-39bit Ɏw肷 8bit lB
		_24	: 24-31bit Ɏw肷 8bit lB
		_16	: 16-23bit Ɏw肷 8bit lB
		_8	:  8-15bit Ɏw肷 8bit lB
		_0	:  0- 7bit Ɏw肷 8bit lB
		[return]
		ꂽ 64bit lB
	**/
	inline ui64 i64make8(byte _56,byte _48,byte _40,byte _32,byte _24,byte _16,byte _8,byte _0){
		return
			(static_cast<ui64>(_56) << 56) |
			(static_cast<ui64>(_48) << 48) |
			(static_cast<ui64>(_40) << 40) |
			(static_cast<ui64>(_32) << 32) |
			(static_cast<ui64>(_24) << 24) |
			(static_cast<ui64>(_16) << 16) |
			(static_cast<ui64>(_8)  <<  8) |
			static_cast<ui64>(_0);
	}

	/**
		4byte l 2byte A 2byte ɕ܂B
		[arg]
		src		:  4byte f[^B
		upper	:  2byte 擾ϐB
		under	:  2byte 擾ϐB
	**/
	inline void lsplit2(ulong src,ushort& upper,ushort& under){
		upper = static_cast<ushort>(src>>16);
		under = static_cast<ushort>(src);
	}
	/**
		4byte ll 1byte lɕ܂B
		[arg]
		src	:  4byte f[^B
		_24	: 24-31bit  1byte l擾ϐB
		_16	: 16-23bit  1byte l擾ϐB
		_8	:  8-15bit  1byte l擾ϐB
		_0	:  0- 7bit  1byte l擾ϐB
	**/
	inline void lsplit4(ulong src,byte& _24,byte& _16,byte& _8,byte& _0){
		_24 = static_cast<byte>(src>>24);
		_16 = static_cast<byte>(src>>16);
		_8  = static_cast<byte>(src>>8);
		_0  = static_cast<byte>(src);
	}

	/**
		2byte l 1byte A 1byte ɕ܂B
		[arg]
		src		:  2byte f[^B
		upper	:  1byte 擾ϐB
		under	:  1byte 擾ϐB
	**/
	inline void ssplit2(ushort src,byte& upper,byte& under){
		upper = static_cast<byte>(src>>8);
		under = static_cast<byte>(src);
	}

	/**
		8byte l 4byte A 4byte ɕ܂B
		[arg]
		src		:  8byte f[^B
		upper	:  4byte 擾ϐB
		under	:  4byte 擾ϐB
	**/
	inline void i64split2(ui64 src,ulong& upper,ulong& under){
		upper = static_cast<ulong>(src>>32);
		under = static_cast<ulong>(src);
	}
	/**
		8byte ll 2byte lɕ܂B
		[arg]
		src	:  8byte f[^B
		_48	: 48-63bit  2byte l擾ϐB
		_32	: 32-47bit  2byte l擾ϐB
		_16	: 16-31bit  2byte l擾ϐB
		_0	:  0-15bit  2byte l擾ϐB
	**/
	inline void i64split4(ui64 src,ushort& _48,ushort& _32,ushort& _16,ushort& _0){
		_48 = static_cast<ushort>(src>>48);
		_32 = static_cast<ushort>(src>>32);
		_16 = static_cast<ushort>(src>>16);
		_0  = static_cast<ushort>(src);
	}
	/**
		8byte l𔪂 1byte lɕ܂B
		[arg]
		src	:  8byte f[^B
		_56	: 56-63bit  1byte l擾ϐB
		_48	: 48-55bit  1byte l擾ϐB
		_40 : 40-47bit  1byte l擾ϐB
		_32	: 32-39bit  1byte l擾ϐB
		_24	: 24-31bit  1byte l擾ϐB
		_16	: 16-23bit  1byte l擾ϐB
		_8	:  8-15bit  1byte l擾ϐB
		_0	:  0- 7bit  1byte l擾ϐB
	**/
	inline void i64split8(ui64 src,byte& _56,byte& _48,byte& _40,byte& _32,byte& _24,byte& _16,byte& _8,byte& _0){
		_56 = static_cast<byte>(src>>56);
		_48 = static_cast<byte>(src>>48);
		_40 = static_cast<byte>(src>>40);
		_32 = static_cast<byte>(src>>32);
		_24 = static_cast<byte>(src>>24);
		_16 = static_cast<byte>(src>>16);
		_8  = static_cast<byte>(src>> 8);
		_0  = static_cast<byte>(src);
	}

	/**
		4byte l̏ 2byte lԂ܂B
		[arg]
		src 擾 4byte lB
		[return]
		 2byte lB
	**/
	inline ushort lget2_up(ulong src){return static_cast<ushort>(src>>16);}
	/**
		4byte l̉ 2byte lԂ܂B
		[arg]
		src 擾 4byte lB
		[return]
		 2byte lB
	**/
	inline ushort lget2_un(ulong src){return static_cast<ushort>(src);}

	/**
		4byte l 1byte l(24-31bit)Ԃ܂B
		[arg]
		src 擾 4byte lB
		[return]
		1byte l(24-31bit)B
	**/
	inline byte lget4_24(ulong src){return static_cast<byte>(src>>24);}
	/**
		4byte l 1byte l(16-24bit)Ԃ܂B
		[arg]
		src 擾 4byte lB
		[return]
		1byte l(16-24bit)B
	**/
	inline byte lget4_16(ulong src){return static_cast<byte>(src>>16);}
	/**
		4byte l 1byte l( 8-15bit)Ԃ܂B
		[arg]
		src 擾 4byte lB
		[return]
		1byte l( 8-15bit)B
	**/
	inline byte lget4_8 (ulong src){return static_cast<byte>(src>>8);}
	/**
		4byte l 1byte l( 0- 7bit)Ԃ܂B
		[arg]
		src 擾 4byte lB
		[return]
		1byte l( 0- 7bit)B
	**/
	inline byte lget4_0 (ulong src){return static_cast<byte>(src);}

	/**
		2byte lf[^̏ 1byte lԂ܂B
		[arg]
		src 擾 2byte lB
		[return]
		 1byte lB
	**/
	inline byte sget2_up(ushort src){return static_cast<byte>(src>>8);}
	/**
		2byte lf[^̉ 1byte lԂ܂B
		[arg]
		src 擾 2byte lB
		[return]
		 1byte lB
	**/
	inline byte sget2_un(ushort src){return static_cast<byte>(src);}

	/**
		8byte l̏ 4byte lԂ܂B
		[arg]
		src 擾 8byte lB
		[return]
		 4byte lB
	**/
	inline ulong i64get2_up(ui64 src){return static_cast<ulong>(src>>32);}
	/**
		8byte l̉ 4byte lԂ܂B
		[arg]
		src 擾 8byte lB
		[return]
		 4byte lB
	**/
	inline ulong i64get2_un(ui64 src){return static_cast<ulong>(src);}

	/**
		8byte l 2byte l(48-63bit)Ԃ܂B
		[arg]
		src 擾 8byte lB
		[return]
		2byte l(48-63bit)B
	**/
	inline ushort i64get4_48(ui64 src){return static_cast<ushort>(src>>48);}
	/**
		8byte l 2byte l(32-47bit)Ԃ܂B
		[arg]
		src 擾 8byte lB
		[return]
		2byte l(32-47bit)B
	**/
	inline ushort i64get4_32(ui64 src){return static_cast<ushort>(src>>32);}
	/**
		8byte l 2byte l(16-31bit)Ԃ܂B
		[arg]
		src 擾 8byte lB
		[return]
		2byte l(16-31bit)B
	**/
	inline ushort i64get4_16(ui64 src){return static_cast<ushort>(src>>16);}
	/**
		8byte l 2byte l( 0-15bit)Ԃ܂B
		[arg]
		src 擾 8byte lB
		[return]
		2byte l( 0-15bit)B
	**/
	inline ushort i64get4_0 (ui64 src){return static_cast<ushort>(src);}

	/**
		8byte l 1byte l(56-63bit)Ԃ܂B
		[arg]
		src 擾 8byte lB
		[return]
		1byte l(56-63bit)B
	**/
	inline byte i64get8_56(ui64 src){return static_cast<byte>(src>>56);}
	/**
		8byte l 1byte l(48-55bit)Ԃ܂B
		[arg]
		src 擾 8byte lB
		[return]
		1byte l(48-55bit)B
	**/
	inline byte i64get8_48(ui64 src){return static_cast<byte>(src>>48);}
	/**
		8byte l 1byte l(40-47bit)Ԃ܂B
		[arg]
		src 擾 8byte lB
		[return]
		1byte l(40-47bit)B
	**/
	inline byte i64get8_40(ui64 src){return static_cast<byte>(src>>40);}
	/**
		8byte l 1byte l(32-39bit)Ԃ܂B
		[arg]
		src 擾 8byte lB
		[return]
		1byte l(32-39bit)B
	**/
	inline byte i64get8_32(ui64 src){return static_cast<byte>(src>>32);}
	/**
		8byte l 1byte l(24-31bit)Ԃ܂B
		[arg]
		src 擾 8byte lB
		[return]
		1byte l(24-31bit)B
	**/
	inline byte i64get8_24(ui64 src){return static_cast<byte>(src>>24);}
	/**
		8byte l 1byte l(16-23bit)Ԃ܂B
		[arg]
		src 擾 8byte lB
		[return]
		1byte l(16-23bit)B
	**/
	inline byte i64get8_16(ui64 src){return static_cast<byte>(src>>16);}
	/**
		8byte l 1byte l( 8-15bit)Ԃ܂B 
		[arg]
		src 擾 8byte lB
		[return]
		1byte l( 8-15bit)B
	**/
	inline byte i64get8_8 (ui64 src){return static_cast<byte>(src>>8);}
	/**
		8byte l 1byte l( 0- 7bit)Ԃ܂B
		[arg]
		src 擾 8byte lB
		[return]
		1byte l( 0- 7bit)B
	**/
	inline byte i64get8_0 (ui64 src){return static_cast<byte>(src);}

	/**
		w肵rbgʒũtOĂ邩Ԃ܂B
		[arg]
		flag	: ׂlB
		bit		: ׂrbgʒuB
		[return]
		rbgtOĂ true AłȂꍇ false Ԃ܂B
	**/
	template <class T>
	inline bool isFragOnBit(T flag,byte bit){return ((flag>>bit)&1)==1;}

	/**
		w肵tOSėĂ邩Ԃ܂B
		[arg]
		flag	: ׂlB
		bit		: ׂtOlB
		[return]
		rbgtOSėĂ true AłȂꍇ false Ԃ܂B
	**/
	template <class T>
	inline bool isFragOnAll(T flag,T check){return (flag&check)==check;}

	/**
		w肵tÔꂩĂ邩Ԃ܂B
		[arg]
		flag	: ׂlB
		bit		: ׂtOlB
		[return]
		rbgtÔꂩĂ true AłȂꍇ false Ԃ܂B
	**/
	template <class T>
	inline bool isFragOnOr(T flag,T check){return (flag&check)!=0;}

	/**
		tOSĔ]̂Ԃ܂B
		[arg]
		flag	: tO𔽓]lB
		[return]
		tO𔽓]lB
	**/
	template <class T>
	inline T flagRev(T flag){return ~flag;}
	/**
		tO}XNgĔ]܂B
		[arg]
		flag	: tO𔽓]lB
		mask	: ]}XNlB
		[return]
		tO𔽓]lB
	**/
	template <class T>
	inline T flagRev(T flag,T mask){return flag^mask;}

} // namespace scpl

#endif