// 
// smart_ptr.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _smart_ptr_INCLUDED_
#define _smart_ptr_INCLUDED_

#include "utility.h"
#include "exception.h"

namespace scpl{

/**
	[U[`̉s}N֐(smart_ptrNX̂)B
	̊֐Ă΂Ƃ́A\ȂƂ݂̂Ȃ̂ŁA
	|C^̃`FbN͕svłB
	܂A|C^̕ϐ_PtrłB
**/
#define smart_delete(type) template<> void scpl::smart_ptr<type>::manager::delptr()

	/**
		̃NX́AQƃJEgAQƂĂSẴ|C^
		NXȂA|C^͊J܂B

		̃NXgpꍇAR[hƂ킩܂Af[^ɃANZX
		Zqgpꍇ̓`FbNs܂ixׁ̌̈jB

		ӓ_ƂẮAQƂĂ|C^VNXɊ܂܂Ă͂܂B
		[pre]
		)
			smart_ptr<int> a(ptr),d,f;
			smart_ptr<int> b(ptr);     // NG
			smart_ptr<int> c(a.get()); // NG
			d = ptr;                   // NG
			smart_ptr<int> e(a);       // OK
			f = a;                     // OK
		[/pre]
		Ȃ 2 ` 4 sڂ NG Ȃ̂ƌƁA 1 sڂƓ
		i|C^ւ̎QƃJEg̐jsĂ܂Aꂼ̎QƃJEg
		LłȀꍇA ptr ɑ΂ 4 ̉sĂ܂܂B
		̎d 5 ` 6 sڂłB
		 2 ` 4 sڂ̂悤ȏȂ΂ȂȂꍇ́A managed_ptr NX
		gpĂB

		W̉ł delete y delete[] g܂A
		smart_delete }N֐gp΁Ǎ^̉sƂł܂B
		zۗLAǗꍇ smart_ary NXgpĂB
	**/
	TMP class smart_ptr{
	public:
		typedef T*           ptr;
		typedef T&           ind;
		typedef const T*     cptr;
		typedef const T&     cind;
		typedef smart_ptr<T> self;

	private:
		void dec_del(){
			if(_pm&&(_pm->dec() == 0))
				delete _pm;
		}

		class manager{
			ulong _Count;
			T* _Ptr;

		public:
			manager(T* ptr):_Count(1),_Ptr(ptr){}
			~manager(){if(_Ptr) delptr();}

			T* get(){return _Ptr;}
			const T* get()const{return _Ptr;}
			void delptr(){delete _Ptr;}
			ulong count()const{return _Count;}
			ulong inc(){return _Count?(++_Count):_Count;}
			ulong dec(){return _Count?(--_Count):_Count;}

		};

	public:

		/**
			Rs[RXgN^B
			[arg]
			p	: Rs[̃|C^B
		**/
		explicit smart_ptr(const self& p){
			_pm = p._pm;
			if(p._pm) _pm->inc();
		}

		/**
			NULL ۗL܂B
		**/
		smart_ptr():_pm(NULL){}
		/**
			|C^ۗL܂B
			[arg]
			p	: ۗL|C^B
			[exc]
			std::bad_alloc	: ۗL邽߂̗̈mۂłȂB
		**/
		explicit smart_ptr(ptr p):_pm(NULL){if(p) _pm = newcheck(new manager(p));}

		/**
			fXgN^B
			QƃJEg炵A[ɂȂ
			܂B
		**/
		~smart_ptr(){dec_del();}

		/**
			|C^݂邩Ԃ܂B
			[return]
			LĂ|C^݂Ȃ true AłȂꍇ false Ԃ܂B
		**/
		operator bool()const{return _pm != NULL;}
		/**
			|C^ NULL Ԃ܂B
			[return]
			LĂ|C^ NULL ̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!()const{return !_pm;}

		/**
			|C^v邩Ԃ܂B
			[arg]
			p	: r|C^B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator==(cptr p)const{return p == (_pm?_pm->get():NULL);}
		bool operator==(const self& p)const{return _pm == p._pm;}
		/**
			|C^svԂ܂B
			[arg]
			p	: r|C^B
			[return]
			sv̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!=(cptr p)const{return p != (_pm?_pm->get():NULL);}
		bool operator!=(const self& p)const{return _pm != p._pm;}

		/**
			w肵|C^NX܂B
			[arg]
			p	: |C^NXB
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator=(const self& p){set(p);return *this;}
		/**
			w肵|C^܂B
			[arg]
			p	: |C^B
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		self& operator=(ptr p){set(p);return *this;}
		/**
			w肵|C^܂B
			[arg]
			p	: |C^B
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		void set(const self& p){
			dec_del();
			_pm = const_cast<manager*>(p._pm);
			if(p._pm) _pm->inc();
		}
		void set(ptr p){
			dec_del();
			_pm = p?newcheck(new manager(p)):NULL;
		}

		/**
			̂QƂ܂B
			[return]
			LĂ|C^̊ԐڎQƂԂ܂B
		**/
		ind operator*()const{return *_pm->get();}
		/**
			oQƂ܂B
			[return]
			LĂ|C^B
		**/
		ptr operator->()const{return _pm->get();}

		/**
			̂Ԃ܂B
			[return]
			LĂ|C^̊ԐڎQƂԂ܂B
		**/
		ind getIndirect()const{return *_pm->get();}

		/**
			|C^Ԃ܂B
			[return]
			LĂ|C^B
		**/
		ptr get()const{return _pm?_pm->get():NULL;}
		ptr operator~()const{return _pm?_pm->get():NULL;}

		/**
			|C^ NULL Ԃ܂B
			[return]
			|C^ NULL ̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool empty()const{return !_pm;}

		/**
			QƃJEgԂ܂B
			[return]
			QƃJEgB
		**/
		ulong count()const{return _pm?_pm->count():0;}

		/**
			|C^ւ܂B
			[arg]
			p	: ւ|C^B
		**/
		void swap(self& p){scpl::swap(_pm,p._pm);}

		/**
			f[^NA܂B
			NULL ̂ƓłB
		**/
		void clear(){dec_del();_pm = NULL;}

	protected:
		manager* _pm;

	};

} // namespace scpl
#endif