// 
// sut.h
// 
// Copyright(C) 2007 Ó
#ifndef _sut_INCLUDED_
#define _sut_INCLUDED_

#include <process.h>
#include "scpl.h"
#include "exception.h"

namespace scpl{

	/**
		sut(Simple Unit Test)́APȃeXg
		ZNVƂ̃eXgs߂̊֐QłB
		̃wb_t@CɏĂ}N֐iȉeXg֐jgp
		eXgs܂B

		PȃeXgsꍇ

		SUT_ASSERT neXg֐y SUT_CHECK neXg֐gp
		eXgs܂B
		SUT_ASSERT neXg֐́AeXgɎsꍇA
		̏ꏊƌ\Aȍ~
		eXgs킸AŃeXg𒆎~i exit(-1) ĂяojďI܂B
		܂A "STOP" ̕teXg֐̓eXgɎsꍇ
		~AG^[L[܂őҋ@܂B
		IɃR\[Ă܂ꍇɗLłB
		SUT_CHECK neXg֐́AeXgɎsꍇA
		̏ꏊƌ\܂AĎ̏ɐi݂܂B
		IACӂ SUT_RESULT eXg֐ĂяoƂɂA
		eXgŜ̌ʂ\邱Ƃo܂B

		ZNVƂɃeXgsꍇ

		ł̃ZNV̓eXgs֐̒PʂƂĕ\܂B
		͂߂ SUT_ADDFUNC neXg֐ŃeXgs֐o^Ă܂B
		iŎw肷֐̂܂܃ZNVɂȂ܂j
		̂Ƃ "SUT_ADDFUNC" ɑ́A
		ZNVŃeXgɎsꍇ̏ɂāA
		LŐeƓs܂B
		o^IA SUT_START eXg֐ĂяoăeXgs܂B
		̊֐ł SUT_RESULT eXg֐ĂяoȂ̂ŁA
		Kvȏꍇ͌ĂяoĂB

		eXg֐̌ "STOP" ̂Ȃ SUT_ASSERT neXg֐́A
		USE_SUT_ASSERT_STOP }N`邱ƂɂA
		eXg֐̌ "STOP" ̂ SUT_ASSERT neXg֐
		s܂B

		eeXg֐̈ɂ

		V	: X ly Y l̕\^CvBL̂ꂩw肷B
				Int	: ^wi10i\j
				Hex	: ^wi16i\j
				I64	: 64bit ^wi10i\j
				H64	: 64bit ^wi16i\j
				Dbl	: ^w
				Ptr	: |C^^w
		B	: eXg]B
		X	: eXg]鍶ӒlB
		Y	: eXg]EӒlB
		F	: eXgs֐B

		[note]
		I64 y H64 ́AeXgs̕\@ VC++8 ̊g@\gpĂ邽߁A
		̃RpCł 32 bit ɋĕ\܂A
		eXĝ͕ς܂B
	**/
	namespace sut{

		typedef void (*TestFunc)();

#define	SUT_TEST_START() scpl::sut::_test_start()
#define	SUT_TEST_RESULT() scpl::sut::_test_result()

#define SUT_ASSERT_STOP(B) scpl::sut::_test_bool(2,B,__FILE__,__LINE__,#B)
#define SUT_ASSERT_EQUALS_STOP(V,X,Y) scpl::sut::_test_eq_##V(2,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ASSERT_NOTEQUALS_STOP(V,X,Y) scpl::sut::_test_neq_##V(2,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ASSERT_ABOVE_STOP(V,X,Y) scpl::sut::_test_a_##V(2,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ASSERT_BELOW_STOP(V,X,Y) scpl::sut::_test_b_##V(2,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ASSERT_EQAB_STOP(V,X,Y) scpl::sut::_test_aeq_##V(2,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ASSERT_EQBL_STOP(V,X,Y) scpl::sut::_test_beq_##V(2,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ADDFUNC_ASSERT_STOP(F) scpl::sut::_test_addfunc(2,__FILE__,__LINE__,#F,F)

/**[hybrid]**/
#ifdef USE_SUT_ASSERT_STOP
#define SUT_ASSERT(B) SUT_ASSERT_STOP(B)
#define SUT_ASSERT_EQUALS(V,X,Y) SUT_ASSERT_EQUALS_STOP(V,X,Y)
#define SUT_ASSERT_NOTEQUALS(V,X,Y) SUT_ASSERT_NOTEQUALS_STOP(V,X,Y)
#define SUT_ASSERT_ABOVE(V,X,Y) SUT_ASSERT_ABOVE_STOP(V,X,Y)
#define SUT_ASSERT_BELOW(V,X,Y) SUT_ASSERT_BELOW_STOP(V,X,Y)
#define SUT_ASSERT_EQAB(V,X,Y) SUT_ASSERT_EQAB_STOP(V,X,Y)
#define SUT_ASSERT_EQBL(V,X,Y) SUT_ASSERT_EQBL_STOP(V,X,Y)
#define SUT_ADDFUNC_ASSERT(F) SUT_ADDFUNC_ASSERT_STOP(F)
#else
#define SUT_ASSERT(B) scpl::sut::_test_bool(1,B,__FILE__,__LINE__,#B)
#define SUT_ASSERT_EQUALS(V,X,Y) scpl::sut::_test_eq_##V(1,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ASSERT_NOTEQUALS(V,X,Y) scpl::sut::_test_neq_##V(1,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ASSERT_ABOVE(V,X,Y) scpl::sut::_test_a_##V(1,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ASSERT_BELOW(V,X,Y) scpl::sut::_test_b_##V(1,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ASSERT_EQAB(V,X,Y) scpl::sut::_test_aeq_##V(1,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ASSERT_EQBL(V,X,Y) scpl::sut::_test_beq_##V(1,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ADDFUNC_ASSERT(F) scpl::sut::_test_addfunc(1,__FILE__,__LINE__,#F,F)
#endif

#define SUT_CHECK(B) scpl::sut::_test_bool(0,B,__FILE__,__LINE__,#B)
#define SUT_CHECK_EQUALS(V,X,Y) scpl::sut::_test_eq_##V(0,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_CHECK_NOTEQUALS(V,X,Y) scpl::sut::_test_neq_##V(0,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_CHECK_ABOVE(V,X,Y) scpl::sut::_test_a_##V(0,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_CHECK_BELOW(V,X,Y) scpl::sut::_test_b_##V(0,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_CHECK_EQAB(V,X,Y) scpl::sut::_test_aeq_##V(0,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_CHECK_EQBL(V,X,Y) scpl::sut::_test_beq_##V(0,__FILE__,__LINE__,#X,#Y,X,Y)
#define SUT_ADDFUNC_CHECK(F) scpl::sut::_test_addfunc(0,__FILE__,__LINE__,#F,F)

		bool _test_start();
		void _test_result();

		void _test_bool(int,bool,cstr,int,cstr);
		void _test_Int(int,bool,cstr,int,cstr,cstr,cstr,int,int);
		void _test_Hex(int,bool,cstr,int,cstr,cstr,cstr,int,int);
		void _test_I64(int,bool,cstr,int,cstr,cstr,cstr,i64,i64);
		void _test_H64(int,bool,cstr,int,cstr,cstr,cstr,i64,i64);
		void _test_Dbl(int,bool,cstr,int,cstr,cstr,cstr,double,double);
		void _test_Ptr(int,bool,cstr,int,cstr,cstr,cstr,cvptr,cvptr);

		inline void _test_eq_Int(int t,cstr f,int l,cstr xs,cstr ys,int x,int y){_test_Int(t,x == y,f,l,"==",xs,ys,x,y);}
		inline void _test_eq_Hex(int t,cstr f,int l,cstr xs,cstr ys,int x,int y){_test_Hex(t,x == y,f,l,"==",xs,ys,x,y);}
		inline void _test_eq_I64(int t,cstr f,int l,cstr xs,cstr ys,i64 x,i64 y){_test_I64(t,x == y,f,l,"==",xs,ys,x,y);}
		inline void _test_eq_H64(int t,cstr f,int l,cstr xs,cstr ys,i64 x,i64 y){_test_H64(t,x == y,f,l,"==",xs,ys,x,y);}
		inline void _test_eq_Dbl(int t,cstr f,int l,cstr xs,cstr ys,double x,double y){_test_Dbl(t,x == y,f,l,"==",xs,ys,x,y);}
		inline void _test_eq_Ptr(int t,cstr f,int l,cstr xs,cstr ys,cvptr x,cvptr y){_test_Ptr(t,x == y,f,l,"==",xs,ys,x,y);}

		inline void _test_neq_Int(int t,cstr f,int l,cstr xs,cstr ys,int x,int y){_test_Int(t,x != y,f,l,"!=",xs,ys,x,y);}
		inline void _test_neq_Hex(int t,cstr f,int l,cstr xs,cstr ys,int x,int y){_test_Hex(t,x != y,f,l,"!=",xs,ys,x,y);}
		inline void _test_neq_I64(int t,cstr f,int l,cstr xs,cstr ys,i64 x,i64 y){_test_I64(t,x != y,f,l,"!=",xs,ys,x,y);}
		inline void _test_neq_H64(int t,cstr f,int l,cstr xs,cstr ys,i64 x,i64 y){_test_H64(t,x != y,f,l,"!=",xs,ys,x,y);}
		inline void _test_neq_Dbl(int t,cstr f,int l,cstr xs,cstr ys,double x,double y){_test_Dbl(t,x != y,f,l,"!=",xs,ys,x,y);}
		inline void _test_neq_Ptr(int t,cstr f,int l,cstr xs,cstr ys,cvptr x,cvptr y){_test_Ptr(t,x != y,f,l,"!=",xs,ys,x,y);}

		inline void _test_a_Int(int t,cstr f,int l,cstr xs,cstr ys,int x,int y){_test_Int(t,x < y,f,l,"<",xs,ys,x,y);}
		inline void _test_a_Hex(int t,cstr f,int l,cstr xs,cstr ys,int x,int y){_test_Hex(t,x < y,f,l,"<",xs,ys,x,y);}
		inline void _test_a_I64(int t,cstr f,int l,cstr xs,cstr ys,i64 x,i64 y){_test_I64(t,x < y,f,l,"<",xs,ys,x,y);}
		inline void _test_a_H64(int t,cstr f,int l,cstr xs,cstr ys,i64 x,i64 y){_test_H64(t,x < y,f,l,"<",xs,ys,x,y);}
		inline void _test_a_Dbl(int t,cstr f,int l,cstr xs,cstr ys,double x,double y){_test_Dbl(t,x < y,f,l,"<",xs,ys,x,y);}
		inline void _test_a_Ptr(int t,cstr f,int l,cstr xs,cstr ys,cvptr x,cvptr y){_test_Ptr(t,x < y,f,l,"<",xs,ys,x,y);}

		inline void _test_b_Int(int t,cstr f,int l,cstr xs,cstr ys,int x,int y){_test_Int(t,x > y,f,l,">",xs,ys,x,y);}
		inline void _test_b_Hex(int t,cstr f,int l,cstr xs,cstr ys,int x,int y){_test_Hex(t,x > y,f,l,">",xs,ys,x,y);}
		inline void _test_b_I64(int t,cstr f,int l,cstr xs,cstr ys,i64 x,i64 y){_test_I64(t,x > y,f,l,">",xs,ys,x,y);}
		inline void _test_b_H64(int t,cstr f,int l,cstr xs,cstr ys,i64 x,i64 y){_test_H64(t,x > y,f,l,">",xs,ys,x,y);}
		inline void _test_b_Dbl(int t,cstr f,int l,cstr xs,cstr ys,double x,double y){_test_Dbl(t,x > y,f,l,">",xs,ys,x,y);}
		inline void _test_b_Ptr(int t,cstr f,int l,cstr xs,cstr ys,cvptr x,cvptr y){_test_Ptr(t,x > y,f,l,">",xs,ys,x,y);}

		inline void _test_aeq_Int(int t,cstr f,int l,cstr xs,cstr ys,int x,int y){_test_Int(t,x <= y,f,l,"<=",xs,ys,x,y);}
		inline void _test_aeq_Hex(int t,cstr f,int l,cstr xs,cstr ys,int x,int y){_test_Hex(t,x <= y,f,l,"<=",xs,ys,x,y);}
		inline void _test_aeq_I64(int t,cstr f,int l,cstr xs,cstr ys,i64 x,i64 y){_test_I64(t,x <= y,f,l,"<=",xs,ys,x,y);}
		inline void _test_aeq_H64(int t,cstr f,int l,cstr xs,cstr ys,i64 x,i64 y){_test_H64(t,x <= y,f,l,"<=",xs,ys,x,y);}
		inline void _test_aeq_Dbl(int t,cstr f,int l,cstr xs,cstr ys,double x,double y){_test_Dbl(t,x <= y,f,l,"<=",xs,ys,x,y);}
		inline void _test_aeq_Ptr(int t,cstr f,int l,cstr xs,cstr ys,cvptr x,cvptr y){_test_Ptr(t,x <= y,f,l,"<=",xs,ys,x,y);}

		inline void _test_beq_Int(int t,cstr f,int l,cstr xs,cstr ys,int x,int y){_test_Int(t,x >= y,f,l,">=",xs,ys,x,y);}
		inline void _test_beq_Hex(int t,cstr f,int l,cstr xs,cstr ys,int x,int y){_test_Hex(t,x >= y,f,l,">=",xs,ys,x,y);}
		inline void _test_beq_I64(int t,cstr f,int l,cstr xs,cstr ys,i64 x,i64 y){_test_I64(t,x >= y,f,l,">=",xs,ys,x,y);}
		inline void _test_beq_H64(int t,cstr f,int l,cstr xs,cstr ys,i64 x,i64 y){_test_H64(t,x >= y,f,l,">=",xs,ys,x,y);}
		inline void _test_beq_Dbl(int t,cstr f,int l,cstr xs,cstr ys,double x,double y){_test_Dbl(t,x >= y,f,l,">=",xs,ys,x,y);}
		inline void _test_beq_Ptr(int t,cstr f,int l,cstr xs,cstr ys,cvptr x,cvptr y){_test_Ptr(t,x >= y,f,l,">=",xs,ys,x,y);}


		void _test_addfunc(int,cstr,int,cstr,TestFunc);

		/**
			ZNV ASSERT ꂽꍇɔOB
		**/
		class sut_assert : public _XSTD exception{
		public:
			virtual __CLR_OR_THIS_CALL ~sut_assert()_THROW0(){}

			virtual const char *__CLR_OR_THIS_CALL what()const _THROW0(){return NULL;}

#if !_HAS_EXCEPTIONS
		protected:
			virtual void __CLR_OR_THIS_CALL _Doraise()const{_RAISE(*this);}
#endif /* _HAS_EXCEPTIONS */

		};
/**
	TuZNV֐Ăяo܂B
	̃}Ngp邱ƂɂA֐ł̃eXg ASSERT ñeXgsہA
	̊֐Ăяoꏊǉo͂܂B
	[arg]
	F	: Ăяo֐itj
**/
#define xflow(F) try{F;}catch(scpl::sut::sut_assert e){printf("(in line:%4i)\n",__LINE__);throw e;}

	} // namespace sut
} // namespace scpl
#endif