// 
// Event.cpp
// 
// Copylight(C) 2007 Ó

#include "stdafx.h"
#include "../scpl/Event.h"
#include "../scpl/auto_ptr.h"
#include "../scpl/exception.h"
#include <windows.h>

namespace scpl{

	Event* createEvent(ctstr eventName,bool state,bool manualReset){
		if(!eventName) return NULL;
		auto_ptr<Event> e(newcheck(new Event()));
		HANDLE h = CreateEvent(NULL,manualReset,state,eventName);
		if(!h) return NULL;
		e->_Handle = h;
		return e();
	}

	void Event::_hclose(HANDLE h){CloseHandle(h);}

	bool Event::setSignal(){return (SetEvent(_Handle)!=0);}
	bool Event::resetSignal(){return (ResetEvent(_Handle)!=0);}
	bool Event::checkSignal(DWORD time){return WaitForSingleObject(_Handle,time) == WAIT_OBJECT_0;}
	void Event::waitSignal(){WaitForSingleObject(_Handle,INFINITE);}

} // namespace scpl