// 
// Thread.cpp
// 
// Copylight(C) 2007 Mitsunagi

#include "Stdafx.h"
#include "../scpl/Thread.h"
#include "../scpl/auto_ptr.h"
#include "../scpl/exception.h"
#include <process.h>
#include <windows.h>

namespace scpl{

	static const ulong PRIORITY_CODE[6] = {
		IDLE_PRIORITY_CLASS,
		NORMAL_PRIORITY_CLASS,
		HIGH_PRIORITY_CLASS,
		REALTIME_PRIORITY_CLASS,
		BELOW_NORMAL_PRIORITY_CLASS,
		ABOVE_NORMAL_PRIORITY_CLASS
	};

	Thread* beginThread(void (__cdecl*func)(void*),vptr param,ulong stack){
		if(func == NULL) return NULL;
		auto_ptr<Thread> s(newcheck(new Thread()));
		HANDLE thread = (HANDLE)_beginthread(func,stack,param);
		if(thread <= (HANDLE)1) return NULL;
		s->set(thread,false);
		return s();
	}
	Thread* beginThreadEx(uint (__stdcall*func)(void*),vptr param,ulong stack){
		if(func == NULL) return NULL;
		auto_ptr<Thread> s(newcheck(new Thread()));
		HANDLE thread = (HANDLE)_beginthreadex(NULL,stack,func,param,0,NULL);
		if(thread == NULL) return NULL;
		s->set(thread);
		return s();
	}
	Thread* createThread(ulong (__stdcall*func)(void*),vptr param,ulong stack){
		if(func == NULL) return NULL;
		auto_ptr<Thread> s(newcheck(new Thread()));
		HANDLE thread = CreateThread(NULL,stack,func,param,0,NULL);
		if(thread == NULL) return NULL;
		s->set(thread);
		return s();
	}

	Thread::~Thread(){
		if(_MustClose&&_Thread) CloseHandle(_Thread);
	}
	int Thread::getExitCode(ulong* code){
		if(!_MustClose) return -1;
		ulong s;
		if(!code||!GetExitCodeThread(_Thread,&s)) return -1;
		if(s == STILL_ACTIVE) return 1;
		*code = s;
		return 0;
	}
	bool Thread::suspend(){
		long r = SuspendThread(_Thread);
		if(r < 0) return false;
		_SuspendCount = r;
		return true;
	}
	bool Thread::resume(){
		long r = ResumeThread(_Thread);
		if(r < 0) return false;
		_SuspendCount = r;
		return true;
	}
	bool Thread::isAlive()const{return WaitForSingleObject(_Thread,0) == WAIT_TIMEOUT;}
	bool Thread::getPriority(GETPRIORITY_TYPE* priority){
		if(!priority) return false;
		switch(GetThreadPriority(_Thread)){
			case THREAD_PRIORITY_IDLE:			*priority = GETPRI_IDLE;break;
			case THREAD_PRIORITY_LOWEST:		*priority = GETPRI_LOWEST;break;
			case THREAD_PRIORITY_BELOW_NORMAL:	*priority = GETPRI_BELOW_NORMAL;break;
			case THREAD_PRIORITY_NORMAL:		*priority = GETPRI_NORMAL;break;
			case THREAD_PRIORITY_ABOVE_NORMAL:	*priority = GETPRI_ABOVE_NORMAL;break;
			case THREAD_PRIORITY_HIGHEST:		*priority = GETPRI_HIGHEST;break;
			case THREAD_PRIORITY_TIME_CRITICAL:	*priority = GETPRI_REALTIME;break;
			default:return false;
		}
		return true;
	}
	bool Thread::setPriority(SETPRIORITY_TYPE priority){
		return SetPriorityClass(_Thread,PRIORITY_CODE[priority]) != FALSE;
	}
	void Thread::terminate(ulong code){
		if(_Thread&&isAlive()){
			TerminateThread(_Thread,code);
		}
	}
	void Thread::exitWait(){
		if(_Thread&&isAlive()){
			ulong r;
	loop:
			r = WaitForSingleObject(_Thread,0);
			if(r == WAIT_TIMEOUT){
				SwitchToThread();
				goto loop;
			}
		}
	}
	void Thread::exit(ulong code){ExitThread(code);}
	bool Thread::yield(){return SwitchToThread() != FALSE;}

} // namespace scpl