#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/CallBack.h>
#include <scpl/auto_ptr.h>

using namespace scpl;

static int	cnt = 0;

static void call0v(){cnt = 10;}
static void call1v(int i1){cnt = i1;}
static void call2v(int i1,int i2){cnt = i1 - i2;}
static void call3v(int i1,int i2,int i3){cnt = i1 - i2 * i3;}
static void call4v(int i1,int i2,int i3,int i4){cnt = i1 - i2 * i3 / i4;}
static void call5v(int i1,int i2,int i3,int i4,int i5){cnt = i1 - i2 * i3 / i4 * i5;}
static void call6v(int i1,int i2,int i3,int i4,int i5,int i6){cnt = i1 - i2 * i3 / i4 * (i5 - i6);}
static int call0r(){return 9;}
static int call1r(int i1){return i1;}
static int call2r(int i1,int i2){return i1 - i2;}
static int call3r(int i1,int i2,int i3){return i1 - i2 * i3;}
static int call4r(int i1,int i2,int i3,int i4){return i1 - i2 * i3 / i4;}
static int call5r(int i1,int i2,int i3,int i4,int i5){return i1 - i2 * i3 / i4 * i5;}
static int call6r(int i1,int i2,int i3,int i4,int i5,int i6){return i1 - i2 * i3 / i4 * (i5 - i6);}

class CallBackTest{
public:
	CallBackTest():ret(0){}

	void call0v(){ret = 8;}
	void call1v(int i1){ret = i1;}
	void call2v(int i1,int i2){ret = i1 + i2;}
	void call3v(int i1,int i2,int i3){ret = i1 + i2 - i3;}
	void call4v(int i1,int i2,int i3,int i4){ret = i1 + i2 - i3 * i4;}
	void call5v(int i1,int i2,int i3,int i4,int i5){ret = i1 + i2 - i3 * i4 / i5;}
	void call6v(int i1,int i2,int i3,int i4,int i5,int i6){ret = i1 + i2 - i3 * i4 / i5 - i6;}
	int call0r(){return 7;}
	int call1r(int i1){return i1;}
	int call2r(int i1,int i2){return i1 + i2;}
	int call3r(int i1,int i2,int i3){return i1 + i2 - i3;}
	int call4r(int i1,int i2,int i3,int i4){return i1 + i2 - i3 * i4;}
	int call5r(int i1,int i2,int i3,int i4,int i5){return i1 + i2 - i3 * i4 / i5;}
	int call6r(int i1,int i2,int i3,int i4,int i5,int i6){return i1 + i2 - i3 * i4 / i5 - i6;}
	
	int ret;
};


void test_CallBack(){
	auto_ptr<CallBackTest> bt(new CallBackTest());

	auto_ptr<CallBack0v> b0vg(createCallBack(call0v));
	auto_ptr<CallBack1v<int> > b1vg(createCallBack(call1v));
	auto_ptr<CallBack2v<int,int> > b2vg(createCallBack(call2v));
	auto_ptr<CallBack3v<int,int,int> > b3vg(createCallBack(call3v));
	auto_ptr<CallBack4v<int,int,int,int> > b4vg(createCallBack(call4v));
	auto_ptr<CallBack5v<int,int,int,int,int> > b5vg(createCallBack(call5v));
	auto_ptr<CallBack6v<int,int,int,int,int,int> > b6vg(createCallBack(call6v));

	auto_ptr<CallBack0r<int>> b0rg(createCallBack(call0r));
	auto_ptr<CallBack1r<int,int> > b1rg(createCallBack(call1r));
	auto_ptr<CallBack2r<int,int,int> > b2rg(createCallBack(call2r));
	auto_ptr<CallBack3r<int,int,int,int> > b3rg(createCallBack(call3r));
	auto_ptr<CallBack4r<int,int,int,int,int> > b4rg(createCallBack(call4r));
	auto_ptr<CallBack5r<int,int,int,int,int,int> > b5rg(createCallBack(call5r));
	auto_ptr<CallBack6r<int,int,int,int,int,int,int> > b6rg(createCallBack(call6r));

	auto_ptr<CallBack0v > b0vc(createCallBack(&CallBackTest::call0v,bt.get()));
	auto_ptr<CallBack1v<int> > b1vc(createCallBack(&CallBackTest::call1v,bt.get()));
	auto_ptr<CallBack2v<int,int> > b2vc(createCallBack(&CallBackTest::call2v,bt.get()));
	auto_ptr<CallBack3v<int,int,int> > b3vc(createCallBack(&CallBackTest::call3v,bt.get()));
	auto_ptr<CallBack4v<int,int,int,int> > b4vc(createCallBack(&CallBackTest::call4v,bt.get()));
	auto_ptr<CallBack5v<int,int,int,int,int> > b5vc(createCallBack(&CallBackTest::call5v,bt.get()));
	auto_ptr<CallBack6v<int,int,int,int,int,int> > b6vc(createCallBack(&CallBackTest::call6v,bt.get()));

	auto_ptr<CallBack0r<int> > b0rc(createCallBack(&CallBackTest::call0r,bt.get()));
	auto_ptr<CallBack1r<int,int> > b1rc(createCallBack(&CallBackTest::call1r,bt.get()));
	auto_ptr<CallBack2r<int,int,int> > b2rc(createCallBack(&CallBackTest::call2r,bt.get()));
	auto_ptr<CallBack3r<int,int,int,int> > b3rc(createCallBack(&CallBackTest::call3r,bt.get()));
	auto_ptr<CallBack4r<int,int,int,int,int> > b4rc(createCallBack(&CallBackTest::call4r,bt.get()));
	auto_ptr<CallBack5r<int,int,int,int,int,int> > b5rc(createCallBack(&CallBackTest::call5r,bt.get()));
	auto_ptr<CallBack6r<int,int,int,int,int,int,int> > b6rc(createCallBack(&CallBackTest::call6r,bt.get()));

	b0vg->call();SUT_ASSERT_EQUALS(Int,cnt,10);
	b1vg->call(20);SUT_ASSERT_EQUALS(Int,cnt,20);
	b2vg->call(10,9);SUT_ASSERT_EQUALS(Int,cnt,1);
	b3vg->call(2,2,9);SUT_ASSERT_EQUALS(Int,cnt,-16);
	b4vg->call(4,4,5,4);SUT_ASSERT_EQUALS(Int,cnt,-1);
	b5vg->call(6,3,1,3,3);SUT_ASSERT_EQUALS(Int,cnt,3);
	b6vg->call(1,3,5,3,4,4);SUT_ASSERT_EQUALS(Int,cnt,1);

	SUT_ASSERT_EQUALS(Int,b0rg->call(),9);
	SUT_ASSERT_EQUALS(Int,b1rg->call(20),20);
	SUT_ASSERT_EQUALS(Int,b2rg->call(10,9),1);
	SUT_ASSERT_EQUALS(Int,b3rg->call(2,2,9),-16);
	SUT_ASSERT_EQUALS(Int,b4rg->call(4,4,5,4),-1);
	SUT_ASSERT_EQUALS(Int,b5rg->call(6,3,1,3,3),3);
	SUT_ASSERT_EQUALS(Int,b6rg->call(1,3,5,3,4,4),1);

	b0vc->call();SUT_ASSERT_EQUALS(Int,bt->ret,8);
	b1vc->call(20);SUT_ASSERT_EQUALS(Int,bt->ret,20);
	b2vc->call(10,9);SUT_ASSERT_EQUALS(Int,bt->ret,19);
	b3vc->call(2,2,9);SUT_ASSERT_EQUALS(Int,bt->ret,-5);
	b4vc->call(4,4,5,4);SUT_ASSERT_EQUALS(Int,bt->ret,-12);
	b5vc->call(6,3,1,3,3);SUT_ASSERT_EQUALS(Int,bt->ret,8);
	b6vc->call(1,3,5,3,3,4);SUT_ASSERT_EQUALS(Int,bt->ret,-5);

	SUT_ASSERT_EQUALS(Int,b0rc->call(),7);
	SUT_ASSERT_EQUALS(Int,b1rc->call(20),20);
	SUT_ASSERT_EQUALS(Int,b2rc->call(10,9),19);
	SUT_ASSERT_EQUALS(Int,b3rc->call(2,2,9),-5);
	SUT_ASSERT_EQUALS(Int,b4rc->call(4,4,5,4),-12);
	SUT_ASSERT_EQUALS(Int,b5rc->call(6,3,1,3,3),8);
	SUT_ASSERT_EQUALS(Int,b6rc->call(1,3,5,3,3,4),-5);

}
