#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/EventList.h>
#include <scpl/auto_ptr.h>

using namespace scpl;

static int cnt = 0;

void call0(){cnt += 10;}
void call1(int i1){cnt += i1;}
void call2(int i1,int i2){cnt += i1 + i2;}
void call3(int i1,int i2,int i3){cnt += i1 + i2 - i3;}
void call4(int i1,int i2,int i3,int i4){cnt += i1 + i2 - i3 + i4;}
void call5(int i1,int i2,int i3,int i4,int i5){cnt += i1 + i2 - i3 + i4 - i5;}
void call6(int i1,int i2,int i3,int i4,int i5,int i6){cnt += i1 + i2 - i3 + i4 - i5 + i6;}

void callx1(int i1){cnt *= i1;}

class EventListTest{
public:

	void call0(){cnt += 8;}
	void call1(int i1){cnt += i1;}
	void call2(int i1,int i2){cnt += i1 - i2;}
	void call3(int i1,int i2,int i3){cnt += i1 - i2 + i3;}
	void call4(int i1,int i2,int i3,int i4){cnt += i1 - i2 + i3 - i4;}
	void call5(int i1,int i2,int i3,int i4,int i5){cnt += i1 - i2 + i3 - i4 + i5;}
	void call6(int i1,int i2,int i3,int i4,int i5,int i6){cnt += i1 - i2 + i3 - i4 + i5 - i6;}

	void callx1(int i1){cnt += i1 * 10;}
	
};

void test_EventList(){
	EventList0 ev0;
	EventList1<int> ev1;
	EventList2<int,int> ev2;
	EventList3<int,int,int> ev3;
	EventList4<int,int,int,int> ev4;
	EventList5<int,int,int,int,int> ev5;
	EventList6<int,int,int,int,int,int> ev6;
	EventListTest elt;

	ev0.add(call0);
	ev1.add(call1);
	ev2.add(call2);
	ev3.add(call3);
	ev4.add(call4);
	ev5.add(call5);
	ev6.add(call6);

	ev0();SUT_ASSERT_EQUALS(Int,cnt,10);
	ev1(1);SUT_ASSERT_EQUALS(Int,cnt,11);
	ev2(1,2);SUT_ASSERT_EQUALS(Int,cnt,14);
	ev3(1,2,3);SUT_ASSERT_EQUALS(Int,cnt,14);
	ev4(1,2,3,4);SUT_ASSERT_EQUALS(Int,cnt,18);
	ev5(1,2,3,4,5);SUT_ASSERT_EQUALS(Int,cnt,17);
	ev6(1,2,3,4,5,6);SUT_ASSERT_EQUALS(Int,cnt,22);

	ev0.add(&EventListTest::call0,&elt);
	ev1.add(&EventListTest::call1,&elt);
	ev2.add(&EventListTest::call2,&elt);
	ev3.add(&EventListTest::call3,&elt);
	ev4.add(&EventListTest::call4,&elt);
	ev5.add(&EventListTest::call5,&elt);
	ev6.add(&EventListTest::call6,&elt);

	ev0();SUT_ASSERT_EQUALS(Int,cnt,40);
	ev1(1);SUT_ASSERT_EQUALS(Int,cnt,42);
	ev2(1,2);SUT_ASSERT_EQUALS(Int,cnt,44);
	ev3(1,2,3);SUT_ASSERT_EQUALS(Int,cnt,46);
	ev4(1,2,3,4);SUT_ASSERT_EQUALS(Int,cnt,48);
	ev5(1,2,3,4,5);SUT_ASSERT_EQUALS(Int,cnt,50);
	ev6(1,2,3,4,5,6);SUT_ASSERT_EQUALS(Int,cnt,52);

	ev1.clear();

	ev1.add(callx1);
	ev1.add(&EventListTest::callx1,&elt);

	cnt = 0;

	ev1(1);SUT_ASSERT_EQUALS(Int,cnt,10);
	ev1(2);SUT_ASSERT_EQUALS(Int,cnt,40);
	ev1(3);SUT_ASSERT_EQUALS(Int,cnt,150);
	ev1(2);SUT_ASSERT_EQUALS(Int,cnt,320);

	SUT_ASSERT(ev1.remove(&EventListTest::callx1,&elt));
	ev1.addFront(&EventListTest::callx1,&elt);
	cnt = 0;

	ev1(1);SUT_ASSERT_EQUALS(Int,cnt,10);
	ev1(2);SUT_ASSERT_EQUALS(Int,cnt,60);
	ev1(3);SUT_ASSERT_EQUALS(Int,cnt,270);
	ev1(2);SUT_ASSERT_EQUALS(Int,cnt,580);

	auto_ptr<CallBack1v<int> > acb(createCallBack(&EventListTest::callx1,&elt));

	SUT_ASSERT(ev1.removeCB(~acb));
	SUT_ASSERT(ev1.remove(callx1));
	SUT_ASSERT(ev1.empty());
}