#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/Function.h>

using namespace scpl;

void test_Function(){
	long a=0,b=100,c=-1,d=-1;

	FuncEqual<long>			equal;
	FuncNoEqual<long>		noequal;
	FuncAbove<long>			above;
	FuncBelow<long>			below;
	FuncEqualAbove<long>	eabove;
	FuncEqualBelow<long>	ebelow;

	SUT_ASSERT(!equal(a,b));
	SUT_ASSERT( equal(c,d));
	SUT_ASSERT(!equal(a,c));
	SUT_ASSERT(!equal(b,d));
	SUT_ASSERT( noequal(a,b));
	SUT_ASSERT(!noequal(c,d));
	SUT_ASSERT( noequal(a,c));
	SUT_ASSERT( noequal(b,d));
	SUT_ASSERT( above(a,b));
	SUT_ASSERT(!above(c,d));
	SUT_ASSERT(!above(a,c));
	SUT_ASSERT(!above(b,d));
	SUT_ASSERT(!below(a,b));
	SUT_ASSERT(!below(c,d));
	SUT_ASSERT( below(a,c));
	SUT_ASSERT( below(b,d));
	SUT_ASSERT( eabove(a,b));
	SUT_ASSERT( eabove(c,d));
	SUT_ASSERT(!eabove(a,c));
	SUT_ASSERT(!eabove(b,d));
	SUT_ASSERT(!ebelow(a,b));
	SUT_ASSERT( ebelow(c,d));
	SUT_ASSERT( ebelow(a,c));
	SUT_ASSERT( ebelow(b,d));

	FuncConstEqual<long>		cequal(100);
	FuncConstNoEqual<long>		cnoequal(100);
	FuncConstAbove<long>		cabove(100);
	FuncConstBelow<long>		cbelow(100);
	FuncConstEqualAbove<long>	ceabove(100);
	FuncConstEqualBelow<long>	cebelow(100);

	SUT_ASSERT(!cequal(a));
	SUT_ASSERT( cequal(b));
	SUT_ASSERT(!cequal(c));
	SUT_ASSERT(!cequal(d));
	SUT_ASSERT( cnoequal(a));
	SUT_ASSERT(!cnoequal(b));
	SUT_ASSERT( cnoequal(c));
	SUT_ASSERT( cnoequal(d));
	SUT_ASSERT( cabove(a));
	SUT_ASSERT(!cabove(b));
	SUT_ASSERT( cabove(c));
	SUT_ASSERT( cabove(d));
	SUT_ASSERT(!cbelow(a));
	SUT_ASSERT(!cbelow(b));
	SUT_ASSERT(!cbelow(c));
	SUT_ASSERT(!cbelow(d));
	SUT_ASSERT( ceabove(a));
	SUT_ASSERT( ceabove(b));
	SUT_ASSERT( ceabove(c));
	SUT_ASSERT( ceabove(d));
	SUT_ASSERT(!cebelow(a));
	SUT_ASSERT( cebelow(b));
	SUT_ASSERT(!cebelow(c));
	SUT_ASSERT(!cebelow(d));
}