#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/WString.h>

using namespace scpl;

void sizecheck(const WString& ws,ulong cnt,ulong cap){
	SUT_ASSERT_EQUALS(Int,ws.count(),cnt);
	SUT_ASSERT_EQUALS(Int,ws.capacity(),cap);
}

void check(const WString& ws,ulong cnt,ulong cap){
	sizecheck(ws,cnt,cap);
	if(!cnt){
		SUT_ASSERT(ws.empty());
		SUT_CHECK(!ws);
		SUT_ASSERT_EQUALS(Ptr,(cwstr)ws,NULL);
		SUT_ASSERT_EQUALS(Ptr,ws.begin(),NULL);
		SUT_ASSERT_EQUALS(Ptr,ws.end(),NULL);
		SUT_ASSERT_EQUALS(Ptr,ws.rbegin(),NULL);
		SUT_ASSERT_EQUALS(Ptr,ws.rend(),NULL);
	}
	else{
		SUT_ASSERT(!ws.empty());
		SUT_CHECK(ws != NULL);
		SUT_ASSERT_EQUALS(Ptr,(cwstr)ws,ws.get());
		SUT_ASSERT_EQUALS(Ptr,ws.begin(),ws.get());
		SUT_ASSERT_EQUALS(Ptr,ws.end(),ws.get()+ws.count());
		SUT_ASSERT_EQUALS(Ptr,ws.rbegin(),ws.get()+ws.count()-1);
		SUT_ASSERT_EQUALS(Ptr,ws.rend(),ws.get()-1);
	}
}

void strcheck(const WString& ws,cwstr text,ulong cnt,ulong cap){
//	printf("ws(%S) txt(%S)\n",ws.get(),text);
	sizecheck(ws,cnt,cap);
	SUT_ASSERT(ws.equals(text));
}

#define flow_(F) try{F;}catch(scpl::sut::sut_assert s){printf("(In Line:%5i)\n",__LINE__);throw s;}

void tw_1(){
	WString ws;
	WString as2(100);

	
	flow_(check(ws,0,0));
	SUT_ASSERT(ws.equals(as2));
	ws.adjust(0);
	flow_(check(ws,0,1));
	SUT_ASSERT(ws.equals(as2));

	ws.lastInStr(L"test text.");
	flow_(check(ws,10,11));
	SUT_ASSERT(!ws.equals(as2));

	SUT_ASSERT_EQUALS(Hex,ws.at(0),L't');
	SUT_ASSERT_EQUALS(Hex,ws.at(4),L' ');
	SUT_ASSERT_EQUALS(Hex,ws.at(10),L'\0');
	SUT_ASSERT_EQUALS(Hex,ws.atFirst(),L't');
	SUT_ASSERT_EQUALS(Hex,ws.atLast(),L'.');

	as2.copy(ws);
	flow_(check(as2,10,100));
	SUT_ASSERT(as2.equals(ws));
	SUT_ASSERT_EQUALS(Hex,as2.at(0),L't');
	SUT_ASSERT_EQUALS(Hex,as2.at(4),L' ');
	SUT_ASSERT_EQUALS(Hex,as2.at(10),L'\0');
	SUT_ASSERT_EQUALS(Hex,as2.atFirst(),L't');
	SUT_ASSERT_EQUALS(Hex,as2.atLast(),L'.');

	ws.toUpper();
	flow_(strcheck(ws,L"TEST TEXT.",10,11));
	ws.toLower();
	flow_(strcheck(ws,L"test text.",10,11));

	ws.firstInNum(-10);
	flow_(strcheck(ws,L"-10test text.",13,14));
	ws.firstOut();
	flow_(strcheck(ws,L"10test text.",12,14));
	ws.firstOut(2);
	flow_(strcheck(ws,L"test text.",10,14));
	ws.lastOut();
	flow_(strcheck(ws,L"test text",9,14));
	ws.lastInChar(L'!');
	flow_(strcheck(ws,L"test text!",10,14));
	ws.lastInStr(L" no ");
	flow_(strcheck(ws,L"test text! no ",14,15));
	ws.lastIn(as2);
	flow_(strcheck(ws,L"test text! no test text.",24,25));
	ws.lastOut(14);
	flow_(strcheck(ws,L"test text!",10,25));
	ws.adjust(0);
	flow_(strcheck(ws,L"test text!",10,11));
	ws.firstIn(as2);
	flow_(strcheck(ws,L"test text.test text!",20,21));
	ws.lastInUNum(0xff00ff00L,16);
	flow_(strcheck(ws,L"test text.test text!ff00ff00",28,29));
	ws.removeAt(9);
	flow_(strcheck(ws,L"test texttest text!ff00ff00",27,29));
	ws.erage(0,9);
	flow_(strcheck(ws,L"test text!ff00ff00",18,29));
	
	SUT_ASSERT_EQUALS(Int,ws.find(L'f'),10);
	SUT_ASSERT_EQUALS(Int,ws.find(L'f',11),11);
	SUT_ASSERT_EQUALS(Int,ws.find(L'l'),-1);
	ws.copy(as2);
	flow_(strcheck(ws,as2,10,29));
	ws.adjust(10);
	flow_(strcheck(ws,L"test text.",10,21));
	ws.insertChar(L',',4);
	flow_(strcheck(ws,L"test, text.",11,21));
	ws.insertStr(L" string ",-1,4);
	flow_(strcheck(ws,L"test string , text.",19,21));
	ws.erage(4,13);
	flow_(strcheck(ws,L"test text.",10,21));
	ws.insert(as2,2);
	flow_(strcheck(ws,L"tetest text.st text.",20,21));
}

void tw_2(){
	WString ws(L"test text.");
	WString as2 = WString::strcat(ws,L"it is ok?");

	flow_(check(ws,10,11));
	SUT_ASSERT(ws != as2);
	flow_(check(as2,19,20));
	SUT_ASSERT(as2 != ws);

	ws = 100;
	as2 = -8899;
	flow_(strcheck(ws,L"100",3,11));
	flow_(strcheck(as2,L"-8899",5,20));
	ws += 2100;
	as2 += 1899;
	flow_(strcheck(ws,L"1002100",7,11));
	flow_(strcheck(as2,L"-88991899",9,20));
	ws += L"byte";
	as2 += L"m";
	flow_(strcheck(ws,L"1002100byte",11,12));
	flow_(strcheck(as2,L"-88991899m",10,20));
	ws = L"SUT_ASSERT";
	as2 = L"SUT_ASSERT_EQUALS";
	flow_(strcheck(ws,L"SUT_ASSERT",10,12));
	flow_(strcheck(as2,L"SUT_ASSERT_EQUALS",17,20));
	as2 = ws + L"(true);";
	flow_(strcheck(as2,L"SUT_ASSERT(true);",17,18));
	ws += L" == " + as2 +  L" == " + as2 + ws;
	flow_(strcheck(ws,L"SUT_ASSERT == SUT_ASSERT(true); == SUT_ASSERT(true);SUT_ASSERT",62,63));
	const WString* asc = &ws;

	SUT_ASSERT_EQUALS(Hex,asc->atFirst(),L'S');
	SUT_ASSERT_EQUALS(Hex,asc->atLast(),L'T');
	SUT_ASSERT_EQUALS(Int,asc->find(L" == "),10);
	flow_(check(*asc,62,63));
	SUT_ASSERT(*asc == ws);
	SUT_ASSERT(*asc != as2);
	ws.swap(as2);
	flow_(sizecheck(*asc,17,18));
}

void test_WString(){
	tw_1();
	tw_2();
}