#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/auto_ptr.h>
#include "CountStruct.h"

using namespace scpl;

typedef auto_ptr<CountStruct> CSAP;

void tap_1(){
	CSAP a(new CountStruct());
	CSAP b(new CountStruct());
	CSAP c(new CountStruct());
	CSAP d;

	SUT_ASSERT(!a.empty());
	SUT_ASSERT(!b.empty());
	SUT_ASSERT(!c.empty());
	SUT_ASSERT( d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),3);
	d = a;
	SUT_ASSERT(!d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),3);
	d = a;
	SUT_ASSERT(!d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),3);
	b = c;
	SUT_ASSERT(!b.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),2);
	SUT_ASSERT(d == a);
	SUT_ASSERT(b == c);
	SUT_ASSERT(a != c);
	d = NULL;
	SUT_ASSERT(d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),2);
	SUT_ASSERT(d != a);
	b = NULL;
	SUT_ASSERT(b.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),2);
	SUT_ASSERT(b != c);
	SUT_ASSERT(b == d);
	const CSAP* s = &a;
	CountStruct* cs = ~a;
	SUT_ASSERT_EQUALS(Int,a->i,cs->i);
	const CSAP& x = c;
	SUT_ASSERT_EQUALS(Int,c->i,x->i);
}

void test_auto_ptr(){
	tap_1();
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);
}