#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/color.h>

using namespace scpl;
using namespace scpl::color;

void test_color(){
	const ulong black	= 0xff000000L;
	const ulong white	= 0xffffffffL;
	const ulong red		= 0xffff0000L;
	const ulong green	= 0xff00ff00L;
	const ulong blue	= 0xff0000ffL;
	const ulong black2	= 0x88000000L;
	const ulong white2	= 0x88ffffffL;
	const ulong red2	= 0x88ff0000L;
	const ulong green2	= 0x8800ff00L;
	const ulong blue2	= 0x880000ffL;
	
	SUT_ASSERT_EQUALS(Hex,toARGB(0xff,0x00,0xff,0xff)	,0xff00ffffL);
	SUT_ASSERT_EQUALS(Hex,toRGB(0xff,0x00,0xff)			,0xffff00ffL);

	SUT_ASSERT_EQUALS(Hex,centerARGB(black,white),	0xff7f7f7fL);
	SUT_ASSERT_EQUALS(Hex,centerARGB(red,green),	0xff7f7f00L);
	SUT_ASSERT_EQUALS(Hex,centerARGB(white2,blue2),	0x887f7fffL);

	SUT_ASSERT_EQUALS(Hex,centerRGB(black,white),		0xff7f7f7fL);
	SUT_ASSERT_EQUALS(Hex,centerRGB(red,green,0x80),	0x807f7f00L);
	SUT_ASSERT_EQUALS(Hex,centerRGB(white2,blue2,0x08),	0x087f7fffL);

	SUT_ASSERT_EQUALS(Hex,reverseARGB(blue)		,0x00ffff00L);
	SUT_ASSERT_EQUALS(Hex,reverseARGB(red2)		,0x7700ffffL);
	SUT_ASSERT_EQUALS(Hex,reverseARGB(green2)	,0x77ff00ffL);

	SUT_ASSERT_EQUALS(Hex,reverseRGB(white2),0x88000000L);
	SUT_ASSERT_EQUALS(Hex,reverseRGB(black2),0x88ffffffL);
	SUT_ASSERT_EQUALS(Hex,reverseRGB(red)	,0xff00ffffL);
}