#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/flag.h>

using namespace scpl;

static const ushort src16 = 0x9dfa;
static const ulong src32 = 0x274dcbdaL;
static const ui64 src64 = 0x1234543234565432LL;

inline void tf_make(){
	SUT_ASSERT_EQUALS(Hex,lmake2(0x1842,0x96df),0x184296dfL);
	SUT_ASSERT_EQUALS(Hex,lmake4(0x13,0xdc,0x54,0xaa),0x13dc54aaL);
	SUT_ASSERT_EQUALS(Hex,smake2(0x5f,0x3d),0x5f3d);
	SUT_ASSERT_EQUALS(H64,i64make2(0x9b42da2cL,0x9d3a2bc9L),0x9b42da2c9d3a2bc9LL);
	SUT_ASSERT_EQUALS(H64,i64make4(0x57d4,0xca53,0x57d4,0xca52),0x57d4ca5357d4ca52LL);
	SUT_ASSERT_EQUALS(H64,i64make8(0x6b,0xbd,0xd2,0xd1,0xab,0xc5,0xf0,0xe4),0x6bbdd2d1abc5f0e4LL);
}
inline void tf_split(){
	byte ba,bb,bc,bd,be,bf,bg,bh;
	ushort sa,sb,sc,sd;
	ulong la,lb;

	lsplit2(0x98463091L,sa,sb);
	lsplit4(0xabefcdafL,ba,bb,bc,bd);
	SUT_ASSERT_EQUALS(Hex,sa,0x9846);
	SUT_ASSERT_EQUALS(Hex,sb,0x3091);
	SUT_ASSERT_EQUALS(Hex,ba,0xab);
	SUT_ASSERT_EQUALS(Hex,bb,0xef);
	SUT_ASSERT_EQUALS(Hex,bc,0xcd);
	SUT_ASSERT_EQUALS(Hex,bd,0xaf);

	ssplit2(0x9d3c,ba,bb);
	SUT_ASSERT_EQUALS(Hex,ba,0x9d);
	SUT_ASSERT_EQUALS(Hex,bb,0x3c);

	i64split2(0x9a03b000e3a6a2b1LL,la,lb);
	i64split4(0x8b3c6fd16470c01bLL,sa,sb,sc,sd);
	i64split8(0x02bc0037da001000LL,ba,bb,bc,bd,be,bf,bg,bh);
	SUT_ASSERT_EQUALS(Hex,la,0x9a03b000L);
	SUT_ASSERT_EQUALS(Hex,lb,0xe3a6a2b1L);
	SUT_ASSERT_EQUALS(Hex,sa,0x8b3c);
	SUT_ASSERT_EQUALS(Hex,sb,0x6fd1);
	SUT_ASSERT_EQUALS(Hex,sc,0x6470);
	SUT_ASSERT_EQUALS(Hex,sd,0xc01b);
	SUT_ASSERT_EQUALS(Hex,ba,0x02);
	SUT_ASSERT_EQUALS(Hex,bb,0xbc);
	SUT_ASSERT_EQUALS(Hex,bc,0x00);
	SUT_ASSERT_EQUALS(Hex,bd,0x37);
	SUT_ASSERT_EQUALS(Hex,be,0xda);
	SUT_ASSERT_EQUALS(Hex,bf,0x00);
	SUT_ASSERT_EQUALS(Hex,bg,0x10);
	SUT_ASSERT_EQUALS(Hex,bh,0x00);
}
inline void tf_get(){
	SUT_ASSERT_EQUALS(Hex,lget2_up(src32),0x274d);
	SUT_ASSERT_EQUALS(Hex,lget2_un(src32),0xcbda);
	SUT_ASSERT_EQUALS(Hex,lget4_24(src32),0x27);
	SUT_ASSERT_EQUALS(Hex,lget4_16(src32),0x4d);
	SUT_ASSERT_EQUALS(Hex,lget4_8(src32),0xcb);
	SUT_ASSERT_EQUALS(Hex,lget4_0(src32),0xda);
	SUT_ASSERT_EQUALS(Hex,sget2_up(src16),0x9d);
	SUT_ASSERT_EQUALS(Hex,sget2_un(src16),0xfa);
	SUT_ASSERT_EQUALS(H64,i64get2_up(src64),0x12345432L);
	SUT_ASSERT_EQUALS(H64,i64get2_un(src64),0x34565432L);
	SUT_ASSERT_EQUALS(H64,i64get4_48(src64),0x1234);
	SUT_ASSERT_EQUALS(H64,i64get4_32(src64),0x5432);
	SUT_ASSERT_EQUALS(H64,i64get4_16(src64),0x3456);
	SUT_ASSERT_EQUALS(H64,i64get4_0(src64),0x5432);
	SUT_ASSERT_EQUALS(H64,i64get8_56(src64),0x12);
	SUT_ASSERT_EQUALS(H64,i64get8_48(src64),0x34);
	SUT_ASSERT_EQUALS(H64,i64get8_40(src64),0x54);
	SUT_ASSERT_EQUALS(H64,i64get8_32(src64),0x32);
	SUT_ASSERT_EQUALS(H64,i64get8_24(src64),0x34);
	SUT_ASSERT_EQUALS(H64,i64get8_16(src64),0x56);
	SUT_ASSERT_EQUALS(H64,i64get8_8(src64),0x54);
	SUT_ASSERT_EQUALS(H64,i64get8_0(src64),0x32);
}
inline void tf_flag(){
	byte	b1 = 0x00,b2 = 0xf0,b3 = 0xff;
	ushort	s1 = 0x0000,s2 = 0x9fbd,s3 = 0xffff;
	ulong	l1 = 0x00000000L,l2 = 0x9bd24ac7L,l3 = 0xffffffffL;
	ui64	i1 = 0x0000000000000000LL,i2 = 0x984Bc26d39db48dfLL,i3 = 0xffffffffffffffffLL;

	SUT_ASSERT(!isFragOnBit(b1,0));
	SUT_ASSERT(!isFragOnBit(b2,0));
	SUT_ASSERT( isFragOnBit(b3,0));
	SUT_ASSERT(!isFragOnBit(s1,4));
	SUT_ASSERT( isFragOnBit(s2,4));
	SUT_ASSERT( isFragOnBit(s3,4));
	SUT_ASSERT(!isFragOnBit(l1,27));
	SUT_ASSERT( isFragOnBit(l2,27));
	SUT_ASSERT( isFragOnBit(l3,27));
	SUT_ASSERT(!isFragOnBit(i1,32));
	SUT_ASSERT( isFragOnBit(i2,32));
	SUT_ASSERT( isFragOnBit(i3,32));
	SUT_ASSERT(!isFragOnAll(b1,b2));
	SUT_ASSERT( isFragOnAll(b2,b2));
	SUT_ASSERT( isFragOnAll(b3,b2));
	SUT_ASSERT(!isFragOnAll(s1,s2));
	SUT_ASSERT( isFragOnAll(s2,s2));
	SUT_ASSERT( isFragOnAll(s3,s2));
	SUT_ASSERT(!isFragOnAll(l1,l2));
	SUT_ASSERT( isFragOnAll(l2,l2));
	SUT_ASSERT( isFragOnAll(l3,l2));
	SUT_ASSERT(!isFragOnAll(i1,i2));
	SUT_ASSERT( isFragOnAll(i2,i2));
	SUT_ASSERT( isFragOnAll(i3,i2));
	SUT_ASSERT(!isFragOnOr(b1,b2));
	SUT_ASSERT( isFragOnOr(b2,b2));
	SUT_ASSERT( isFragOnOr(b3,b2));
	SUT_ASSERT(!isFragOnOr(s1,s2));
	SUT_ASSERT( isFragOnOr(s2,s2));
	SUT_ASSERT( isFragOnOr(s3,s2));
	SUT_ASSERT(!isFragOnOr(l1,l2));
	SUT_ASSERT( isFragOnOr(l2,l2));
	SUT_ASSERT( isFragOnOr(l3,l2));
	SUT_ASSERT(!isFragOnOr(i1,i2));
	SUT_ASSERT( isFragOnOr(i2,i2));
	SUT_ASSERT( isFragOnOr(i3,i2));

	SUT_ASSERT_EQUALS(Hex,flagRev(b2),0x0f);
	SUT_ASSERT_EQUALS(Hex,flagRev(s2),0x6042);
	SUT_ASSERT_EQUALS(Hex,flagRev(l2),0x642db538L);
	SUT_ASSERT_EQUALS(H64,flagRev(i2),0x67b43d92c624b720LL);
	SUT_ASSERT_EQUALS(Hex,flagRev(b3,b2),0x0f);
	SUT_ASSERT_EQUALS(Hex,flagRev(s3,s2),0x6042);
	SUT_ASSERT_EQUALS(Hex,flagRev(l3,l2),0x642db538L);
	SUT_ASSERT_EQUALS(H64,flagRev(i3,i2),0x67b43d92c624b720LL);
}

void test_flag(){
	tf_make();
	tf_split();
	tf_get();
	tf_flag();
}