#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/smart_ary.h>
#include "CountStruct.h"

using namespace scpl;

typedef smart_ary<CountStruct> CSAP;

void tsa_1(){
	CSAP a(new CountStruct[10]);
	CSAP b(new CountStruct[10]);
	CSAP c(new CountStruct[10]);
	CSAP d;

	SUT_ASSERT(!a.empty());
	SUT_ASSERT(!b.empty());
	SUT_ASSERT(!c.empty());
	SUT_ASSERT( d.empty());
	SUT_ASSERT_EQUALS(Int,a.count(),1);
	SUT_ASSERT_EQUALS(Int,b.count(),1);
	SUT_ASSERT_EQUALS(Int,c.count(),1);
	SUT_ASSERT_EQUALS(Int,d.count(),0);
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),30);
	d = a;
	SUT_ASSERT(!d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),30);
	d = a;
	SUT_ASSERT(!d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),30);
	b = c;
	SUT_ASSERT(!b.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),20);
	SUT_ASSERT(d == a);
	SUT_ASSERT(b == c);
	SUT_ASSERT(a != c);
	d = NULL;
	SUT_ASSERT(d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),20);
	SUT_ASSERT(d != a);
	b = NULL;
	SUT_ASSERT(b.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),20);
	SUT_ASSERT(b != c);
	SUT_ASSERT(b == d);
}

void tsa_2(){
	CSAP a(new CountStruct[10]);
	CSAP b(a);
	CSAP c(new CountStruct[10]);
	CSAP d(c);
	SUT_ASSERT_EQUALS(Int,a.count(),2);
	SUT_ASSERT_EQUALS(Int,c.count(),2);
	d = a;
	SUT_ASSERT_EQUALS(Int,a.count(),3);
	SUT_ASSERT_EQUALS(Int,c.count(),1);
	d.swap(c);
	SUT_ASSERT_EQUALS(Int,a.count(),3);
	SUT_ASSERT_EQUALS(Int,b.count(),3);
	SUT_ASSERT_EQUALS(Int,c.count(),3);
	SUT_ASSERT_EQUALS(Int,d.count(),1);
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),20);
	d = a;
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),10);
	SUT_ASSERT_EQUALS(Int,c.count(),4);
	a = b = new CountStruct[40];
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),50);
	SUT_ASSERT_EQUALS(Int,c.count(),2);
	SUT_ASSERT_EQUALS(Int,a.count(),2);
	a.clear();
	SUT_ASSERT_EQUALS(Int,a.count(),0);
	SUT_ASSERT_EQUALS(Int,b.count(),1);
	CountStruct* cs = new CountStruct[20];
	b = cs;
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),30);
	SUT_ASSERT_EQUALS(Int,b.count(),1);
	const CSAP* s = &a;
	SUT_ASSERT_EQUALS(Int,s->count(),0);
	SUT_ASSERT(s->empty());
	SUT_ASSERT_EQUALS(Ptr,s->get(),NULL);
	s = &b;
	SUT_ASSERT_EQUALS(Int,s->count(),1);
	SUT_ASSERT(!s->empty());
	SUT_ASSERT_EQUALS(Ptr,s->get(),cs);
	SUT_ASSERT_EQUALS(Int,(*s).at(9).i,cs[9].i);
	SUT_ASSERT_EQUALS(Int,(*s)[0].i,cs->i);
}

void test_smart_ary(){
	tsa_1();
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);
	tsa_2();
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);
}