// 
// EventList.h
// 
// Copyright(C) 2007 Ó
#ifndef _EventList_INC_
#define _EventList_INC_
#include <string.h>
#include "CallBack.h"
#include "List.h"
#include "exception.h"

namespace scpl{

	/**
		Cxg@\NXłB
		NX̌̐ň֐̈̐܂܂i 0 ` 6 jB
		Cxg𔭐ɂ́A֐IuWFNgĂяo܂B
		֐o^ɂ add ֐gp܂B
		o^֐́ACxgɓo^ŌĂяo܂B
		[note]
		̃NX͊ꒊۃNXłB
		ۂɎgpꍇ́ÃNX̌ɔԍ̕tNX
		gpĂB
	**/
	class EventList{
		typedef CallBack*				cbptr;
		typedef const CallBack*			ccbptr;
		typedef scpl::CList<CallBack*>	CBList;
	protected:
		bool _remove(cvptr f,cvptr c){
			cbptr *it = _List.begin(),*end = _List.end();
			for(;it<end;++it){
				if((*it)->equal(f,c)){
					_List.erage(it);
					return true;
				}
			}
			return false;
		}

		EventList(ulong c=0):_List(c){}

	public:
		virtual ~EventList(){clear();}

		/**
			XgɈło^Ă邩Ԃ܂B
			[return]
			XgɈło^Ă true AłȂꍇ false Ԃ܂B
		**/
		operator bool()const{return !_List.empty();}
		/**
			XgɈo^ĂȂԂ܂B
			[return]
			XgɈo^ĂȂ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!()const{return _List.empty();}
		/**
			XgɈo^ĂȂԂ܂B
			[return]
			XgɈo^ĂȂ true AłȂꍇ false Ԃ܂B
		**/
		bool empty()const{return _List.empty();}

		/**
			R[obN֐Xgɒǉ܂B
			[arg]
			callBack	: ǉR[obN֐B
			[exc]
			std::bad_alloc	: Xgɒǉ邽߂̗̈mۂł܂łB
		**/
		void addCB(cbptr callBack){_List.lastIn(callBack);}
		/**
			R[obN֐Xgɒǉ܂B
			łɒǉĂ֐ɌĂ΂悤ɂȂ܂B
			callBack	: ǉR[obN֐B
			[exc]
			std::bad_alloc	: Xgɒǉ邽߂̗̈mۂł܂łB
		**/
		void addCBFront(cbptr callBack){_List.firstIn(callBack);}

		/**
			Xg֐폜܂B
			[arg]
			callBack	: 폜R[obN֐B
			[note]
			֐o^ĂꍇA
			ԑĂ΂֐Xg폜܂B
		**/
		bool removeCB(ccbptr callBack){return _remove(callBack->getFunc(),callBack->getClass());}

		/**
			o^ĂCxgi֐j̐Ԃ܂B
			[return]
			o^ĂCxgi֐j̐B
		**/
		ulong count(){return _List.count();}

		/**
			o^ĂCxgNA܂B
		**/
		void clear(){
			cbptr *it=_List.begin(),*end=_List.end();
			for(;it<end;++it) delete *it;
			_List.clear();
		}
	protected:
		CBList _List;

	};

	/**
		Cxg@\NXłB
		NX̌̐ň֐̈̐܂܂i 0 ` 6 jB
		Cxg𔭐ɂ́A֐IuWFNgĂяo܂B
		֐o^ɂ add ֐gp܂B
		o^֐́ACxgɓo^ŌĂяo܂B
	**/
	class EventList0 : public EventList{
	public:
		/**
			炩ߒǉ̈pӂč쐬܂B
			[arg]
			c	: mۂĂڐB
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		EventList0(ulong c=0):EventList(c){}

		/**
			Cxg𔭍s܂B
		**/
		void operator()(){
			CallBack **it = _List.begin(),**end = _List.end();
			for(;it<end;++it) reinterpret_cast<CallBack0v*>(*it)->call();
		}
		/**
			֐Xgɒǉ܂B
			[arg]
			f	: ǉ֐B
			[exc]
			std::bad_alloc	: Xgɒǉ邽߂̗̈mۂł܂łB
		**/
		void add(void (*f)()){addCB(newcheck(createCallBack(f)));}
		/**
			NXo֐Xgɒǉ܂B
			[arg]
			f	: ǉNXo֐B
			c	: ĂяoCX^XB
			[exc]
			std::bad_alloc	: Xgɒǉ邽߂̗̈mۂł܂łB
		**/
		template <class Class>
		void add(void (Class::*f)(),Class* c){addCB(newcheck(createCallBack(f,c)));}
		/**
			֐Xgɒǉ܂B
			łɒǉĂ֐ɌĂ΂悤ɂȂ܂B
			[arg]
			f	: ǉ֐B
			[exc]
			std::bad_alloc	: Xgɒǉ邽߂̗̈mۂł܂łB
		**/
		void addFront(void (*f)()){addCBFront(newcheck(createCallBack(f)));}
		/**
			NXo֐Xgɒǉ܂B
			łɒǉĂ֐ɌĂ΂悤ɂȂ܂B
			[arg]
			f	: ǉNXo֐B
			c	: ĂяoCX^XB
			[exc]
			std::bad_alloc	: Xgɒǉ邽߂̗̈mۂł܂łB
		**/
		template <class Class>
		void addFront(void (Class::*f)(),Class* c){addFrontCB(newcheck(createCallBack(f,c)));}
		/**
			Xg֐폜܂B
			[arg]
			f	: 폜֐B
			[return]
			폜łꍇ true AłȂꍇ false Ԃ܂B
			[note]
			֐o^ĂꍇA
			ԑĂ΂֐Xg폜܂B
		**/
		bool remove(void (*f)()){return _remove(f,NULL);}
		/**
			Xg烁o֐폜܂B
			[arg]
			f	: 폜郁o֐B
			c	: f ĂяoĂNX̃|C^B
			[return]
			폜łꍇ true AłȂꍇ false Ԃ܂B
			[note]
			֐o^ĂꍇA
			ԑĂ΂֐Xg폜܂B
		**/
		template <class Class>
		bool remove(void (Class::*f)(),const Class* c){return _remove(f,c);}

	};

/*
	L͈t̃CxgXg`̂Ɏw肵Ă}NQB
*/

#define EVENTLIST_DEF(N,TL,AL1,AL2,AL3)\
	template <TL> class EventList##N : public EventList{\
	public:\
		EventList##N(ulong c=0):EventList(c){}\
		void operator()(AL2){\
			CallBack **it = _List.begin(),**end = _List.end();\
			for(;it<end;++it) reinterpret_cast<CallBack##N##v<AL1>*>(*it)->call(AL3);\
		}\
		void add(void (*f)(AL1)){addCB(newcheck(createCallBack<AL1>(f)));}\
		template <class Class>\
		void add(void (Class::*f)(AL1),Class* c){addCB(newcheck(createCallBack<Class,AL1>(f,c)));}\
		void addFront(void (*f)(AL1)){addCBFront(newcheck(createCallBack<AL1>(f)));}\
		template <class Class>\
		void addFront(void (Class::*f)(AL1),Class* c){addCBFront(newcheck(createCallBack<Class,AL1>(f,c)));}\
		bool remove(void (*f)(AL1)){return _remove(f,NULL);}\
		template <class Class>\
		bool remove(void (Class::*f)(AL1),const Class* c){return _remove(&f,c);}\
	}

	EVENTLIST_DEF(1,TMP1L,ARG1L1,ARG1L2,ARG1L3);
	EVENTLIST_DEF(2,TMP2L,ARG2L1,ARG2L2,ARG2L3);
	EVENTLIST_DEF(3,TMP3L,ARG3L1,ARG3L2,ARG3L3);
	EVENTLIST_DEF(4,TMP4L,ARG4L1,ARG4L2,ARG4L3);
	EVENTLIST_DEF(5,TMP5L,ARG5L1,ARG5L2,ARG5L3);
	EVENTLIST_DEF(6,TMP6L,ARG6L1,ARG6L2,ARG6L3);

#undef EVENTLIST_DEF

} // namespace scpl
#endif