// 
// Queue.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _Queue_INCLUDED_
#define _Queue_INCLUDED_
#include "Container.h"

namespace scpl{

	TMP class CQueue;
	TMP class DQueue;
	BUFTMP class CFQueue;
	BUFTMP class DFQueue;

	TMP T* _queue_convRing(T* t,const T* e,ulong cap){return (e <= t)?(t - cap):t;}

	/**
		L[ǗꒊۃNXłB
	**/
	TMP class IQueue : public IContainer<T>{
	public:
		TDEF();
	protected:
		virtual ptr _data()const=0;
		virtual bool _equals(cptr p,cptr pos,ulong c,ulong size)const{
			if(p != _data()){
				if(c != count()) return false;
				else if(c != 0){
					cptr mit=_BeginPos,me=_data()+capacity();
					cptr pit=pos,pe=p+size;
					cptr mie=_queue_convRing(_BeginPos+capacity(),me,capacity())+1;
					for(;mit!=mie;++mit,++pit,++p){
						if(mit == me) mit -= capacity();
						if(pit == pe) pit -= size;
						if(*mit != *p) return false;
					}
				}
			}
			return true;
		}

	public:
		IQueue():_UseCount(0){}

		virtual ~IQueue(){}

		/**
			f[^LĂȂԂ܂B
			[return]
			f[^LĂȂꍇ true AłȂꍇ false Ԃ܂B
		**/
		virtual bool empty()const{return _UseCount == 0;}
		/**
			LĂf[^̐Ԃ܂B
			[return]
			LĂf[^̐B
		**/
		virtual ulong count()const{return _UseCount;}
		/**
			i[\̐Ԃ܂B
			[return]
			i[\B
		**/
		virtual ulong capacity()const=0;
		/**
			w肵f[^zRs[܂B
			[arg]
			p	: Rs[̃f[^zB
			c	: f[^̐B
			[exc]
			std::bad_alloc	: Rs[ɕKvȗ̈mۂłȂB
		**/
		virtual void copy(cptr data,ulong c)=0;

		/**
			f[^擾܂B
			[return]
			݂̃f[^B
			[exc]
			std::runtime_error	: f[^LĂȂB
		**/
		ind get()const{
			if(_UseCount == 0) THROW_DO_NOT_HAVE_DATA();
			return *_BeginPos;
		}

		/**
			f[^ǉ܂B
			[arg]
			data	: ǉf[^B
			[exc]
			std::runtime_error	: ǉł̈悪ȂB
		**/
		virtual void push(const T& data)=0;

		/**
			f[^o܂B
			[exc]
			std::runtime_error	: f[^LĂȂB
		**/
		virtual void pop()=0;

		/**
			w肵f[^zƈv邩Ԃ܂B
			[arg]
			p	: rf[^zB
			c	: f[^̐B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool equals(cptr p,ulong c)const{
			if(p != _data()){
				if(c != count()) return false;
				cptr mit=_BeginPos,me=_data()+capacity();
				cptr mie=_queue_convRing(_BeginPos+capacity(),me,capacity())+1;
				for(;mit!=mie;++mit,++p){
					if(mit == me) mit -= capacity();
					if(*mit != *p) return false;
				}
			}
			return true;
		}

	protected:
		ptr		_BeginPos;
		ulong	_UseCount;

	};
	/**
		ϒL[̒ۃNXłB
	**/
	TMP class IQueue_Buffer : public IQueue<T>{
	protected:
		virtual ptr _data()const{return _List.begin();}

	public:
		IQueue_Buffer(ulong c=0):_List(c){_BeginPos = _List.begin();}

		virtual ~IQueue_Buffer(){}

		/**
			cmۉ\̈ݒ肵܂B
			[arg]
			cap	: ݒ肷cmۉ\̈̐B
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		void adjust(ulong cap=0){
			long newcap = cap + capacity() - count();
			if(newcap != 0){
				if(newcap > 0){
					_List.aResize(count()+cap);
					if(_BeginPos&&(_BeginPos + count()+cap > _List.end())){
						memmove(_BeginPos+newcap,_BeginPos,static_cast<ulong>(_List.end() - _BeginPos)*sizeof(T));
					}
				}
				else{
					if(_BeginPos&&(_BeginPos + count() > _List.end())){
						memmove(_BeginPos+newcap,_BeginPos,static_cast<ulong>(_List.end() - _BeginPos)*sizeof(T));
						_BeginPos += newcap;
					}
				}
				if(_BeginPos) _BeginPos += newcap;
				else _BeginPos = _List;
			}
		}

		/**
			f[^ւ܂B
			[arg]
			s	: ւf[^B
		**/
		void _swap(IQueue_Buffer<T>* s){
			_container_swap(_List,_UseCount,s->_List,s->_UseCount);
			scpl::swap(_BeginPos,s->_BeginPos);
		}

		/**
			L̃o֐̐ IQueue NXQƂĂB
		**/
		virtual ulong capacity()const{return _List.count();}

	protected:
		Buffer<T>	_List;

	};
	/**
		Œ蒷L[̒ۃNXłB

		̃NX̃o֐̐́A IQueue_Buffer NX
		QƂĂB
	**/
	BUFTMP class IQueue_Fixed : public IQueue<T>{
	protected:
		virtual ptr _data()const{return const_cast<ptr>(_List.get());}
	public:
		IQueue_Fixed(){_BeginPos = _List;}
		virtual ~IQueue_Fixed(){}
		virtual ulong capacity()const{return C;}
		void _swap(IQueue_Fixed* s){
			_container_swap_fixed(_List,_UseCount,s->List,s->_UseCount);
			scpl::swap(_BeginPos,s->_BeginPos);
		}
	protected:
		FBuffer<T,C>	_List;
	};

	/**
		ϒNXL[ReiNXłB
		̃NX̊{@\ STL Cu queue ɑ̂łA
		֐Ȃǂ͓ł͂܂B
	**/
	TMP class CQueue : public IQueue_Buffer<T>{
		typedef CQueue<T> self;

	public:
		/**
			́A邢͎w肵̈mۂč쐬܂B
			[arg]
			c	: mۂ̈B
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		CQueue(ulong c=0):IQueue_Buffer<T>(c){}
		/**
			w肵f[^zRs[L[쐬܂B
			[arg]
			p	: Rs[̃f[^zB
			c	: f[^̐B
			[exc]
			std::bad_alloc	: Rs[ɕKvȗ̈mۂłȂB
		**/
		CQueue(cptr p,ulong c):IQueue_Buffer<T>(c){copy(p,c);}
		/**
			w肵L[̕쐬܂B
			[arg]
			s	: L[B
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		explicit CQueue(const self& s):IQueue_Buffer<T>(s.count()){copy(s.begin(),s.count());}

		/**
			fXgN^B
			f[^Sč폜܂B
		**/
		virtual ~CQueue(){clear();}

		/**
			f[^Sč폜܂B
		**/
		void clear(){_container_clear(_List,_UseCount);}

		/**
			f[^LĂ邩Ԃ܂B
			[return]
			f[^LĂꍇ true AłȂꍇ false Ԃ܂B
		**/
		operator bool()const{return !empty();}
		/**
			f[^LĂȂԂ܂B
			[return]
			f[^LĂȂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!()const{return empty();}

		/**
			w肵L[ƈv邩Ԃ܂B
			[arg]
			s	: rL[B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator==(const CQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool operator==(const DQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator==(const CFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator==(const DFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		/**
			w肵L[ƕsvԂ܂B
			[arg]
			s	: rL[B
			[return]
			sv̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!=(const CQueue<T>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool operator!=(const DQueue<T>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator!=(const CFQueue<T,N>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator!=(const DFQueue<T,N>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}

		/**
			w肵L[ƈv邩Ԃ܂B
			[arg]
			s	: rL[B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool equals(const CQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool equals(const DQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool equals(const CFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool equals(const DFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		
		/**
			w肵L[܂B
			[arg]
			s	: L[B
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		self& operator=(const CQueue<T>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const DQueue<T>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const CFQueue<T,N>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const DFQueue<T,N>& s){copy(s._data(),s.count());return *this;}

		/**
			w肵L[Ɠeւ܂B
			[arg]
			s	: ւL[B
		**/
		void swap(self& s){_swap(&s);}

		/**
			L̃o֐̐ IQueue NXQƂĂB
		**/
		virtual void push(cind data){
			if(_List.count() == _UseCount) THROW_FILLED_CAPACITY();
			::new(_queue_convRing(_BeginPos + _UseCount,_List.end(),_List.count())) T(data);
			++_UseCount;
		}
		virtual void pop(){
			if(_UseCount == 0) THROW_DO_NOT_HAVE_DATA();
			_BeginPos->~T();
			_BeginPos = _queue_convRing(_BeginPos+1,_List.end(),_List.count());
			--_UseCount;
		}
		virtual void copy(cptr data,ulong c){
			clear();
			_container_copy(data,c,_List,_UseCount);
			_BeginPos = _List.begin();
		}
	};

	/**
		ϒf[^L[ReiNXłB
		̃NX̊{@\ STL Cu queue ɑ̂łA
		֐Ȃǂ͓ł͂܂B

		̃NX̓RXgN^EfXgN^𔭐܂B
		̂߁ANXgpf[^Ǘꍇ
		CQueue gpĂB

		̃NX̃o֐ CQueue Ɠs܂B
		eo֐̐́@CQueue ̃o֐QƂĂB
	**/
	TMP class DQueue : public IQueue_Buffer<T>{
		typedef DQueue<T> self;
	public:
		DQueue(ulong c=0):IQueue_Buffer<T>(c){}
		DQueue(cptr p,ulong c):IQueue_Buffer<T>(c){copy(p,c);}
		explicit DQueue(const self& s):IQueue_Buffer<T>(s.count()){copy(s.begin(),s.count());}
		virtual ~DQueue(){}
		virtual void push(cind data){
			if(_UseCount == capacity()) THROW_FILLED_CAPACITY();
			memcpy(_queue_convRing(_BeginPos + _UseCount,_List.end(),capacity()),&data,sizeof(T));
			++_UseCount;
		}
		virtual void pop(){
			if(_UseCount == 0) THROW_DO_NOT_HAVE_DATA();
			_BeginPos = _queue_convRing(_BeginPos+1,_List.end(),capacity());
			--_UseCount;
		}
		virtual void copy(cptr data,ulong c){
			clear();
			_container_copy_n(data,c,_List,_UseCount);
			_BeginPos = _List.begin();
		}
		virtual void clear(){_UseCount = 0;}
		operator bool()const{return !empty();}
		bool operator!()const{return empty();}
		bool operator==(const CQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool operator==(const DQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator==(const CFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator==(const DFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool operator!=(const CQueue<T>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool operator!=(const DQueue<T>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator!=(const CFQueue<T,N>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator!=(const DFQueue<T,N>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool equals(const CQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool equals(const DQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool equals(const CFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool equals(const DFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		self& operator=(const CQueue<T>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const DQueue<T>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const CFQueue<T,N>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const DFQueue<T,N>& s){copy(s._data(),s.count());return *this;}
		void swap(self& s){_swap(&s);}
	};
	/**
		Œ蒷NXL[ReiNXłB
		̃NX̊{@\ STL Cu queue ɑ̂łA
		֐Ȃǂ͓ł͂܂B

		̃NX̃o֐ CQueue Ɠs܂B
		eo֐̐́@CQueue ̃o֐QƂĂB
		Œ蒷f[^߁A CQueue A DQueue ɂ Capacity ̈
		삷鏈i adjust ֐A clear ֐ clearCap j݂͑܂B
		[note]
		̃NX͌Œ蒷f[^߁A
		eʂ𒴂f[^̒ǉs std::runtime_error O
		܂B
	**/
	BUFTMP class CFQueue : public IQueue_Fixed<T,C>{
		typedef CFQueue<T,C> self;
	public:
		CFQueue():IQueue_Fixed<T,C>(){}
		CFQueue(cptr p,ulong c):IQueue_Fixed<T,C>(c){copy(p,c);}
		explicit CFQueue(const self& s):IQueue_Fixed<T,C>(s.count()){copy(s.begin(),s.count());}
		virtual ~CFQueue(){clear();}
		virtual void push(cind data){
			if(_UseCount == C) THROW_FILLED_CAPACITY();
			::new(_queue_convRing(_BeginPos + _UseCount,_List+C,C)) T(data);
			++_UseCount;
		}
		virtual void pop(){
			if(_UseCount == 0) THROW_DO_NOT_HAVE_DATA();
			_BeginPos->~T();
			_BeginPos = _queue_convRing(_BeginPos+1,_List+C,C);
			--_UseCount;
		}
		virtual void copy(cptr data,ulong c){
			clear();
			_container_copy_fixed(data,c,_List,_UseCount);
			_BeginPos = _List.begin();
		}
		virtual void clear(){_container_clear_fixed(_List,_UseCount);}
		operator bool()const{return !empty();}
		bool operator!()const{return empty();}
		bool operator==(const CQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool operator==(const DQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator==(const CFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator==(const DFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool operator!=(const CQueue<T>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool operator!=(const DQueue<T>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator!=(const CFQueue<T,N>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator!=(const DFQueue<T,N>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool equals(const CQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool equals(const DQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool equals(const CFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool equals(const DFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		self& operator=(const CQueue<T>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const DQueue<T>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const CFQueue<T,C>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const DFQueue<T,C>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const CFQueue<T,N>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const DFQueue<T,N>& s){copy(s._data(),s.count());return *this;}
		void swap(self& s){_swap(&s);}
	};
	/**
		Œ蒷f[^L[ReiNXłB
		̃NX̊{@\ STL Cu queue ɑ̂łA
		֐Ȃǂ͓ł͂܂B

		̃NX̓RXgN^EfXgN^𔭐܂B
		̂߁ANXgpf[^Ǘꍇ
		CFQueue gpĂB

		̃NX̃o֐ CFQueue Ɠs܂B
		eo֐̐́@CFQueue ̃o֐QƂĂB
		Œ蒷f[^߁A CQueue A DQueue ɂ Capacity ̈
		삷鏈i adjust ֐A clear ֐ clearCap j݂͑܂B
		[note]
		̃NX͌Œ蒷f[^߁A
		eʂ𒴂f[^̒ǉs std::runtime_error O
		܂B
	**/
	BUFTMP class DFQueue : public IQueue_Fixed<T,C>{
		typedef DFQueue<T,C> self;
	public:
		DFQueue():IQueue_Fixed<T,C>(){}
		DFQueue(cptr p,ulong c):IQueue_Fixed<T,C>(c){copy(p,c);}
		explicit DFQueue(const self& s):IQueue_Fixed<T,C>(s.count()){copy(s.begin(),s.count());}
		virtual ~DFQueue(){}
		virtual void push(cind data){
			if(_UseCount == C) THROW_FILLED_CAPACITY();
			memcpy(_queue_convRing(_BeginPos + _UseCount,_List+C,C),&data,sizeof(T));
			++_UseCount;
		}
		virtual void pop(){
			if(_UseCount == 0) THROW_DO_NOT_HAVE_DATA();
			_BeginPos = _queue_convRing(_BeginPos+1,_List+C,C);
			--_UseCount;
		}
		virtual void copy(cptr data,ulong c){
			clear();
			_container_copy_fixed_n(data,c,_List,_UseCount);
			_BeginPos = _List.begin();
		}
		virtual void clear(){_UseCount=0;}
		operator bool()const{return !empty();}
		bool operator!()const{return empty();}
		bool operator==(const CQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool operator==(const DQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator==(const CFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator==(const DFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool operator!=(const CQueue<T>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool operator!=(const DQueue<T>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator!=(const CFQueue<T,N>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool operator!=(const DFQueue<T,N>& s)const{return !_equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool equals(const CQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		bool equals(const DQueue<T>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool equals(const CFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		NTMP bool equals(const DFQueue<T,N>& s)const{return _equals(s._data(),s._BeginPos,s.count(),s.capacity());}
		self& operator=(const CQueue<T>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const DQueue<T>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const CFQueue<T,C>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const DFQueue<T,C>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const CFQueue<T,N>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const DFQueue<T,N>& s){copy(s._data(),s.count());return *this;}
		void swap(self& s){_swap(&s);}
	};

} // namespace scpl
#endif