// 
// SimStr.h
// 
// Copyright(C) 2008 Mitsunagi

#ifndef _SimStr_INCLUDED_
#define _SimStr_INCLUDED_

#include "scpl.h"
#include "exception.h"

namespace scpl{

	/**
		i[邾̂VvȃNXłB
		AString Ƃ͈ႢA̘Aϊ͖A
		̑Ɣr݂̂ƂȂĂ܂B
	**/
	class ASimStr{
	public:
		// ̃CX^X쐬܂B
		ASimStr()throw():_Str(NULL),_Len(0){}
		/**
			w肵i[܂B
			[arg]
			txt		: i[镶B
			len		: i[镶BőSĂi[܂B(ȗ)
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		ASimStr(cstr txt,int len=-1):_Str(NULL),_Len(0){set(txt,len);}
		~ASimStr(){if(_Str) delete[] _Str;}

		operator bool()const throw(){return _Str != NULL;}
		bool operator!()const throw(){return _Str == NULL;}

		bool empty()const throw(){return _Str == NULL;}
		cstr get()const throw(){return _Str;}
		uint count()const throw(){return _Len;}

		ASimStr& operator=(cstr txt){set(txt);return *this;}
		ASimStr& operator=(const ASimStr& txt){set(txt);return *this;}

		/**
			w肵i[܂B
			i[Ă͔j܂B
			[arg]
			txt		: i[镶B
			len		: i[镶BőSĂi[܂B(ȗ)
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		void set(cstr txt,int len=-1){
			int l = 0;
			str s = NULL;
			if(txt){
				l = (len<0)?static_cast<int>(strlen(txt)):len;
				s = new char[l+1];
				if(!s) THROW_BAD_ALLOC();
				strncpy_s(s,l+1,txt,l);
			}
			if(_Str) delete[] _Str;
			_Str = s;
			_Len = l;
		}
		void set(const ASimStr& txt,int len=-1){
			int l = 0;
			str s = NULL;
			if(txt){
				l = (len<0)?txt.count():len;
				s = new char[l+1];
				if(!s) THROW_BAD_ALLOC();
				strncpy_s(s,l+1,txt.get(),l);
			}
			if(_Str) delete[] _Str;
			_Str = s;
			_Len = l;
		}

		int compare(cstr txt){return compare(_Str,txt);}
		int compare(const ASimStr& txt){return compare(_Str,txt.get());}
		int icompare(cstr txt){return icompare(_Str,txt);}
		int icompare(const ASimStr& txt){return icompare(_Str,txt.get());}
		static int compare(const ASimStr& txt1,cstr txt2){return compare(txt1.get(),txt2);}
		static int compare(const ASimStr& txt1,const ASimStr& txt2){return compare(txt1.get(),txt2.get());}
		static int icompare(const ASimStr& txt1,cstr txt2){return icompare(txt1.get(),txt2);}
		static int icompare(const ASimStr& txt1,const ASimStr& txt2){return icompare(txt1.get(),txt2.get());}

	private:
		static int compare(cstr t1,cstr t2){return (t1!=NULL)?((t2!=NULL)?strcmp(t1,t2):1):((t2!=NULL)?-1:0);}
		static int icompare(cstr t1,cstr t2){return (t1!=NULL)?((t2!=NULL)?stricmp(t1,t2):1):((t2!=NULL)?-1:0);}
		str		_Str;
		uint	_Len;
	};

	class WSimStr{
	public:
		WSimStr()throw():_Str(NULL),_Len(0){}
		WSimStr(cwstr txt,int len=-1):_Str(NULL),_Len(0){set(txt,len);}
		~WSimStr(){if(_Str) delete[] _Str;}

		operator bool()const throw(){return _Str != NULL;}
		bool operator!()const throw(){return _Str == NULL;}

		bool empty()const throw(){return _Str == NULL;}
		cwstr get()const throw(){return _Str;}
		uint count()const throw(){return _Len;}

		WSimStr& operator=(cwstr txt){set(txt);return *this;}
		WSimStr& operator=(const WSimStr& txt){set(txt);return *this;}

		/**
			w肵i[܂B
			i[Ă͔j܂B
			[arg]
			txt		: i[镶B
			len		: i[镶BőSĂi[܂B(ȗ)
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		void set(cwstr txt,int len=-1){
			int l = 0;
			wstr s = NULL;
			if(txt){
				l = (len<0)?static_cast<int>(wcslen(txt)):len;
				s = new wchar_t[l+1];
				if(!s) THROW_BAD_ALLOC();
				wcsncpy_s(s,l+1,txt,l);
			}
			if(_Str) delete[] _Str;
			_Str = s;
			_Len = l;
		}
		void set(const WSimStr& txt,int len=-1){
			int l = 0;
			wstr s = NULL;
			if(txt){
				l = (len<0)?txt.count():len;
				s = new wchar_t[l+1];
				if(!s) THROW_BAD_ALLOC();
				wcsncpy_s(s,l+1,txt.get(),l);
			}
			if(_Str) delete[] _Str;
			_Str = s;
			_Len = l;
		}

		int compare(cwstr txt){return compare(_Str,txt);}
		int compare(const WSimStr& txt){return compare(_Str,txt.get());}
		int icompare(cwstr txt){return icompare(_Str,txt);}
		int icompare(const WSimStr& txt){return icompare(_Str,txt.get());}
		static int compare(const WSimStr& txt1,cwstr txt2){return compare(txt1.get(),txt2);}
		static int compare(const WSimStr& txt1,const WSimStr& txt2){return compare(txt1.get(),txt2.get());}
		static int icompare(const WSimStr& txt1,cwstr txt2){return icompare(txt1.get(),txt2);}
		static int icompare(const WSimStr& txt1,const WSimStr& txt2){return icompare(txt1.get(),txt2.get());}

	private:
		static int compare(cwstr t1,cwstr t2){return (t1!=NULL)?((t2!=NULL)?wcscmp(t1,t2):1):((t2!=NULL)?-1:0);}
		static int icompare(cwstr t1,cwstr t2){return (t1!=NULL)?((t2!=NULL)?wcsicmp(t1,t2):1):((t2!=NULL)?-1:0);}

		wstr	_Str;
		uint	_Len;
	};
	bool operator==(const ASimStr& txt1,cstr txt2){return ASimStr::compare(txt1,txt2)==0;}
	bool operator!=(const ASimStr& txt1,cstr txt2){return ASimStr::compare(txt1,txt2)!=0;}
	bool operator< (const ASimStr& txt1,cstr txt2){return ASimStr::compare(txt1,txt2)< 0;}
	bool operator<=(const ASimStr& txt1,cstr txt2){return ASimStr::compare(txt1,txt2)<=0;}
	bool operator> (const ASimStr& txt1,cstr txt2){return ASimStr::compare(txt1,txt2)> 0;}
	bool operator>=(const ASimStr& txt1,cstr txt2){return ASimStr::compare(txt1,txt2)>=0;}

	bool operator==(const WSimStr& txt1,cwstr txt2){return WSimStr::compare(txt1,txt2)==0;}
	bool operator!=(const WSimStr& txt1,cwstr txt2){return WSimStr::compare(txt1,txt2)!=0;}
	bool operator< (const WSimStr& txt1,cwstr txt2){return WSimStr::compare(txt1,txt2)< 0;}
	bool operator<=(const WSimStr& txt1,cwstr txt2){return WSimStr::compare(txt1,txt2)<=0;}
	bool operator> (const WSimStr& txt1,cwstr txt2){return WSimStr::compare(txt1,txt2)> 0;}
	bool operator>=(const WSimStr& txt1,cwstr txt2){return WSimStr::compare(txt1,txt2)>=0;}

#if defined(_UNICODE)||defined(UNICODE)
typedef WSimStr SimStr;
#else
typedef ASimStr SimStr;
#endif

} // namespace scpl
#endif // _SimStr_INCLUDED_