// 
// allocater.h
// 
// Copyright(C) 2007 Mitsunagi

#ifndef _allocater_INCLUDED_
#define _allocater_INCLUDED_

#include "scpl.h"
#include <windows.h>

namespace scpl{

	/** f[^mۂ̊{NXB **/
	class allocater{
	protected:
		allocater():_Size(NULL),_Data(NULL),_Handle(NULL){}
	public:
		virtual ~allocater(){}

		void* getData()const{return _Data;}
		ulong getSize()const{return _Size;}

	protected:
		ulong	_Size;
		void*	_Data;
		void*	_Handle;

	};

	/** C֐gpf[^mۃNXB **/
	class CAlloc : public allocater{
	public:
		CAlloc():allocater(){}
		virtual ~CAlloc(){deallocate();}

		bool allocate(ulong size,bool zeroMemory = true);
		bool reallocate(ulong size,bool zeroMemory = true,bool movable = true);
		bool deallocate();

		bool clear();
		bool fill(byte data);

	};

	/** q[vf[^mۃNXB **/
	class HAlloc : public allocater{
	public:
		HAlloc():allocater(){}
		virtual ~HAlloc(){final();}

		bool init(ulong initSize,ulong maxSize=0);
		bool final();

		bool allocate(ulong size,bool zeroMemory = true);
		bool reallocate(ulong size,bool zeroMemory = true,bool movable = true);
		bool deallocate();

		bool clear();
		bool fill(byte data);

	};

	/** zf[^mۃNXB **/
	class VAlloc : public allocater{
	public:
		VAlloc():allocater(){}
		virtual ~VAlloc(){if(_Data) release();}

		bool reserve(ulong size,bool zeroMemory = true,bool topDown = false,ulong protect = PAGE_READWRITE);
		bool commit(ulong size,bool zeroMemory = true,bool topDown = false,ulong protect = PAGE_READWRITE);
		bool decommit(){return decommitEx(_Size);}
		bool decommitEx(ulong size);
		bool release();

		bool clear();
		bool fill(byte data);

	};

} // namespace scpl
#endif // _allocater_INCLUDED_