// 
// auto_ary.h
// 
// Copyright(C) 2007 Mitsunagi

#ifndef _auto_ary_INCLUDED_
#define _auto_ary_INCLUDED_

#include "utility.h"

namespace scpl{

	/**
		z|C^ǗNXłB
		̃NX́ARXgN^Ƀ|C^i[A
		fXgN^Ƀ|C^NXłB
		setDeletable ֐gpăfXgN^
		Ȃ悤邱Ƃł܂B
		܂AL̓ɂAIɉȂ悤ɂł܂B
		[pre]
		// p ̓|C^z^̕ϐA ptr ̓|C^zNXB
		p = ptr();
		// ͈ȉ̏ƓłB
		ptr.setDeletable(false);
		p = ptr;
		[/pre]
		܂A邱ƂɂA|C^u邱Ƃł܂B
		̂Ƃ̒u|C^ setDeletable ֐Ŏw肵
		s܂B
	**/
	template<class T> class auto_ary{
		void delptr(){delete[] _Ptr;}

	public:
		typedef T*			ptr;
		typedef T&			ind;
		typedef const T*	cptr;
		typedef const T&	cind;
		typedef auto_ary<T>	self;

		/**
			NULL܂B
		**/
		auto_ary():_Deletable(false),_Ptr(NULL){}
		/**
			|C^܂B
			[arg]
			p	: z|C^B
		**/
		explicit auto_ary(T* p):_Deletable(true),_Ptr(p){}
		/**
			Rs[܂B
			Rs[ɉꍇ̂݉ړ܂B
			[arg]
			p	: |C^B
		**/
		auto_ary(self& s):_Ptr(s._Ptr),_Deletable(s._Deletable){
			if(_Deletable) s._Deletable = false;
		}

		/**
			fXgN^B
			ꍇ̂ݔz|C^܂B
		**/
		~auto_ary(){if(_Deletable&&_Ptr) delptr();}

		/**
			|C^݂邩Ԃ܂B
			[return]
			LĂ|C^݂Ȃ true AłȂꍇ false Ԃ܂B
		**/
		operator bool()const{return _Ptr;}
		/**
			|C^ԂAȂ悤ɐݒ肵܂B
			[return]
			LĂ|C^B
		**/
		ptr operator()(){_Deletable = false;return _Ptr;}
		/**
			|C^NULLԂ܂B
			[return]
			LĂ|C^ NULL Ȃ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!()const{return _Ptr==NULL;}

		/**
			|C^ꍇŉEӂɍ폜ꍇAӂ֍폜ړ܂B
			[arg]
			s	: 폜ړ|C^B
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator<<=(self& s){moveDeletable(s);return *this;}

		/**
			|C^v邩Ԃ܂B
			[arg]
			p	: r|C^B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator==(cptr p)const{return _Ptr == p;}
		bool operator==(const self& p)const{return _Ptr == p._Ptr;}
		/**
			|C^svԂ܂B
			[arg]
			p	: r|C^B
			[return]
			sv̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!=(cptr p)const{return _Ptr != p;}
		bool operator!=(const self& p)const{return _Ptr != p._Ptr;}

		/**
			w肵|C^܂B
			[arg]
			p	: z|C^B
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator=(T* p){set(p);return *this;}
		/**
			w肵|C^܂B
			[arg]
			p	: z|C^B
		**/
		void set(T* p){
			if(_Ptr != p){
				if(_Deletable&&_Ptr) delptr();
				_Ptr = p;
			}
		}

		/**
			w肵|C^NX܂B
			[arg]
			s	: |C^B
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator=(const self& s){set(s);return *this;}
		/**
			w肵|C^NX܂B
			[arg]
			s	: |C^B
		**/
		void set(const self& s){
			if(_Ptr != s._Ptr){
				if(_Deletable&&_Ptr) delptr();
				_Ptr = s._Ptr;
				_Deletable = false;
			}
		}

		/**
			|C^Ԃ܂B
			[return]
			LĂ|C^Ԃ܂B
		**/
		ptr get()const{return _Ptr;}
		ptr operator~()const{return _Ptr;}

		/**
			oQƂ܂B
			[return]
			LĂ|C^B
			[note]
			̊֐̓|C^̃`FbNsĂ܂B
			̂߁Aȃ|C^LĂꍇ͖̓`łB
		**/
		ptr operator->()const{return _Ptr;}
		/**
			w肵ʒũf[^Ԃ܂B
			[arg]
			index	: 擾f[^̈ʒu
			[return]
			w肵ʒũf[^B
			[note]
			̊֐͔͈͂̃`FbNsĂ܂B
			index ɔ͈͊Ow肵ꍇ͖̓`łB
		**/
		ind operator[](ulong index)const{return _Ptr[index];}
		ind at(ulong index)const{return _Ptr[index];}

		/**
			|C^NULLԂ܂B
			[return]
			|C^ NULL ̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool empty()const{return !_Ptr;}

		/**
			|C^ւ܂B
			[arg]
			p	: ւ|C^B
		**/
		void swap(self& p){scpl::swap(_Deletable,p._Deletable);scpl::swap(_Ptr,p._Ptr);}

		/**
			w肷|C^ꍇłɍ폜ꍇA폜ړ܂B
			[arg]
			s	: 폜ړ|C^B
		**/
		void moveDeletable(self& s){
			if((_Ptr == s._Ptr)&&s._Deletable){
				s._Deletable = false;
				_Deletable = true;
			}
		}

		/**
			f[^NA܂B
			NULL ̂ƓłB
		**/
		void clear(){if(_Deletable&&_Ptr) delptr();_Ptr = NULL;}

		/**
			̃|C^邩ǂݒ肵܂B
			[arg]
			deletable	: 邩ǂB
		**/
		void setDeletable(bool deletable){_Deletable = deletable;}

	protected:
		bool _Deletable;
		T* _Ptr;

	};

} // namespace scpl
#endif // _auto_ary_INCLUDED_