// 
// smart_ary.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _smart_ary_INCLUDED_
#define _smart_ary_INCLUDED_

#include "utility.h"
#include "exception.h"

namespace scpl{

	/**
		̃NX́AQƃJEgAQƂĂSẴ|C^
		NXȂA|C^͊J܂B

		ӓ_ƂẮAQƂĂ|C^VNXɊ܂܂Ă͂܂B
		)
		[pre]
			smart_ary<int> a(ptr),d,f;
			smart_ary<int> b(ptr);     // NG
			smart_ary<int> c(a.get()); // NG
			d = ptr;                   // NG
			smart_ary<int> e(a);       // OK
			f = a;                     // OK
		[/pre]
		Ȃ 2 ` 4 sڂ NG Ȃ̂ƌƁA 1 sڂƓ
		i|C^ւ̎QƃJEg̐jsĂ܂Aꂼ̎QƃJEg
		LłȀꍇA ptr ɑ΂ 4 ̉sĂ܂܂B
		̎d 5 ` 6 sڂłB
		 2 ` 4 sڂ̂悤ȏȂ΂ȂȂꍇ́A managed_ary NX
		gpĂB
	**/
	template<class T> class smart_ary{
	public:
		typedef T*				ptr;
		typedef T&				ind;
		typedef const T*		cptr;
		typedef const T&		cind;
		typedef smart_ary<T>	self;
	private:
		void dec_del(){if(_pm&&(_pm->dec() == 0)) delete _pm;}

		class manager{
			ulong _Count;
			T* _Ptr;

		public:
			manager(T* ptr):_Count(1),_Ptr(ptr){}
			~manager(){if(_Ptr) delptr();}

			T* get(){return _Ptr;}
			const T* get()const{return _Ptr;}
			T& at(ulong i){return _Ptr[i];}
			const T& at(ulong i)const{return _Ptr[i];}
			void delptr(){delete[] _Ptr;}
			ulong count()const{return _Count;}
			ulong inc(){return _Count?(++_Count):_Count;}
			ulong dec(){return _Count?(--_Count):_Count;}

		};

	public:

		/**
			Rs[RXgN^B
			[arg]
			p	: Rs[̃|C^B
		**/
		smart_ary(self& p){
			_pm = p._pm;
			if(p._pm) _pm->inc();
		}

		/**
			NULL ۗL܂B
		**/
		smart_ary():_pm(NULL){}
		/**
			|C^ۗL܂B
			[arg]
			p	: ۗL|C^B
			[exc]
			std::bad_alloc	: ۗL邽߂̗̈mۂłȂB
		**/
		explicit smart_ary(ptr p):_pm(NULL){if(p) _pm = newcheck(new manager(p));}

		/**
			fXgN^B
			QƃJEg炵A[ɂȂ
			܂B
		**/
		~smart_ary(){dec_del();}

		/**
			|C^݂邩Ԃ܂B
			[return]
			LĂ|C^݂Ȃ true AłȂꍇ false Ԃ܂B
		**/
		operator bool()const{return _pm;}
		/**
			|C^ NULL Ԃ܂B
			[return]
			LĂ|C^ NULL ̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!()const{return _pm==NULL;}

		/**
			|C^v邩Ԃ܂B
			[arg]
			p	: r|C^B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator==(cptr p)const{return p == (_pm?_pm->get():NULL);}
		bool operator==(const self& p)const{return _pm == p._pm;}
		/**
			|C^svԂ܂B
			[arg]
			p	: r|C^B
			[return]
			sv̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!=(cptr p)const{return p != (_pm?_pm->get():NULL);}
		bool operator!=(const self& p)const{return _pm != p._pm;}

		/**
			w肵|C^NX܂B
			[arg]
			p	: |C^NXB
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator=(const self& p){set(p);return *this;}
		/**
			w肵|C^܂B
			[arg]
			p	: |C^B
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		self& operator=(ptr p){set(p);return *this;}
		/**
			w肵|C^܂B
			[arg]
			p	: |C^NXB
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		void set(const self& p){
			dec_del();
			_pm = const_cast<manager*>(p._pm);
			if(p._pm) _pm->inc();
		}
		void set(ptr p){
			dec_del();
			_pm = p?newcheck(new manager(p)):NULL;
		}

		/**
			|C^Ԃ܂B
			[return]
			LĂ|C^B
		**/
		ptr get()const{return _pm?_pm->get():NULL;}
		ptr operator~()const{return _Ptr;}

		/**
			w肵ʒũf[^Ԃ܂B
			[arg]
			index	: f[^ւ̈ʒuB
			[return]
			w肵ʒũf[^B
			[note]
			̊֐͔͈͂̃`FbNsĂ܂B
			index ɔ͈͊Ow肵ꍇ͖̓`łB
		**/
		ind operator[](ulong index)const{return _pm->get()[index];}
		ind at(ulong index)const{return _pm->get()[index];}

		/**
			|C^ NULL Ԃ܂B
			[return]
			|C^ NULL ̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool empty()const{return !_pm;}

		/**
			QƃJEgԂ܂B
			[return]
			QƃJEgB
		**/
		ulong count()const{return _pm?_pm->count():0;}

		/**
			|C^ւ܂B
			[arg]
			p	: ւ|C^B
		**/
		void swap(self& p){scpl::swap(_pm,p._pm);}

		/**
			f[^NA܂B
			NULL ̂ƓłB
		**/
		void clear(){dec_del();_pm = NULL;}

	protected:
		manager* _pm;

	};

} // namespace scpl
#endif