// 
// AString.cpp
// 
// Copyright(C) 2006-2007 Ó
#include "stdafx.h"
#include "../scpl/AString.h"
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#if !defined(_MSC_VER) && !defined(__BORLANDC__)
#define ultoa _ultoa
#endif

namespace scpl{

	inline ulong _cap(ulong x){return (x==0)?0:x-1;}
#define _CAP _cap(capacity())

	AString& AString::_insertChar(char c,ulong index){
		if(_CAP == _UseCount) _Text.aResize(_UseCount + 2,true);
		str pos = _Text.get() + index;
		if(index != _UseCount) memmove(pos + 1,pos,(_UseCount - index) * sizeof(char));
		*pos = c;
		++_UseCount;
		*(_Text.get()+_UseCount) = 0;
		return *this;
	}
	AString& AString::_insertStr(cstr text,long count,ulong index){
		if(text && (count != 0)){
			if(count < 0) count = static_cast<long>(strlen(text));
			long cp = _UseCount+count+1;
			if(static_cast<ulong>(cp) > _CAP) _Text.aResize(cp,true);
			str pos = _Text.get() + index;
			if(index != _UseCount){
				memmove(pos + count,pos,(_UseCount - index) * sizeof(char));
			}
			memcpy(pos,text,count * sizeof(char));
			_UseCount += count;
			*(_Text.get()+_UseCount) = 0;
		}
		return *this;
	}

	AString& AString::_insertNum(long l,ulong index,long radix){
		char buf[32];
		memset(buf,0,32 * sizeof(char));
		ltoa(l,buf,radix);
		return _insertStr(buf,-1,index);
	}
	AString& AString::_insertUNum(ulong l,ulong index,long radix){
		char buf[32];
		memset(buf,0,32 * sizeof(char));
		ultoa(l,buf,radix);
		return _insertStr(buf,-1,index);
	}
	void AString::removeAt(ulong index){
		str pos = _Text.get() + index;
		if(index != --_UseCount){
			memmove(pos,pos + 1,(_UseCount - index) * sizeof(char));
		}
		*(_Text.get() + _UseCount) = 0;
	}
	void AString::erage(ulong indexL,ulong indexR){
		if(indexR != _UseCount){
			memmove(_Text.get() + indexL,_Text + indexR,(_UseCount - indexR) * sizeof(char));
		}
		memset(_Text.get() + (_UseCount - indexR + indexL),0,(indexR - indexL) * sizeof(char));
		_UseCount -= (indexR - indexL);
	}
	void AString::clear(bool noClearCapacity){
		_UseCount = 0;
		if(!noClearCapacity) _Text.clear();
		else if(_Text) *_Text.get() = 0;
	}
	void AString::copy(cstr s,long count){
		if(s && (count != 0)){
			if(count < 0) count = static_cast<long>(strlen(s));
			if(static_cast<ulong>(count+1) > _CAP){
				_Text.aResize(count+1,true);
			}
			else *(_Text.get()+count) = 0;
			memcpy(_Text.get(),s,count*sizeof(char));
			_UseCount = count;
		}
		else clear(false);
	}
	bool AString::equals(cstr s)const{return (strcmp(_Text?_Text.begin():"",s?s:"") == 0);}
	long AString::find(char c,ulong start)const{
		cstr a = strchr(_Text+start,c);
		return a? static_cast<long>(a - _Text.get()) : -1;
	}
	long AString::find(cstr c,ulong start)const{
		cstr a = strstr(_Text+start,c);
		return a? static_cast<long>(a - _Text.get()) : -1;
	}
	void AString::toLower(){
		for(long i=_UseCount - 1;0<=i;--i){
			*(_Text.get() + i) = static_cast<char>(tolower(*(_Text + i)));
		}
	}
	void AString::toUpper(){
		for(long i=_UseCount - 1;0<=i;--i){
			*(_Text.get() + i) = static_cast<char>(toupper(*(_Text + i)));
		}
	}

	AString AString::strcat(cstr a,cstr b){
		size_t as = strlen(a),bs = strlen(b);
		AString string(static_cast<ulong>(as+bs+1));
		string = a;
		string += b;
		return AString(string._Text,string._UseCount);
	}


}
