#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/AString.h>

using namespace scpl;

void sizecheck(const AString& as,ulong cnt,ulong cap){
	SUT_ASSERT_EQUALS(Int,as.count(),cnt);
	SUT_ASSERT_EQUALS(Int,as.capacity(),cap);
}

void check(const AString& as,ulong cnt,ulong cap){
	sizecheck(as,cnt,cap);
	if(!cnt){
		SUT_ASSERT(as.empty());
		SUT_CHECK(!as);
		SUT_ASSERT_EQUALS(Ptr,(cstr)as,NULL);
		SUT_ASSERT_EQUALS(Ptr,as.begin(),NULL);
		SUT_ASSERT_EQUALS(Ptr,as.end(),NULL);
		SUT_ASSERT_EQUALS(Ptr,as.rbegin(),NULL);
		SUT_ASSERT_EQUALS(Ptr,as.rend(),NULL);
	}
	else{
		SUT_ASSERT(!as.empty());
		SUT_CHECK(as != NULL);
		SUT_ASSERT_EQUALS(Ptr,(cstr)as,as.get());
		SUT_ASSERT_EQUALS(Ptr,as.begin(),as.get());
		SUT_ASSERT_EQUALS(Ptr,as.end(),as.get()+as.count());
		SUT_ASSERT_EQUALS(Ptr,as.rbegin(),as.get()+as.count()-1);
		SUT_ASSERT_EQUALS(Ptr,as.rend(),as.get()-1);
	}
}

void strcheck(const AString& as,cstr text,ulong cnt,ulong cap){
//	printf("as(%s) txt(%s)\n",as.get(),text);
	sizecheck(as,cnt,cap);
	SUT_ASSERT(as.equals(text));
}

#define flow_(F) try{F;}catch(scpl::sut::sut_assert s){printf("(In Line:%5i)\n",__LINE__);throw s;}

void ta_1(){
	AString as;
	AString as2(100);

	
	flow_(check(as,0,0));
	SUT_ASSERT(as.equals(as2));
	as.adjust(0);
	flow_(check(as,0,1));
	SUT_ASSERT(as.equals(as2));

	as.lastInStr("test text.");
	flow_(check(as,10,11));
	SUT_ASSERT(!as.equals(as2));

	SUT_ASSERT_EQUALS(Hex,as.at(0),'t');
	SUT_ASSERT_EQUALS(Hex,as.at(4),' ');
	SUT_ASSERT_EQUALS(Hex,as.at(10),'\0');
	SUT_ASSERT_EQUALS(Hex,as.atFirst(),'t');
	SUT_ASSERT_EQUALS(Hex,as.atLast(),'.');

	as2.copy(as);
	flow_(check(as2,10,100));
	SUT_ASSERT(as2.equals(as));
	SUT_ASSERT_EQUALS(Hex,as2.at(0),'t');
	SUT_ASSERT_EQUALS(Hex,as2.at(4),' ');
	SUT_ASSERT_EQUALS(Hex,as2.at(10),'\0');
	SUT_ASSERT_EQUALS(Hex,as2.atFirst(),'t');
	SUT_ASSERT_EQUALS(Hex,as2.atLast(),'.');

	as.toUpper();
	flow_(strcheck(as,"TEST TEXT.",10,11));
	as.toLower();
	flow_(strcheck(as,"test text.",10,11));

	as.firstInNum(-10);
	flow_(strcheck(as,"-10test text.",13,14));
	as.firstOut();
	flow_(strcheck(as,"10test text.",12,14));
	as.firstOut(2);
	flow_(strcheck(as,"test text.",10,14));
	as.lastOut();
	flow_(strcheck(as,"test text",9,14));
	as.lastInChar('!');
	flow_(strcheck(as,"test text!",10,14));
	as.lastInStr(" no ");
	flow_(strcheck(as,"test text! no ",14,15));
	as.lastIn(as2);
	flow_(strcheck(as,"test text! no test text.",24,25));
	as.lastOut(14);
	flow_(strcheck(as,"test text!",10,25));
	as.adjust(0);
	flow_(strcheck(as,"test text!",10,11));
	as.firstIn(as2);
	flow_(strcheck(as,"test text.test text!",20,21));
	as.lastInUNum(0xff00ff00L,16);
	flow_(strcheck(as,"test text.test text!ff00ff00",28,29));
	as.removeAt(9);
	flow_(strcheck(as,"test texttest text!ff00ff00",27,29));
	as.erage(0,9);
	flow_(strcheck(as,"test text!ff00ff00",18,29));
	
	SUT_ASSERT_EQUALS(Int,as.find('f'),10);
	SUT_ASSERT_EQUALS(Int,as.find('f',11),11);
	SUT_ASSERT_EQUALS(Int,as.find('l'),-1);
	as.copy(as2);
	flow_(strcheck(as,as2,10,29));
	as.adjust(10);
	flow_(strcheck(as,"test text.",10,21));
	as.insertChar(',',4);
	flow_(strcheck(as,"test, text.",11,21));
	as.insertStr(" string ",-1,4);
	flow_(strcheck(as,"test string , text.",19,21));
	as.erage(4,13);
	flow_(strcheck(as,"test text.",10,21));
	as.insert(as2,2);
	flow_(strcheck(as,"tetest text.st text.",20,21));
}

void ta_2(){
	AString as("test text.");
	AString as2 = AString::strcat(as,"it is ok?");

	flow_(check(as,10,11));
	SUT_ASSERT(as != as2);
	flow_(check(as2,19,20));
	SUT_ASSERT(as2 != as);

	as = 100;
	as2 = -8899;
	flow_(strcheck(as,"100",3,11));
	flow_(strcheck(as2,"-8899",5,20));
	as += 2100;
	as2 += 1899;
	flow_(strcheck(as,"1002100",7,11));
	flow_(strcheck(as2,"-88991899",9,20));
	as += "byte";
	as2 += "m";
	flow_(strcheck(as,"1002100byte",11,12));
	flow_(strcheck(as2,"-88991899m",10,20));
	as = "SUT_ASSERT";
	as2 = "SUT_ASSERT_EQUALS";
	flow_(strcheck(as,"SUT_ASSERT",10,12));
	flow_(strcheck(as2,"SUT_ASSERT_EQUALS",17,20));
	as2 = as + "(true);";
	flow_(strcheck(as2,"SUT_ASSERT(true);",17,18));
	as += " == " + as2 +  " == " + as2 + as;
	flow_(strcheck(as,"SUT_ASSERT == SUT_ASSERT(true); == SUT_ASSERT(true);SUT_ASSERT",62,63));
	const AString* asc = &as;

	SUT_ASSERT_EQUALS(Hex,asc->atFirst(),'S');
	SUT_ASSERT_EQUALS(Hex,asc->atLast(),'T');
	SUT_ASSERT_EQUALS(Int,asc->find(" == "),10);
	flow_(check(*asc,62,63));
	SUT_ASSERT(*asc == as);
	SUT_ASSERT(*asc != as2);
	as.swap(as2);
	flow_(sizecheck(*asc,17,18));
}

void test_AString(){
	ta_1();
	ta_2();
}